/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.client.particle;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GlowParticle
extends SpriteTexturedParticle {
    private static final Random RANDOM = new Random();
    private final IAnimatedSprite IAnimatedSprite;

    protected GlowParticle(ClientWorld clientWorld, double x, double y, double z, double motionX, double motionY, double motionZ, IAnimatedSprite IAnimatedSprite2) {
        super(clientWorld, x, y, z, motionX, motionY, motionZ);
        this.IAnimatedSprite = IAnimatedSprite2;
        this.field_70544_f *= 0.75f;
        this.field_190017_n = false;
        this.func_217566_b(IAnimatedSprite2);
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217603_c;
    }

    protected int func_189214_a(float tint) {
        float totalAge = ((float)this.field_70546_d + tint) / (float)this.field_70547_e;
        totalAge = MathHelper.func_76131_a((float)totalAge, (float)0.0f, (float)1.0f);
        int colorMultiplier = super.func_189214_a(tint);
        int fromRGB = colorMultiplier & 0xFF;
        int toRGB = colorMultiplier >> 16 & 0xFF;
        if ((fromRGB += (int)(totalAge * 15.0f * 16.0f)) > 240) {
            fromRGB = 240;
        }
        return fromRGB | toRGB << 16;
    }

    public void func_189213_a() {
        super.func_189213_a();
        this.func_217566_b(this.IAnimatedSprite);
    }

    static /* synthetic */ double access$1300(GlowParticle x0) {
        return x0.field_187130_j;
    }

    static /* synthetic */ double access$1600(GlowParticle x0) {
        return x0.field_187129_i;
    }

    static /* synthetic */ double access$1900(GlowParticle x0) {
        return x0.field_187131_k;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GlowFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite IAnimatedSprite;

        public GlowFactory(IAnimatedSprite IAnimatedSprite2) {
            this.IAnimatedSprite = IAnimatedSprite2;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType parameters, ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ) {
            GlowParticle glowParticle = new GlowParticle(world, x, y, z, 0.5 - RANDOM.nextDouble(), 0.5, 0.5 - RANDOM.nextDouble(), this.IAnimatedSprite);
            if (world.field_73012_v.nextBoolean()) {
                glowParticle.func_70538_b(0.6f, 1.0f, 0.8f);
            } else {
                glowParticle.func_70538_b(0.08f, 0.4f, 0.4f);
            }
            GlowParticle glowParticle2 = glowParticle;
            glowParticle2.field_187130_j = glowParticle2.field_187130_j * (double)0.2f;
            if (motionX == 0.0 && motionZ == 0.0) {
                glowParticle2 = glowParticle;
                glowParticle2.field_187129_i = glowParticle2.field_187129_i * 0.1;
                glowParticle2 = glowParticle;
                glowParticle2.field_187131_k = glowParticle2.field_187131_k * 0.1;
            }
            glowParticle.func_187114_a((int)(8.0 / (world.field_73012_v.nextDouble() * 0.8 + 0.2)));
            return glowParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WaxOnFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite IAnimatedSprite;

        public WaxOnFactory(IAnimatedSprite IAnimatedSprite2) {
            this.IAnimatedSprite = IAnimatedSprite2;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType parameters, ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ) {
            GlowParticle glowParticle = new GlowParticle(world, x, y, z, 0.0, 0.0, 0.0, this.IAnimatedSprite);
            glowParticle.func_70538_b(0.91f, 0.55f, 0.08f);
            glowParticle.field_187129_i = motionX * 0.01 / 2.0;
            glowParticle.field_187130_j = motionY * 0.01;
            glowParticle.field_187131_k = motionZ * 0.01 / 2.0;
            glowParticle.func_187114_a(world.field_73012_v.nextInt(30) + 10);
            return glowParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class WaxOffFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite IAnimatedSprite;

        public WaxOffFactory(IAnimatedSprite IAnimatedSprite2) {
            this.IAnimatedSprite = IAnimatedSprite2;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType parameters, ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ) {
            GlowParticle glowParticle = new GlowParticle(world, x, y, z, 0.0, 0.0, 0.0, this.IAnimatedSprite);
            glowParticle.func_70538_b(1.0f, 0.9f, 1.0f);
            glowParticle.field_187129_i = motionX * 0.01 / 2.0;
            glowParticle.field_187130_j = motionY * 0.01;
            glowParticle.field_187131_k = motionZ * 0.01 / 2.0;
            glowParticle.func_187114_a(world.field_73012_v.nextInt(30) + 10);
            return glowParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ElectricSparkFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite IAnimatedSprite;

        public ElectricSparkFactory(IAnimatedSprite IAnimatedSprite2) {
            this.IAnimatedSprite = IAnimatedSprite2;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType parameters, ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ) {
            GlowParticle glowParticle = new GlowParticle(world, x, y, z, 0.0, 0.0, 0.0, this.IAnimatedSprite);
            glowParticle.func_70538_b(1.0f, 0.9f, 1.0f);
            glowParticle.field_187129_i = motionX * 0.25;
            glowParticle.field_187130_j = motionY * 0.25;
            glowParticle.field_187131_k = motionZ * 0.25;
            glowParticle.func_187114_a(world.field_73012_v.nextInt(2) + 2);
            return glowParticle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ScrapeFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite IAnimatedSprite;

        public ScrapeFactory(IAnimatedSprite IAnimatedSprite2) {
            this.IAnimatedSprite = IAnimatedSprite2;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType parameters, ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ) {
            GlowParticle glowParticle = new GlowParticle(world, x, y, z, 0.0, 0.0, 0.0, this.IAnimatedSprite);
            if (world.field_73012_v.nextBoolean()) {
                glowParticle.func_70538_b(0.29f, 0.58f, 0.51f);
            } else {
                glowParticle.func_70538_b(0.43f, 0.77f, 0.62f);
            }
            glowParticle.field_187129_i = motionX * 0.01;
            glowParticle.field_187130_j = motionY * 0.01;
            glowParticle.field_187131_k = motionZ * 0.01;
            glowParticle.func_187114_a(world.field_73012_v.nextInt(30) + 10);
            return glowParticle;
        }
    }
}

