/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.client.renderer.entity;

import com.blackgear.cavesandcliffs.common.entity.GlowSquidEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.SquidModel;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GlowSquidRenderer
extends MobRenderer<GlowSquidEntity, SquidModel<GlowSquidEntity>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("cavesandcliffs", "textures/entity/squid/glow_squid.png");

    public GlowSquidRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, (EntityModel)new SquidModel(), 0.7f);
    }

    public ResourceLocation getEntityTexture(GlowSquidEntity entity) {
        return TEXTURE;
    }

    protected int getBlockLight(GlowSquidEntity entityIn, BlockPos partialTicks) {
        int light = (int)MathHelper.func_151238_b((double)0.0, (double)15.0, (double)(1.0f - (float)entityIn.getDarkTicksRemaining() / 10.0f));
        return light == 15 ? 15 : Math.max(light, super.func_225624_a_((Entity)entityIn, partialTicks));
    }

    protected void applyRotations(GlowSquidEntity entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        float squidPitch = MathHelper.func_219799_g((float)partialTicks, (float)entityLiving.field_70862_e, (float)entityLiving.field_70861_d);
        float squidYaw = MathHelper.func_219799_g((float)partialTicks, (float)entityLiving.field_70860_g, (float)entityLiving.field_70859_f);
        matrixStackIn.func_227861_a_(0.0, 0.5, 0.0);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotationYaw));
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(squidPitch));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(squidYaw));
        matrixStackIn.func_227861_a_(0.0, (double)-1.2f, 0.0);
    }

    protected float handleRotationFloat(GlowSquidEntity livingBase, float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)livingBase.field_70865_by, (float)livingBase.field_70866_j);
    }
}

