/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.client.renderer.entity.model;

import com.blackgear.cavesandcliffs.common.entity.AxolotlEntity;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AxolotlModel<T extends AxolotlEntity>
extends AgeableModel<T> {
    private final ModelRenderer body;
    private final ModelRenderer right_arm;
    private final ModelRenderer right_leg;
    private final ModelRenderer left_arm;
    private final ModelRenderer left_leg;
    private final ModelRenderer tail;
    private final ModelRenderer head;
    private final ModelRenderer left_gills;
    private final ModelRenderer right_gills;
    private final ModelRenderer top_gills;

    public AxolotlModel() {
        super(true, 8.0f, 3.35f);
        this.field_78089_u = 64;
        this.field_78090_t = 64;
        this.body = new ModelRenderer((Model)this);
        this.body.func_78793_a(0.0f, 20.0f, 5.0f);
        this.body.func_78784_a(0, 11).func_228303_a_(-4.0f, -2.0f, -9.0f, 8.0f, 4.0f, 10.0f, 0.0f, false);
        this.body.func_78784_a(2, 17).func_228303_a_(0.0f, -3.0f, -8.0f, 0.0f, 5.0f, 9.0f, 0.0f, false);
        this.right_arm = new ModelRenderer((Model)this);
        this.right_arm.func_78793_a(-3.5f, 1.0f, -8.0f);
        this.body.func_78792_a(this.right_arm);
        this.right_arm.func_78784_a(2, 13).func_228303_a_(-1.0f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, 0.001f, false);
        this.right_leg = new ModelRenderer((Model)this);
        this.right_leg.func_78793_a(-3.5f, 1.0f, -1.0f);
        this.body.func_78792_a(this.right_leg);
        this.right_leg.func_78784_a(2, 13).func_228303_a_(-1.0f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, 0.001f, false);
        this.left_arm = new ModelRenderer((Model)this);
        this.left_arm.func_78793_a(3.5f, 1.0f, -8.0f);
        this.body.func_78792_a(this.left_arm);
        this.left_arm.func_78784_a(2, 13).func_228303_a_(-2.0f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, 0.001f, false);
        this.left_leg = new ModelRenderer((Model)this);
        this.left_leg.func_78793_a(3.5f, 1.0f, -1.0f);
        this.body.func_78792_a(this.left_leg);
        this.left_leg.func_78784_a(2, 13).func_228303_a_(-2.0f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, 0.001f, false);
        this.tail = new ModelRenderer((Model)this);
        this.tail.func_78793_a(0.0f, 0.0f, 1.0f);
        this.body.func_78792_a(this.tail);
        this.tail.func_78784_a(2, 19).func_228303_a_(0.0f, -3.0f, 0.0f, 0.0f, 5.0f, 12.0f, 0.0f, false);
        this.head = new ModelRenderer((Model)this);
        this.head.func_78793_a(0.0f, 0.0f, -9.0f);
        this.body.func_78792_a(this.head);
        this.head.func_78784_a(0, 1).func_228303_a_(-4.0f, -3.0f, -5.0f, 8.0f, 5.0f, 5.0f, 0.0f, false);
        this.left_gills = new ModelRenderer((Model)this);
        this.left_gills.func_78793_a(-4.0f, 0.0f, -1.0f);
        this.head.func_78792_a(this.left_gills);
        this.left_gills.func_78784_a(0, 40).func_228303_a_(-3.0f, -5.0f, 0.0f, 3.0f, 7.0f, 0.0f, 0.001f, false);
        this.right_gills = new ModelRenderer((Model)this);
        this.right_gills.func_78793_a(4.0f, 0.0f, -1.0f);
        this.head.func_78792_a(this.right_gills);
        this.right_gills.func_78784_a(11, 40).func_228303_a_(0.0f, -5.0f, 0.0f, 3.0f, 7.0f, 0.0f, 0.001f, false);
        this.top_gills = new ModelRenderer((Model)this);
        this.top_gills.func_78793_a(0.0f, -3.0f, -1.0f);
        this.head.func_78792_a(this.top_gills);
        this.top_gills.func_78784_a(3, 37).func_228303_a_(-4.0f, -3.0f, 0.0f, 8.0f, 3.0f, 0.0f, 0.001f, false);
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body);
    }

    public void setRotationAngles(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetAngles(entityIn, netHeadYaw, headPitch);
        if (((AxolotlEntity)entityIn).isPlayingDead()) {
            this.setPlayingDeadAngles(netHeadYaw);
        } else {
            boolean movesHorizontally;
            boolean bl = movesHorizontally = Entity.func_213296_b((Vector3d)entityIn.func_213322_ci()) > 1.0E-7 || ((AxolotlEntity)entityIn).field_70125_A != ((AxolotlEntity)entityIn).field_70127_C || ((AxolotlEntity)entityIn).field_70177_z != ((AxolotlEntity)entityIn).field_70126_B || ((AxolotlEntity)entityIn).field_70142_S != entityIn.func_226277_ct_() || ((AxolotlEntity)entityIn).field_70136_U != entityIn.func_226281_cx_();
            if (entityIn.func_203005_aq()) {
                if (movesHorizontally) {
                    this.setMovingInWaterAngles(ageInTicks, headPitch);
                } else {
                    this.setStandingInWaterAngles(ageInTicks);
                }
            } else if (entityIn.func_233570_aj_()) {
                if (movesHorizontally) {
                    this.setMovingOnGroundAngles(ageInTicks, netHeadYaw);
                } else {
                    this.setStandingOnGroundAngles(ageInTicks, netHeadYaw);
                }
            }
        }
        this.updateAnglesMap(entityIn);
    }

    private void updateAnglesMap(T axolotl) {
        Map<String, Vector3f> angles = ((AxolotlEntity)axolotl).getModelAngles();
        angles.put("body", this.getAngles(this.body));
        angles.put("head", this.getAngles(this.head));
        angles.put("right_hind_leg", this.getAngles(this.right_leg));
        angles.put("left_hind_leg", this.getAngles(this.left_leg));
        angles.put("right_front_leg", this.getAngles(this.right_arm));
        angles.put("left_front_leg", this.getAngles(this.left_arm));
        angles.put("tail", this.getAngles(this.tail));
        angles.put("top_gills", this.getAngles(this.top_gills));
        angles.put("left_gills", this.getAngles(this.left_gills));
        angles.put("right_gills", this.getAngles(this.right_gills));
    }

    private Vector3f getAngles(ModelRenderer modelRenderer) {
        return new Vector3f(modelRenderer.field_78795_f, modelRenderer.field_78796_g, modelRenderer.field_78808_h);
    }

    private void setAngles(ModelRenderer modelRenderer, Vector3f angles) {
        this.setAngles(modelRenderer, angles.func_195899_a(), angles.func_195900_b(), angles.func_195902_c());
    }

    public void setAngles(ModelRenderer modelRenderer, float pitch, float yaw, float roll) {
        modelRenderer.field_78795_f = pitch;
        modelRenderer.field_78796_g = yaw;
        modelRenderer.field_78808_h = roll;
    }

    private void resetAngles(T axolotl, float headYaw, float headPitch) {
        this.body.field_78800_c = 0.0f;
        this.head.field_78797_d = 0.0f;
        this.body.field_78797_d = 20.0f;
        Map<String, Vector3f> angles = ((AxolotlEntity)axolotl).getModelAngles();
        if (angles.isEmpty()) {
            this.setAngles(this.body, headPitch * 0.02f, headYaw * 0.02f, 0.0f);
            this.setAngles(this.head, 0.0f, 0.0f, 0.0f);
            this.setAngles(this.left_leg, 0.0f, 0.0f, 0.0f);
            this.setAngles(this.right_leg, 0.0f, 0.0f, 0.0f);
            this.setAngles(this.left_arm, 0.0f, 0.0f, 0.0f);
            this.setAngles(this.right_arm, 0.0f, 0.0f, 0.0f);
            this.setAngles(this.left_gills, 0.0f, 0.0f, 0.0f);
            this.setAngles(this.right_gills, 0.0f, 0.0f, 0.0f);
            this.setAngles(this.top_gills, 0.0f, 0.0f, 0.0f);
            this.setAngles(this.tail, 0.0f, 0.0f, 0.0f);
        } else {
            this.setAngles(this.body, angles.get("body"));
            this.setAngles(this.head, angles.get("head"));
            this.setAngles(this.left_leg, angles.get("left_hind_leg"));
            this.setAngles(this.right_leg, angles.get("right_hind_leg"));
            this.setAngles(this.left_arm, angles.get("left_front_leg"));
            this.setAngles(this.right_arm, angles.get("right_front_leg"));
            this.setAngles(this.left_gills, angles.get("left_gills"));
            this.setAngles(this.right_gills, angles.get("right_gills"));
            this.setAngles(this.top_gills, angles.get("top_gills"));
            this.setAngles(this.tail, angles.get("tail"));
        }
    }

    private float lerpAngleDegrees(float start, float end) {
        return this.lerpAngleDegrees(0.05f, start, end);
    }

    private float lerpAngleDegrees(float delta, float start, float end) {
        return MathHelper.func_219805_h((float)delta, (float)start, (float)end);
    }

    private void setAngle(ModelRenderer modelRenderer, float pitch, float yaw, float roll) {
        this.setAngles(modelRenderer, this.lerpAngleDegrees(modelRenderer.field_78795_f, pitch), this.lerpAngleDegrees(modelRenderer.field_78796_g, yaw), this.lerpAngleDegrees(modelRenderer.field_78808_h, roll));
    }

    private void setStandingOnGroundAngles(float ageInTicks, float netHeadYaw) {
        float age = ageInTicks * 0.09f;
        float sinAngle = MathHelper.func_76126_a((float)age);
        float cosAngle = MathHelper.func_76134_b((float)age);
        float j = sinAngle * sinAngle - 2.0f * sinAngle;
        float k = cosAngle * cosAngle - 3.0f * sinAngle;
        this.head.field_78795_f = this.lerpAngleDegrees(this.head.field_78795_f, -0.09f * j);
        this.head.field_78796_g = this.lerpAngleDegrees(this.head.field_78796_g, 0.0f);
        this.head.field_78808_h = this.lerpAngleDegrees(this.head.field_78808_h, -0.2f);
        this.tail.field_78796_g = this.lerpAngleDegrees(this.tail.field_78796_g, -0.1f + 0.1f * j);
        this.top_gills.field_78795_f = this.lerpAngleDegrees(this.top_gills.field_78795_f, 0.6f + 0.05f * k);
        this.left_gills.field_78796_g = this.lerpAngleDegrees(this.left_gills.field_78796_g, -this.top_gills.field_78795_f);
        this.right_gills.field_78796_g = this.lerpAngleDegrees(this.right_gills.field_78796_g, -this.left_gills.field_78796_g);
        this.setAngle(this.left_leg, 1.1f, 1.0f, 0.0f);
        this.setAngle(this.left_arm, 0.8f, 2.3f, -0.5f);
        this.copyLegAngles();
        this.body.field_78795_f = this.lerpAngleDegrees(0.2f, this.body.field_78795_f, 0.0f);
        this.body.field_78796_g = this.lerpAngleDegrees(this.body.field_78796_g, netHeadYaw * 0.02f);
        this.body.field_78808_h = this.lerpAngleDegrees(this.body.field_78808_h, 0.0f);
    }

    private void setMovingOnGroundAngles(float ageInTicks, float netHeadYaw) {
        float age = ageInTicks * 0.11f;
        float angle = MathHelper.func_76134_b((float)age);
        float hindYaw = (angle * angle - 2.0f * angle) / 5.0f;
        float frontYaw = 0.7f * angle;
        this.head.field_78795_f = this.lerpAngleDegrees(this.head.field_78795_f, 0.0f);
        this.head.field_78796_g = this.lerpAngleDegrees(this.head.field_78796_g, 0.09f * angle);
        this.head.field_78808_h = this.lerpAngleDegrees(this.head.field_78808_h, 0.0f);
        this.tail.field_78796_g = this.lerpAngleDegrees(this.tail.field_78796_g, this.head.field_78796_g);
        this.top_gills.field_78795_f = this.lerpAngleDegrees(this.top_gills.field_78795_f, 0.6f - 0.08f * (angle * angle + 2.0f * MathHelper.func_76126_a((float)age)));
        this.left_gills.field_78796_g = this.lerpAngleDegrees(this.left_gills.field_78796_g, -this.top_gills.field_78795_f);
        this.right_gills.field_78796_g = this.lerpAngleDegrees(this.right_gills.field_78796_g, -this.left_gills.field_78796_g);
        this.setAngle(this.left_leg, 0.9f, 1.5f - hindYaw, -0.1f);
        this.setAngle(this.left_arm, 1.1f, 1.6f - frontYaw, 0.0f);
        this.setAngle(this.right_leg, this.left_leg.field_78795_f, -1.0f - hindYaw, 0.0f);
        this.setAngle(this.right_arm, this.left_arm.field_78795_f, -1.6f - frontYaw, 0.0f);
        this.body.field_78795_f = this.lerpAngleDegrees(0.2f, this.body.field_78795_f, 0.0f);
        this.body.field_78796_g = this.lerpAngleDegrees(this.body.field_78796_g, netHeadYaw * 0.02f);
        this.body.field_78808_h = this.lerpAngleDegrees(this.body.field_78808_h, 0.0f);
    }

    private void setStandingInWaterAngles(float ageInTicks) {
        float age = ageInTicks * 0.075f;
        float cosAngle = MathHelper.func_76134_b((float)age);
        float sinAngle = MathHelper.func_76126_a((float)age) * 0.15f;
        this.body.field_78795_f = this.lerpAngleDegrees(this.body.field_78795_f, -0.15f + 0.075f * cosAngle);
        ModelRenderer body = this.body;
        body.field_78797_d -= sinAngle;
        this.head.field_78795_f = this.lerpAngleDegrees(this.head.field_78795_f, -this.body.field_78795_f);
        this.top_gills.field_78795_f = this.lerpAngleDegrees(this.top_gills.field_78795_f, 0.2f * cosAngle);
        this.left_gills.field_78796_g = this.lerpAngleDegrees(this.left_gills.field_78796_g, -0.3f * cosAngle - 0.2f);
        this.right_gills.field_78796_g = this.lerpAngleDegrees(this.right_gills.field_78796_g, -this.left_gills.field_78796_g);
        this.setAngles(this.left_leg, 2.4f - cosAngle * 0.11f, 0.5f, 1.7f);
        this.setAngles(this.left_arm, 0.8f - cosAngle * 0.2f, 2.04f, 0.0f);
        this.copyLegAngles();
        this.tail.field_78796_g = this.lerpAngleDegrees(this.tail.field_78796_g, 0.5f * cosAngle);
        this.head.field_78796_g = this.lerpAngleDegrees(this.head.field_78796_g, 0.0f);
        this.head.field_78808_h = this.lerpAngleDegrees(this.head.field_78808_h, 0.0f);
    }

    private void setMovingInWaterAngles(float ageInTicks, float headPitch) {
        float age = ageInTicks * 0.33f;
        float sinAngle = MathHelper.func_76126_a((float)age);
        float cosAngle = MathHelper.func_76134_b((float)age);
        float xAngle = 0.13f * sinAngle;
        this.body.field_78795_f = this.lerpAngleDegrees(0.1f, this.body.field_78795_f, headPitch * 0.02f + xAngle);
        this.head.field_78795_f = -xAngle * 1.8f;
        ModelRenderer body = this.body;
        body.field_78797_d -= 0.45f * cosAngle;
        this.top_gills.field_78795_f = this.lerpAngleDegrees(this.top_gills.field_78795_f, -0.5f * sinAngle - 0.8f);
        this.left_gills.field_78796_g = this.lerpAngleDegrees(this.left_gills.field_78796_g, 0.3f * sinAngle + 0.9f);
        this.right_gills.field_78796_g = this.lerpAngleDegrees(this.right_gills.field_78796_g, -this.left_gills.field_78796_g);
        this.tail.field_78796_g = this.lerpAngleDegrees(this.tail.field_78796_g, 0.3f * MathHelper.func_76134_b((float)(age * 0.9f)));
        this.setAngle(this.left_leg, 1.9f, -0.4f * sinAngle, 1.6f);
        this.setAngle(this.left_arm, 1.9f, -0.2f * cosAngle - 0.1f, 1.6f);
        this.copyLegAngles();
        this.head.field_78796_g = this.lerpAngleDegrees(this.head.field_78796_g, 0.0f);
        this.head.field_78808_h = this.lerpAngleDegrees(this.head.field_78808_h, 0.0f);
    }

    private void setPlayingDeadAngles(float netHeadYaw) {
        this.setAngle(this.left_leg, 1.4f, 1.1f, 0.8f);
        this.setAngle(this.left_arm, 0.8f, 2.0f, 0.0f);
        this.body.field_78795_f = this.lerpAngleDegrees(this.body.field_78795_f, -0.15f);
        this.body.field_78808_h = this.lerpAngleDegrees(this.body.field_78808_h, 0.35f);
        this.copyLegAngles();
        this.body.field_78796_g = this.lerpAngleDegrees(this.body.field_78796_g, netHeadYaw * 0.02f);
        this.head.field_78795_f = this.lerpAngleDegrees(this.head.field_78795_f, 0.0f);
        this.head.field_78796_g = this.lerpAngleDegrees(this.head.field_78796_g, 0.0f);
        this.head.field_78808_h = this.lerpAngleDegrees(this.head.field_78808_h, 0.0f);
        this.tail.field_78796_g = this.lerpAngleDegrees(this.tail.field_78796_g, 0.0f);
        this.setAngle(this.top_gills, 0.0f, 0.0f, 0.0f);
        this.setAngle(this.left_gills, 0.0f, 0.0f, 0.0f);
        this.setAngle(this.right_gills, 0.0f, 0.0f, 0.0f);
    }

    private void copyLegAngles() {
        this.setAngles(this.right_leg, this.left_leg.field_78795_f, -this.left_leg.field_78796_g, -this.left_leg.field_78808_h);
        this.setAngles(this.right_arm, this.left_arm.field_78795_f, -this.left_arm.field_78796_g, -this.left_arm.field_78808_h);
    }
}

