/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common;

import com.blackgear.cavesandcliffs.common.entity.AxolotlEntity;
import com.blackgear.cavesandcliffs.common.entity.GlowSquidEntity;
import com.blackgear.cavesandcliffs.common.entity.GoatEntity;
import com.blackgear.cavesandcliffs.common.util.EntityHelper;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBEntityTypes;
import com.blackgear.cavesandcliffs.mixin.EntitySpawnPlacementRegistryAccessor;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.gen.Heightmap;

public class EntityManager {
    public static final EntitySpawnPlacementRegistry.PlacementType IN_LOCAL_WATER = EntitySpawnPlacementRegistry.PlacementType.create((String)"in_local_water", (worldIn, pos, entityType) -> {
        FluidState fluidState = worldIn.func_204610_c(pos);
        BlockPos blockPos = pos.func_177984_a();
        return fluidState.func_206884_a((ITag)FluidTags.field_206959_a) && !worldIn.func_180495_p(blockPos).func_215686_e((IBlockReader)worldIn, blockPos);
    });

    public static void registerSpawnPlacements() {
        EntityManager.register((EntityType)CCBEntityTypes.AXOLOTL.get(), IN_LOCAL_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AxolotlEntity::canSpawn);
        EntityManager.register((EntityType)CCBEntityTypes.GLOW_SQUID.get(), IN_LOCAL_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, GlowSquidEntity::canSpawn);
        EntityManager.register((EntityType)CCBEntityTypes.GOAT.get(), EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, GoatEntity::canSpawn);
        EntityManager.register(EntityType.field_204262_at, IN_LOCAL_WATER, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EntityHelper::canTropicalFishSpawn);
    }

    public static <T extends MobEntity> void register(EntityType<T> entityTypeIn, EntitySpawnPlacementRegistry.PlacementType placementType, Heightmap.Type heightMapType, EntitySpawnPlacementRegistry.IPlacementPredicate<T> placementPredicate) {
        EntitySpawnPlacementRegistry.Entry entry = EntitySpawnPlacementRegistryAccessor.getREGISTRY().put(entityTypeIn, new EntitySpawnPlacementRegistry.Entry(heightMapType, placementType, placementPredicate));
        if (entry != null) {
            EntitySpawnPlacementRegistryAccessor.getREGISTRY().replace(entityTypeIn, new EntitySpawnPlacementRegistry.Entry(heightMapType, placementType, placementPredicate));
        }
    }
}

