/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import com.blackgear.cavesandcliffs.common.blocks.BigDripleafStemBlock;
import com.blackgear.cavesandcliffs.common.blocks.BlockProperties;
import com.blackgear.cavesandcliffs.common.blocks.enums.Tilt;
import com.blackgear.cavesandcliffs.common.math.MathUtils;
import com.blackgear.cavesandcliffs.common.util.BlockUtils;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BigDripleafBlock
extends HorizontalBlock
implements IGrowable,
IWaterLoggable {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final EnumProperty<Tilt> TILT = BlockProperties.TILT;
    private static final Object2IntMap<Tilt> NEXT_TILT_DELAYS = (Object2IntMap)Util.func_200696_a((Object)new Object2IntArrayMap(), delays -> {
        delays.defaultReturnValue(-1);
        delays.put((Object)Tilt.UNSTABLE, 10);
        delays.put((Object)Tilt.PARTIAL, 10);
        delays.put((Object)Tilt.FULL, 100);
    });
    private static final Map<Tilt, VoxelShape> SHAPES_FOR_TILT = ImmutableMap.of((Object)((Object)Tilt.NONE), (Object)Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (Object)((Object)Tilt.UNSTABLE), (Object)Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (Object)((Object)Tilt.PARTIAL), (Object)Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), (Object)((Object)Tilt.FULL), (Object)VoxelShapes.func_197880_a());
    private static final VoxelShape BASE_SHAPE = Block.func_208617_a((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<Direction, VoxelShape> SHAPES_FOR_DIRECTION = ImmutableMap.of((Object)Direction.NORTH, (Object)VoxelShapes.func_197882_b((VoxelShape)BigDripleafStemBlock.NORTH_SHAPE, (VoxelShape)BASE_SHAPE, (IBooleanFunction)IBooleanFunction.field_223234_e_), (Object)Direction.SOUTH, (Object)VoxelShapes.func_197882_b((VoxelShape)BigDripleafStemBlock.SOUTH_SHAPE, (VoxelShape)BASE_SHAPE, (IBooleanFunction)IBooleanFunction.field_223234_e_), (Object)Direction.EAST, (Object)VoxelShapes.func_197882_b((VoxelShape)BigDripleafStemBlock.EAST_SHAPE, (VoxelShape)BASE_SHAPE, (IBooleanFunction)IBooleanFunction.field_223234_e_), (Object)Direction.WEST, (Object)VoxelShapes.func_197882_b((VoxelShape)BigDripleafStemBlock.WEST_SHAPE, (VoxelShape)BASE_SHAPE, (IBooleanFunction)IBooleanFunction.field_223234_e_));
    private final Map<BlockState, VoxelShape> shapes;

    public BigDripleafBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a(TILT, (Comparable)((Object)Tilt.NONE)));
        this.shapes = BlockUtils.getShapesForStates((Block)this, BigDripleafBlock::getShapeForState);
    }

    private static VoxelShape getShapeForState(BlockState state) {
        return VoxelShapes.func_197872_a((VoxelShape)SHAPES_FOR_TILT.get(state.func_177229_b(TILT)), (VoxelShape)SHAPES_FOR_DIRECTION.get(state.func_177229_b((Property)field_185512_D)));
    }

    public static void grow(IWorld worldIn, Random rand, BlockPos pos, Direction direction) {
        int maxDripleafHeight;
        int length = MathHelper.func_76136_a((Random)rand, (int)2, (int)5);
        BlockPos.Mutable mutable = pos.func_239590_i_();
        for (maxDripleafHeight = 0; maxDripleafHeight < length && BigDripleafBlock.canGrowInto((BlockPos)mutable, worldIn.func_180495_p((BlockPos)mutable)); ++maxDripleafHeight) {
            mutable.func_189536_c(Direction.UP);
        }
        int dripleafStemHeight = pos.func_177956_o() + maxDripleafHeight - 1;
        mutable.func_185336_p(pos.func_177956_o());
        while (mutable.func_177956_o() < dripleafStemHeight) {
            BigDripleafStemBlock.placeStemAt(worldIn, (BlockPos)mutable, worldIn.func_204610_c((BlockPos)mutable), direction);
            mutable.func_189536_c(Direction.UP);
        }
        BigDripleafBlock.placeDripleafAt(worldIn, (BlockPos)mutable, worldIn.func_204610_c((BlockPos)mutable), direction);
    }

    private static boolean canGrowInto(BlockState state) {
        return state.func_196958_f() || state.func_203425_a(Blocks.field_150355_j) || state.func_203425_a((Block)CCBBlocks.SMALL_DRIPLEAF.get());
    }

    protected static boolean canGrowInto(BlockPos pos, BlockState state) {
        return !World.func_189509_E((BlockPos)pos) && BigDripleafBlock.canGrowInto(state);
    }

    protected static boolean placeDripleafAt(IWorld worldIn, BlockPos pos, FluidState fluidState, Direction direction) {
        BlockState state = (BlockState)((BlockState)((Block)CCBBlocks.BIG_DRIPLEAF.get()).func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(BlockUtils.isFluidEqualAndStill(fluidState, (Fluid)Fluids.field_204546_a)))).func_206870_a((Property)field_185512_D, (Comparable)direction);
        return worldIn.func_180501_a(pos, state, 3);
    }

    public void func_220066_a(World worldIn, BlockState state, BlockRayTraceResult hit, ProjectileEntity projectile) {
        this.changeTilt(state, worldIn, hit.func_216350_a(), Tilt.FULL, (SoundEvent)CCBSoundEvents.BLOCK_BIG_DRIPLEAF_TILT_DOWN.get());
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockPos = pos.func_177977_b();
        BlockState blockState = worldIn.func_180495_p(blockPos);
        return blockState.func_203425_a((Block)CCBBlocks.BIG_DRIPLEAF_STEM.get()) || blockState.func_203425_a((Block)this) || blockState.func_224755_d((IBlockReader)worldIn, blockPos, Direction.UP);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing == Direction.UP && facingState.func_203425_a((Block)this) ? BlockUtils.getStateWithProperties((Block)CCBBlocks.BIG_DRIPLEAF_STEM.get(), stateIn) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        BlockState blockState = worldIn.func_180495_p(pos.func_177984_a());
        return BigDripleafBlock.canGrowInto(blockState);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        BlockState blockState;
        BlockPos blockPos = pos.func_177984_a();
        if (BigDripleafBlock.canGrowInto(blockPos, blockState = worldIn.func_180495_p(blockPos))) {
            Direction direction = (Direction)state.func_177229_b((Property)field_185512_D);
            BigDripleafStemBlock.placeStemAt((IWorld)worldIn, pos, state.func_204520_s(), direction);
            BigDripleafBlock.placeDripleafAt((IWorld)worldIn, blockPos, blockState.func_204520_s(), direction);
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.func_201670_d() && state.func_177229_b(TILT) == Tilt.NONE && this.isEntityAbove(pos, entityIn) && !worldIn.func_175640_z(pos)) {
            this.changeTilt(state, worldIn, pos, Tilt.UNSTABLE, null);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (worldIn.func_175640_z(pos)) {
            this.resetTilt(state, (World)worldIn, pos);
        } else {
            Tilt tilt = (Tilt)((Object)state.func_177229_b(TILT));
            if (tilt == Tilt.UNSTABLE) {
                this.changeTilt(state, (World)worldIn, pos, Tilt.PARTIAL, (SoundEvent)CCBSoundEvents.BLOCK_BIG_DRIPLEAF_TILT_DOWN.get());
            } else if (tilt == Tilt.PARTIAL) {
                this.changeTilt(state, (World)worldIn, pos, Tilt.FULL, (SoundEvent)CCBSoundEvents.BLOCK_BIG_DRIPLEAF_TILT_DOWN.get());
            } else if (tilt == Tilt.FULL) {
                this.resetTilt(state, (World)worldIn, pos);
            }
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.func_175640_z(pos)) {
            this.resetTilt(state, worldIn, pos);
        }
    }

    private void playTiltSound(World world, BlockPos pos, SoundEvent sound) {
        float pitch = MathUtils.nextBetween(world.func_201674_k(), 0.8f, 1.2f);
        world.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, pitch);
    }

    private boolean isEntityAbove(BlockPos pos, Entity entity) {
        return entity.func_233570_aj_() && entity.func_226278_cu_() > (double)((float)pos.func_177956_o() + 0.7f);
    }

    private void changeTilt(BlockState state, World world, BlockPos pos, Tilt tilt, SoundEvent sound) {
        int tiltDelay;
        this.changeTilt(state, world, pos, tilt);
        if (sound != null) {
            this.playTiltSound(world, pos, sound);
        }
        if ((tiltDelay = NEXT_TILT_DELAYS.getInt((Object)tilt)) != -1) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, tiltDelay);
        }
    }

    private void resetTilt(BlockState state, World world, BlockPos pos) {
        this.changeTilt(state, world, pos, Tilt.NONE);
        if (state.func_177229_b(TILT) != Tilt.NONE) {
            this.playTiltSound(world, pos, (SoundEvent)CCBSoundEvents.BLOCK_BIG_DRIPLEAF_TILT_UP.get());
        }
    }

    private void changeTilt(BlockState state, World world, BlockPos pos, Tilt tilt) {
        world.func_180501_a(pos, (BlockState)state.func_206870_a(TILT, (Comparable)((Object)tilt)), 2);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES_FOR_TILT.get(state.func_177229_b(TILT));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes.get(state);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockState = context.func_195991_k().func_180495_p(context.func_195995_a().func_177977_b());
        FluidState fluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean isBigDripleaf = blockState.func_203425_a((Block)CCBBlocks.BIG_DRIPLEAF.get()) || blockState.func_203425_a((Block)CCBBlocks.BIG_DRIPLEAF_STEM.get());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(BlockUtils.isFluidEqualAndStill(fluidState, (Fluid)Fluids.field_204546_a)))).func_206870_a((Property)field_185512_D, (Comparable)(isBigDripleaf ? (Direction)blockState.func_177229_b((Property)field_185512_D) : context.func_195992_f().func_176734_d()));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED, field_185512_D, TILT});
    }
}

