/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import com.blackgear.cavesandcliffs.common.blocks.BigDripleafBlock;
import com.blackgear.cavesandcliffs.common.util.BlockUtils;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BigDripleafStemBlock
extends HorizontalBlock
implements IGrowable,
IWaterLoggable {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape NORTH_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)9.0, (double)11.0, (double)16.0, (double)15.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)1.0, (double)11.0, (double)16.0, (double)7.0);
    protected static final VoxelShape EAST_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)5.0, (double)7.0, (double)16.0, (double)11.0);
    protected static final VoxelShape WEST_SHAPE = Block.func_208617_a((double)9.0, (double)0.0, (double)5.0, (double)15.0, (double)16.0, (double)11.0);

    public BigDripleafStemBlock(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)field_185512_D)) {
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            default: {
                return NORTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: 
        }
        return EAST_SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED, field_185512_D});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState bottomState = worldIn.func_180495_p(pos.func_177977_b());
        BlockState topState = worldIn.func_180495_p(pos.func_177984_a());
        return !(!bottomState.func_203425_a((Block)this) && !bottomState.func_224755_d((IBlockReader)worldIn, pos.func_177977_b(), Direction.UP) || !topState.func_203425_a((Block)this) && !topState.func_203425_a((Block)CCBBlocks.BIG_DRIPLEAF.get()));
    }

    protected static void placeStemAt(IWorld worldIn, BlockPos pos, FluidState fluidState, Direction direction) {
        BlockState state = (BlockState)((BlockState)((Block)CCBBlocks.BIG_DRIPLEAF_STEM.get()).func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(BlockUtils.isFluidEqualAndStill(fluidState, (Fluid)Fluids.field_204546_a)))).func_206870_a((Property)field_185512_D, (Comparable)direction);
        worldIn.func_180501_a(pos, state, 3);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!(facing != Direction.DOWN && facing != Direction.UP || stateIn.func_196955_c((IWorldReader)worldIn, currentPos))) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        Optional<BlockPos> stemPosition = BlockUtils.isTopConnectedTo(worldIn, pos, state.func_177230_c(), Direction.UP, (Block)CCBBlocks.BIG_DRIPLEAF.get());
        if (!stemPosition.isPresent()) {
            return false;
        }
        BlockPos topPos = stemPosition.get().func_177984_a();
        BlockState blockState = worldIn.func_180495_p(topPos);
        return BigDripleafBlock.canGrowInto(topPos, blockState);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        Optional<BlockPos> stemPosition = BlockUtils.isTopConnectedTo((IBlockReader)worldIn, pos, state.func_177230_c(), Direction.UP, (Block)CCBBlocks.BIG_DRIPLEAF.get());
        if (stemPosition.isPresent()) {
            BlockPos blockPos = stemPosition.get();
            BlockPos topPos = blockPos.func_177984_a();
            Direction direction = (Direction)state.func_177229_b((Property)field_185512_D);
            BigDripleafStemBlock.placeStemAt((IWorld)worldIn, blockPos, worldIn.func_204610_c(blockPos), direction);
            BigDripleafBlock.placeDripleafAt((IWorld)worldIn, topPos, worldIn.func_204610_c(topPos), direction);
        }
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)CCBBlocks.BIG_DRIPLEAF.get());
    }
}

