/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CauldronBlock;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public interface ICauldron {
    default public double getFluidHeight(BlockState state) {
        return 0.0;
    }

    default public boolean isEntityTouchingFluid(BlockState state, BlockPos pos, Entity entity) {
        return entity.func_226278_cu_() < (double)pos.func_177956_o() + this.getFluidHeight(state) && entity.func_174813_aQ().field_72337_e > (double)pos.func_177956_o() + 0.25;
    }

    public boolean isFull(BlockState var1);

    public static boolean canFillWithPrecipitation(World world) {
        return world.field_73012_v.nextInt(20) == 1;
    }

    default public void precipitationTick(BlockState state, World world, BlockPos pos, Biome.RainType precipitation) {
        if (ICauldron.canFillWithPrecipitation(world)) {
            if (precipitation == Biome.RainType.RAIN) {
                if ((Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a) < 3) {
                    world.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)CauldronBlock.field_176591_a), 2);
                }
            } else if (precipitation == Biome.RainType.SNOW && (Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a) < 3) {
                world.func_180501_a(pos, (BlockState)((Block)CCBBlocks.POWDER_SNOW_CAULDRON.get()).func_176223_P().func_235896_a_((Property)CauldronBlock.field_176591_a), 2);
            }
        }
    }

    default public boolean canBeFilledByDripstone(Fluid fluid) {
        return false;
    }

    default public void fillFromDripstone(BlockState state, World world, BlockPos pos, Fluid fluid) {
        if (!this.isFull(state)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)CauldronBlock.field_176591_a, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a) + 1)));
        }
    }
}

