/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import com.blackgear.cavesandcliffs.common.blocks.BlockProperties;
import com.blackgear.cavesandcliffs.common.blocks.ICauldron;
import com.blackgear.cavesandcliffs.common.blocks.ILandingBlock;
import com.blackgear.cavesandcliffs.common.blocks.IModdedBlock;
import com.blackgear.cavesandcliffs.common.blocks.enums.Thickness;
import com.blackgear.cavesandcliffs.common.entity.CCBFallingBlockEntity;
import com.blackgear.cavesandcliffs.common.math.DirectionUtils;
import com.blackgear.cavesandcliffs.common.util.BlockUtils;
import com.blackgear.cavesandcliffs.common.util.WorldEvents;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.CCBParticleTypes;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PointedDripstoneBlock
extends Block
implements IModdedBlock,
ILandingBlock,
IWaterLoggable {
    public static final DirectionProperty VERTICAL_DIRECTION = BlockProperties.VERTICAL_DIRECTION;
    public static final EnumProperty<Thickness> THICKNESS = BlockProperties.THICKNESS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape UP_TIP_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape DOWN_TIP_SHAPE = Block.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape BASE_SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public PointedDripstoneBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)VERTICAL_DIRECTION, (Comparable)Direction.UP)).func_206870_a(THICKNESS, (Comparable)((Object)Thickness.TIP))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{VERTICAL_DIRECTION, THICKNESS, WATERLOGGED});
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return PointedDripstoneBlock.canPlaceAtWithDirection(worldIn, pos, (Direction)state.func_177229_b((Property)VERTICAL_DIRECTION));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (facing != Direction.UP && facing != Direction.DOWN) {
            return stateIn;
        }
        Direction verticalDirection = (Direction)stateIn.func_177229_b((Property)VERTICAL_DIRECTION);
        if (verticalDirection == Direction.DOWN && worldIn.func_205220_G_().func_205361_b(currentPos, (Object)this)) {
            return stateIn;
        }
        if (facing == verticalDirection.func_176734_d() && !this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos)) {
            if (verticalDirection == Direction.DOWN) {
                this.scheduleFall(stateIn, worldIn, currentPos);
            } else {
                worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
            }
            return stateIn;
        }
        boolean tryMerge = stateIn.func_177229_b(THICKNESS) == Thickness.TIP_MERGE;
        Thickness thickness = PointedDripstoneBlock.getThickness((IWorldReader)worldIn, currentPos, verticalDirection, tryMerge);
        return (BlockState)stateIn.func_206870_a(THICKNESS, (Comparable)((Object)thickness));
    }

    public void func_220066_a(World worldIn, BlockState state, BlockRayTraceResult hit, ProjectileEntity projectile) {
        BlockPos pos = hit.func_216350_a();
        if (!worldIn.func_201670_d() && projectile instanceof TridentEntity && projectile.func_213322_ci().func_72433_c() > 0.6) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        BlockState state = worldIn.func_180495_p(pos);
        if (state.func_177229_b((Property)VERTICAL_DIRECTION) == Direction.UP && state.func_177229_b(THICKNESS) == Thickness.TIP) {
            entityIn.func_225503_b_(fallDistance + 2.0f, 2.0f);
        } else {
            super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        }
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        float chance;
        if (PointedDripstoneBlock.canDrip(stateIn) && (chance = rand.nextFloat()) <= 0.12f) {
            PointedDripstoneBlock.getFluid(worldIn, pos, stateIn).filter(fluid -> chance < 0.02f || PointedDripstoneBlock.isFluidLiquid(fluid)).ifPresent(fluid -> PointedDripstoneBlock.createParticle(worldIn, pos, stateIn, fluid));
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (PointedDripstoneBlock.isPointingUp(state) && !this.func_196260_a(state, (IWorldReader)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        } else {
            PointedDripstoneBlock.spawnFallingBlock(state, worldIn, pos);
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        PointedDripstoneBlock.dripTick(state, worldIn, pos, random.nextFloat());
        if (random.nextFloat() < 0.011377778f && PointedDripstoneBlock.isHeldByPointedDripstone(state, (IWorldReader)worldIn, pos)) {
            PointedDripstoneBlock.tryGrow(state, worldIn, pos, random);
        }
    }

    public static void dripTick(BlockState state, ServerWorld world, BlockPos pos, float dripChance) {
        if ((dripChance <= 0.17578125f || dripChance <= 0.05859375f) && PointedDripstoneBlock.isHeldByPointedDripstone(state, (IWorldReader)world, pos)) {
            BlockPos cauldronPos;
            BlockPos tipPos;
            float chance;
            Fluid dripFluid = PointedDripstoneBlock.getDripFluid((World)world, pos);
            if (dripFluid.func_207187_a((Fluid)Fluids.field_204546_a)) {
                chance = 0.17578125f;
            } else {
                if (!dripFluid.func_207187_a((Fluid)Fluids.field_204547_b)) {
                    return;
                }
                chance = 0.05859375f;
            }
            if (dripChance < chance && (tipPos = PointedDripstoneBlock.getTipPos(state, (IWorld)world, pos, 11, false)) != null && (cauldronPos = PointedDripstoneBlock.getCauldronPos((World)world, tipPos, dripFluid)) != null) {
                WorldEvents.syncWorldEvent((World)world, 1504, tipPos, 0);
                int falloff = tipPos.func_177956_o() - cauldronPos.func_177956_o();
                int scheduledTime = 50 + falloff;
                BlockState blockState = world.func_180495_p(cauldronPos);
                world.func_205220_G_().func_205360_a(cauldronPos, (Object)blockState.func_177230_c(), scheduledTime);
            }
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction;
        BlockPos pos;
        World worldIn = context.func_195991_k();
        Direction validDirection = PointedDripstoneBlock.getDirectionToPlaceAt((IWorldReader)worldIn, pos = context.func_195995_a(), direction = DirectionUtils.getVerticalPlayerLookDirection(context).func_176734_d());
        if (validDirection == null) {
            return null;
        }
        boolean tryMerge = !context.func_225518_g_();
        Thickness thickness = PointedDripstoneBlock.getThickness((IWorldReader)worldIn, pos, validDirection, tryMerge);
        return thickness == null ? null : (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)VERTICAL_DIRECTION, (Comparable)validDirection)).func_206870_a(THICKNESS, (Comparable)((Object)thickness))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.func_204610_c(pos).func_206886_c().func_207187_a((Fluid)Fluids.field_204546_a)));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Thickness thickness = (Thickness)((Object)state.func_177229_b(THICKNESS));
        VoxelShape shape = thickness == Thickness.TIP_MERGE ? TIP_MERGE_SHAPE : (thickness == Thickness.TIP ? (state.func_177229_b((Property)VERTICAL_DIRECTION) == Direction.DOWN ? DOWN_TIP_SHAPE : UP_TIP_SHAPE) : (thickness == Thickness.FRUSTUM ? BASE_SHAPE : (thickness == Thickness.MIDDLE ? FRUSTUM_SHAPE : MIDDLE_SHAPE)));
        Vector3d offset = state.func_191059_e(worldIn, pos);
        return shape.func_197751_a(offset.field_72450_a, 0.0, offset.field_72449_c);
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.XZ;
    }

    @Override
    public float getMaxModelOffset() {
        return 0.125f;
    }

    @Override
    public void onDestroyedOnLanding(World world, BlockPos pos, CCBFallingBlockEntity fallingBlockEntity) {
        if (!fallingBlockEntity.func_174814_R()) {
            WorldEvents.syncWorldEvent(world, 1045, pos, 0);
        }
    }

    @Override
    public DamageSource getDamageSource() {
        return ILandingBlock.super.getDamageSource();
    }

    @Override
    public Predicate<Entity> getEntityPredicate() {
        return EntityPredicates.field_188444_d.and(entity -> entity.func_70089_S() && entity instanceof LivingEntity);
    }

    private void scheduleFall(BlockState state, IWorld worldIn, BlockPos pos) {
        BlockPos tipPos = PointedDripstoneBlock.getTipPos(state, worldIn, pos, Integer.MAX_VALUE, true);
        if (tipPos != null) {
            BlockPos.Mutable mutable = tipPos.func_239590_i_();
            while (PointedDripstoneBlock.isPointingDown(worldIn.func_180495_p((BlockPos)mutable))) {
                worldIn.func_205220_G_().func_205360_a((BlockPos)mutable, (Object)this, 2);
                mutable.func_189536_c(Direction.UP);
            }
        }
    }

    private static int getStalactiteSize(ServerWorld world, BlockPos pos, int range) {
        int length;
        BlockPos.Mutable mutable = pos.func_239590_i_().func_189536_c(Direction.UP);
        for (length = 1; length < range && PointedDripstoneBlock.isPointingDown(world.func_180495_p((BlockPos)mutable)); ++length) {
            mutable.func_189536_c(Direction.UP);
        }
        return length;
    }

    private static void spawnFallingBlock(BlockState state, ServerWorld world, BlockPos pos) {
        Vector3d centeredPos = Vector3d.func_237489_a_((Vector3i)pos);
        CCBFallingBlockEntity fallingBlockEntity = new CCBFallingBlockEntity((World)world, centeredPos.field_72450_a, centeredPos.field_72448_b, centeredPos.field_72449_c, state);
        if (PointedDripstoneBlock.isTip(state, true)) {
            int stalactiteSize = PointedDripstoneBlock.getStalactiteSize(world, pos, 6);
            float fallHurtAmount = 1.0f * (float)stalactiteSize;
            fallingBlockEntity.setHurtEntities(fallHurtAmount, 40);
        }
        world.func_217376_c((Entity)fallingBlockEntity);
    }

    public static void tryGrow(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        BlockState blockState;
        BlockPos tipPos;
        BlockState waterState;
        BlockState dripstoneBlockState = world.func_180495_p(pos.func_177981_b(1));
        if (PointedDripstoneBlock.canGrow(dripstoneBlockState, waterState = world.func_180495_p(pos.func_177981_b(2))) && (tipPos = PointedDripstoneBlock.getTipPos(state, (IWorld)world, pos, 7, false)) != null && PointedDripstoneBlock.canDrip(blockState = world.func_180495_p(tipPos)) && PointedDripstoneBlock.canGrow(blockState, world, tipPos)) {
            if (rand.nextBoolean()) {
                PointedDripstoneBlock.tryGrow(world, tipPos, Direction.DOWN);
            } else {
                PointedDripstoneBlock.tryGrowStalagmite(world, tipPos);
            }
        }
    }

    private static void tryGrowStalagmite(ServerWorld world, BlockPos pos) {
        BlockPos.Mutable mutable = pos.func_239590_i_();
        for (int i = 0; i < 10; ++i) {
            mutable.func_189536_c(Direction.DOWN);
            BlockState state = world.func_180495_p((BlockPos)mutable);
            if (!state.func_204520_s().func_206888_e()) {
                return;
            }
            if (PointedDripstoneBlock.isTip(state, Direction.UP) && PointedDripstoneBlock.canGrow(state, world, (BlockPos)mutable)) {
                PointedDripstoneBlock.tryGrow(world, (BlockPos)mutable, Direction.UP);
                return;
            }
            if (!PointedDripstoneBlock.canPlaceAtWithDirection((IWorldReader)world, (BlockPos)mutable, Direction.UP) || BlockUtils.isWater((IWorldReader)world, mutable.func_177977_b())) continue;
            PointedDripstoneBlock.tryGrow(world, mutable.func_177977_b(), Direction.UP);
            return;
        }
    }

    private static void tryGrow(ServerWorld world, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.func_177972_a(direction);
        BlockState state = world.func_180495_p(blockPos);
        if (PointedDripstoneBlock.isTip(state, direction.func_176734_d())) {
            PointedDripstoneBlock.growMerged(state, (IWorld)world, blockPos);
        } else if (state.func_196958_f() || state.func_203425_a(Blocks.field_150355_j)) {
            PointedDripstoneBlock.place((IWorld)world, blockPos, direction, Thickness.TIP);
        }
    }

    private static void place(IWorld worldIn, BlockPos pos, Direction direction, Thickness thickness) {
        BlockState state = (BlockState)((BlockState)((BlockState)((Block)CCBBlocks.POINTED_DRIPSTONE.get()).func_176223_P().func_206870_a((Property)VERTICAL_DIRECTION, (Comparable)direction)).func_206870_a(THICKNESS, (Comparable)((Object)thickness))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.func_204610_c(pos).func_206886_c().func_207187_a((Fluid)Fluids.field_204546_a)));
        worldIn.func_180501_a(pos, state, 3);
    }

    private static void growMerged(BlockState state, IWorld worldIn, BlockPos pos) {
        BlockPos stalactitePos;
        BlockPos stalagmitePos;
        if (state.func_177229_b((Property)VERTICAL_DIRECTION) == Direction.UP) {
            stalagmitePos = pos;
            stalactitePos = pos.func_177984_a();
        } else {
            stalactitePos = pos;
            stalagmitePos = pos.func_177977_b();
        }
        PointedDripstoneBlock.place(worldIn, stalactitePos, Direction.DOWN, Thickness.TIP_MERGE);
        PointedDripstoneBlock.place(worldIn, stalagmitePos, Direction.UP, Thickness.TIP_MERGE);
    }

    public static void createParticle(World world, BlockPos pos, BlockState state) {
        PointedDripstoneBlock.getFluid(world, pos, state).ifPresent(fluid -> PointedDripstoneBlock.createParticle(world, pos, state, fluid));
    }

    private static void createParticle(World world, BlockPos pos, BlockState state, Fluid fluid) {
        Vector3d offset = state.func_191059_e((IBlockReader)world, pos);
        double x = (double)pos.func_177958_n() + 0.5 + offset.field_72450_a;
        double y = (double)((float)(pos.func_177956_o() + 1) - 0.6875f) - 0.0625;
        double z = (double)pos.func_177952_p() + 0.5 + offset.field_72449_c;
        Fluid dripFluid = PointedDripstoneBlock.getDripFluid(world, fluid);
        IParticleData particleData = dripFluid.func_207185_a((ITag)FluidTags.field_206960_b) ? (IParticleData)CCBParticleTypes.DRIPPING_DRIPSTONE_LAVA.get() : (IParticleData)CCBParticleTypes.DRIPPING_DRIPSTONE_WATER.get();
        world.func_195594_a(particleData, x, y, z, 0.0, 0.0, 0.0);
    }

    private static BlockPos getTipPos(BlockState state, IWorld worldIn, BlockPos pos, int range, boolean allowMerged) {
        if (PointedDripstoneBlock.isTip(state, allowMerged)) {
            return pos;
        }
        Direction verticalDirection = (Direction)state.func_177229_b((Property)VERTICAL_DIRECTION);
        Predicate<BlockState> continueIf = stateIn -> stateIn.func_203425_a((Block)CCBBlocks.POINTED_DRIPSTONE.get()) && stateIn.func_177229_b((Property)VERTICAL_DIRECTION) == verticalDirection;
        return PointedDripstoneBlock.searchInDirection(worldIn, pos, verticalDirection.func_176743_c(), continueIf, stateIn -> PointedDripstoneBlock.isTip(stateIn, allowMerged), range).orElse(null);
    }

    private static Direction getDirectionToPlaceAt(IWorldReader worldIn, BlockPos pos, Direction direction) {
        Direction validDirection;
        if (PointedDripstoneBlock.canPlaceAtWithDirection(worldIn, pos, direction)) {
            validDirection = direction;
        } else {
            if (!PointedDripstoneBlock.canPlaceAtWithDirection(worldIn, pos, direction.func_176734_d())) {
                return null;
            }
            validDirection = direction.func_176734_d();
        }
        return validDirection;
    }

    private static Thickness getThickness(IWorldReader worldIn, BlockPos pos, Direction direction, boolean tryMerge) {
        Direction oppositeDirection = direction.func_176734_d();
        BlockState state = worldIn.func_180495_p(pos.func_177972_a(direction));
        if (PointedDripstoneBlock.isPointedDripstoneFacingDirection(state, oppositeDirection)) {
            return !tryMerge && state.func_177229_b(THICKNESS) != Thickness.TIP_MERGE ? Thickness.TIP : Thickness.TIP_MERGE;
        }
        if (!PointedDripstoneBlock.isPointedDripstoneFacingDirection(state, direction)) {
            return Thickness.TIP;
        }
        Thickness thickness = (Thickness)((Object)state.func_177229_b(THICKNESS));
        if (thickness != Thickness.TIP && thickness != Thickness.TIP_MERGE) {
            BlockState oppositeState = worldIn.func_180495_p(pos.func_177972_a(oppositeDirection));
            return !PointedDripstoneBlock.isPointedDripstoneFacingDirection(oppositeState, direction) ? Thickness.BASE : Thickness.MIDDLE;
        }
        return Thickness.FRUSTUM;
    }

    public static boolean canDrip(BlockState state) {
        return PointedDripstoneBlock.isPointingDown(state) && state.func_177229_b(THICKNESS) == Thickness.TIP && (Boolean)state.func_177229_b((Property)WATERLOGGED) == false;
    }

    private static boolean canGrow(BlockState state, ServerWorld world, BlockPos pos) {
        Direction verticalDirection = (Direction)state.func_177229_b((Property)VERTICAL_DIRECTION);
        BlockPos blockPos = pos.func_177972_a(verticalDirection);
        BlockState blockState = world.func_180495_p(blockPos);
        if (!blockState.func_204520_s().func_206888_e()) {
            return false;
        }
        return blockState.func_196958_f() || PointedDripstoneBlock.isTip(blockState, verticalDirection.func_176734_d());
    }

    private static Optional<BlockPos> getSupportingPos(World world, BlockPos pos, BlockState state, int range) {
        Direction verticalDirection = (Direction)state.func_177229_b((Property)VERTICAL_DIRECTION);
        Predicate<BlockState> continueIf = stateIn -> stateIn.func_203425_a((Block)CCBBlocks.POINTED_DRIPSTONE.get()) && stateIn.func_177229_b((Property)VERTICAL_DIRECTION) == verticalDirection;
        return PointedDripstoneBlock.searchInDirection((IWorld)world, pos, verticalDirection.func_176734_d().func_176743_c(), continueIf, stateIn -> !stateIn.func_203425_a((Block)CCBBlocks.POINTED_DRIPSTONE.get()), range);
    }

    private static boolean canPlaceAtWithDirection(IWorldReader worldIn, BlockPos pos, Direction direction) {
        BlockPos opposite = pos.func_177972_a(direction.func_176734_d());
        BlockState state = worldIn.func_180495_p(opposite);
        return state.func_224755_d((IBlockReader)worldIn, opposite, direction) || PointedDripstoneBlock.isPointedDripstoneFacingDirection(state, direction);
    }

    private static boolean isTip(BlockState state, boolean allowMerged) {
        if (!state.func_203425_a((Block)CCBBlocks.POINTED_DRIPSTONE.get())) {
            return false;
        }
        Thickness thickness = (Thickness)((Object)state.func_177229_b(THICKNESS));
        return thickness == Thickness.TIP || allowMerged && thickness == Thickness.TIP_MERGE;
    }

    private static boolean isTip(BlockState state, Direction direction) {
        return PointedDripstoneBlock.isTip(state, false) && state.func_177229_b((Property)VERTICAL_DIRECTION) == direction;
    }

    private static boolean isPointingDown(BlockState state) {
        return PointedDripstoneBlock.isPointedDripstoneFacingDirection(state, Direction.DOWN);
    }

    private static boolean isPointingUp(BlockState state) {
        return PointedDripstoneBlock.isPointedDripstoneFacingDirection(state, Direction.UP);
    }

    private static boolean isHeldByPointedDripstone(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return PointedDripstoneBlock.isPointingDown(state) && !worldIn.func_180495_p(pos.func_177984_a()).func_203425_a((Block)CCBBlocks.POINTED_DRIPSTONE.get());
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    private static boolean isPointedDripstoneFacingDirection(BlockState state, Direction direction) {
        return state.func_203425_a((Block)CCBBlocks.POINTED_DRIPSTONE.get()) && state.func_177229_b((Property)VERTICAL_DIRECTION) == direction;
    }

    private static BlockPos getCauldronPos(World world, BlockPos pos, Fluid fluid) {
        Predicate<BlockState> predicate = state -> state.func_177230_c() instanceof ICauldron && ((ICauldron)state.func_177230_c()).canBeFilledByDripstone(fluid);
        return PointedDripstoneBlock.searchInDirection((IWorld)world, pos, Direction.DOWN.func_176743_c(), AbstractBlock.AbstractBlockState::func_196958_f, predicate, 11).orElse(null);
    }

    public static BlockPos getDripPos(World world, BlockPos pos) {
        return PointedDripstoneBlock.searchInDirection((IWorld)world, pos, Direction.UP.func_176743_c(), AbstractBlock.AbstractBlockState::func_196958_f, PointedDripstoneBlock::canDrip, 11).orElse(null);
    }

    public static Fluid getDripFluid(World world, BlockPos pos) {
        return PointedDripstoneBlock.getFluid(world, pos, world.func_180495_p(pos)).filter(PointedDripstoneBlock::isFluidLiquid).orElse(Fluids.field_204541_a);
    }

    private static Optional<Fluid> getFluid(World world, BlockPos pos, BlockState state) {
        return !PointedDripstoneBlock.isPointingDown(state) ? Optional.empty() : PointedDripstoneBlock.getSupportingPos(world, pos, state, 11).map(position -> world.func_204610_c(position.func_177984_a()).func_206886_c());
    }

    private static boolean isFluidLiquid(Fluid fluid) {
        return fluid.func_207187_a((Fluid)Fluids.field_204547_b) || fluid.func_207187_a((Fluid)Fluids.field_204546_a);
    }

    private static boolean canGrow(BlockState dripstoneBlockState, BlockState waterState) {
        return dripstoneBlockState.func_203425_a((Block)CCBBlocks.DRIPSTONE_BLOCK.get()) && waterState.func_203425_a(Blocks.field_150355_j) && waterState.func_204520_s().func_206889_d();
    }

    private static Fluid getDripFluid(World world, Fluid fluid) {
        if (fluid.func_207187_a(Fluids.field_204541_a)) {
            return world.func_230315_m_().func_236040_e_() ? Fluids.field_204547_b : Fluids.field_204546_a;
        }
        return fluid;
    }

    private static Optional<BlockPos> searchInDirection(IWorld worldIn, BlockPos pos, Direction.AxisDirection direction, Predicate<BlockState> continuePredicate, Predicate<BlockState> stopPredicate, int range) {
        Direction verticalDirection = Direction.func_181076_a((Direction.AxisDirection)direction, (Direction.Axis)Direction.Axis.Y);
        BlockPos.Mutable mutable = pos.func_239590_i_();
        for (int i = 1; i < range; ++i) {
            mutable.func_189536_c(verticalDirection);
            BlockState state = worldIn.func_180495_p((BlockPos)mutable);
            if (stopPredicate.test(state)) {
                return Optional.of(mutable.func_185334_h());
            }
            if (!World.func_217405_b((int)mutable.func_177956_o()) && continuePredicate.test(state)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }
}

