/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.blocks;

import com.blackgear.cavesandcliffs.common.blocks.IModdedBlock;
import com.blackgear.cavesandcliffs.common.entity.CCBFallingBlockEntity;
import com.blackgear.cavesandcliffs.common.entity.IFreezeable;
import com.blackgear.cavesandcliffs.common.item.ItemUsage;
import com.blackgear.cavesandcliffs.common.math.MathUtils;
import com.blackgear.cavesandcliffs.core.other.tags.CCBEntityTypeTags;
import com.blackgear.cavesandcliffs.core.registries.CCBItems;
import com.blackgear.cavesandcliffs.core.registries.CCBParticleTypes;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.EntitySelectionContext;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PowderSnowBlock
extends Block
implements IModdedBlock {
    private static final VoxelShape COLLISION_SHAPE = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.9f, (double)1.0);

    public PowderSnowBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.func_203425_a((Block)this) || super.func_200122_a(state, adjacentBlockState, side);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack input = player.func_184586_b(handIn);
        if (input.func_77973_b() == Items.field_151133_ar) {
            player.func_184185_a((SoundEvent)CCBSoundEvents.ITEM_BUCKET_FILL_POWDER_SNOW.get(), 1.0f, 1.0f);
            ItemStack output = new ItemStack((IItemProvider)CCBItems.POWDER_SNOW_BUCKET.get());
            ItemStack stack = ItemUsage.exchangeStack(input, player, output, false);
            player.func_184611_a(handIn, stack);
            if (!worldIn.func_201670_d()) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, output);
            }
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            return ActionResultType.func_233537_a_((boolean)worldIn.func_201670_d());
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!(entityIn instanceof LivingEntity) || worldIn.func_180495_p(entityIn.func_233580_cy_()).func_203425_a((Block)this)) {
            entityIn.func_213295_a(state, new Vector3d((double)0.9f, 1.5, (double)0.9f));
            if (worldIn.func_201670_d()) {
                boolean isMoving;
                Random random = worldIn.func_201674_k();
                boolean bl = isMoving = entityIn.field_70142_S != entityIn.func_226277_ct_() || entityIn.field_70136_U != entityIn.func_226281_cx_();
                if (isMoving && random.nextBoolean()) {
                    worldIn.func_195594_a((IParticleData)CCBParticleTypes.SNOWFLAKE.get(), entityIn.func_226277_ct_(), (double)(pos.func_177956_o() + 1), entityIn.func_226281_cx_(), (double)(MathUtils.nextBetween(random, -1.0f, 1.0f) * 0.08f), 0.05, (double)(MathUtils.nextBetween(random, -1.0f, 1.0f) * 0.08f));
                }
            }
        }
        if (entityIn instanceof LivingEntity) {
            ((IFreezeable)entityIn).setInPowderSnow(true);
        }
        if (!worldIn.func_201670_d()) {
            if (entityIn.func_70027_ad() && (worldIn.func_82736_K().func_223586_b(GameRules.field_223599_b) || entityIn instanceof PlayerEntity)) {
                worldIn.func_175655_b(pos, false);
            }
            entityIn.func_70066_B();
        }
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        EntitySelectionContext entitySelectionContext;
        Optional<Entity> ctxEntity;
        if (context instanceof EntitySelectionContext && (ctxEntity = Optional.ofNullable((entitySelectionContext = (EntitySelectionContext)context).getEntity())).isPresent()) {
            boolean isFallingBlock;
            Entity entity = ctxEntity.get();
            if (entity.field_70143_R > 2.5f) {
                return COLLISION_SHAPE;
            }
            boolean bl = isFallingBlock = entity instanceof FallingBlockEntity || entity instanceof CCBFallingBlockEntity;
            if (isFallingBlock || PowderSnowBlock.canWalkOnPowderSnow(entity) && context.func_216378_a(VoxelShapes.func_197868_b(), pos, false) && !context.func_225581_b_()) {
                return super.func_220071_b(state, worldIn, pos, context);
            }
        }
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_230322_a_(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public static boolean canWalkOnPowderSnow(Entity entity) {
        if (entity.func_200600_R().func_220341_a(CCBEntityTypeTags.POWDER_SNOW_WALKABLE_MOBS)) {
            return true;
        }
        return entity instanceof LivingEntity && ((LivingEntity)entity).func_184582_a(EquipmentSlotType.FEET).func_77973_b().equals(Items.field_151021_T);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return true;
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return PathNodeType.WALKABLE;
    }
}

