/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entity;

import com.blackgear.cavesandcliffs.common.entity.IFrameable;
import com.blackgear.cavesandcliffs.core.registries.CCBItems;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBEntityTypes;
import com.blackgear.cavesandcliffs.mixin.core.accessor.EntityAccessor;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;

public class GlowItemFrameEntity
extends ItemFrameEntity {
    public GlowItemFrameEntity(EntityType<? extends ItemFrameEntity> type, World world) {
        super(type, world);
    }

    public GlowItemFrameEntity(World worldIn, BlockPos pos, Direction facing) {
        super(worldIn, pos, facing);
        ((EntityAccessor)((Object)this)).setType(CCBEntityTypes.GLOW_ITEM_FRAME);
    }

    public void func_110128_b(@Nullable Entity brokenEntity) {
        this.func_184185_a(SoundEvents.field_187623_cM, 1.0f, 1.0f);
        this.dropItemOrSelf(brokenEntity, true);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (((IFrameable)((Object)this)).isFixed()) {
            return (source == DamageSource.field_76380_i || source.func_180136_u()) && this.func_70097_a(source, amount);
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!source.func_94541_c() && !this.func_82335_i().func_190926_b()) {
            if (!this.field_70170_p.field_72995_K) {
                this.dropItemOrSelf(source.func_76346_g(), false);
                this.func_184185_a(SoundEvents.field_187629_cO, 1.0f, 1.0f);
            }
            return true;
        }
        return super.func_70097_a(source, amount);
    }

    private void dropItemOrSelf(@Nullable Entity entityIn, boolean p_146065_2_) {
        if (!((IFrameable)((Object)this)).isFixed()) {
            ItemStack itemstack = this.func_82335_i();
            this.func_82334_a(ItemStack.field_190927_a);
            if (!this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                if (entityIn == null) {
                    this.removeItem(itemstack);
                }
            } else {
                if (entityIn instanceof PlayerEntity) {
                    PlayerEntity playerentity = (PlayerEntity)entityIn;
                    if (playerentity.field_71075_bZ.field_75098_d) {
                        this.removeItem(itemstack);
                        return;
                    }
                }
                if (p_146065_2_) {
                    this.func_199703_a((IItemProvider)CCBItems.GLOW_ITEM_FRAME.get());
                }
                if (!itemstack.func_190926_b()) {
                    itemstack = itemstack.func_77946_l();
                    this.removeItem(itemstack);
                    if (this.field_70146_Z.nextFloat() < ((IFrameable)((Object)this)).getDropChance()) {
                        this.func_199701_a_(itemstack);
                    }
                }
            }
        }
    }

    private void removeItem(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151098_aY) {
            MapData mapdata = FilledMapItem.func_195950_a((ItemStack)stack, (World)this.field_70170_p);
            Objects.requireNonNull(mapdata);
            mapdata.func_212441_a(this.field_174861_a, this.func_145782_y());
            mapdata.func_76186_a(true);
        }
        stack.func_234695_a_(null);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        ItemStack stack = this.func_82335_i();
        return stack.func_190926_b() ? new ItemStack((IItemProvider)CCBItems.GLOW_ITEM_FRAME.get()) : stack.func_77946_l();
    }
}

