/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entity;

import com.blackgear.cavesandcliffs.common.entity.GoatEntity;
import com.blackgear.cavesandcliffs.common.entity.ai.task.LeapingChargeTask;
import com.blackgear.cavesandcliffs.common.entity.ai.task.LongJumpTask;
import com.blackgear.cavesandcliffs.common.entity.ai.task.PrepareRamTask;
import com.blackgear.cavesandcliffs.common.entity.ai.task.RamImpactTask;
import com.blackgear.cavesandcliffs.common.entity.ai.task.TemptTask;
import com.blackgear.cavesandcliffs.common.entity.ai.task.TemptationCooldownTask;
import com.blackgear.cavesandcliffs.common.entity.ai.task.WalkTask;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBActivities;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBEntityTypes;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBMemoryModuleTypes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.task.AnimalBreedTask;
import net.minecraft.entity.ai.brain.task.ChildFollowNearestAdultTask;
import net.minecraft.entity.ai.brain.task.DummyTask;
import net.minecraft.entity.ai.brain.task.FirstShuffledTask;
import net.minecraft.entity.ai.brain.task.LookAtEntityTask;
import net.minecraft.entity.ai.brain.task.LookTask;
import net.minecraft.entity.ai.brain.task.RunSometimesTask;
import net.minecraft.entity.ai.brain.task.SwimTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.ai.brain.task.WalkRandomlyTask;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;
import net.minecraft.entity.ai.brain.task.WalkTowardsLookTargetTask;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;

public class GoatTasks {
    private static final RangedInteger WALKING_SPEED = RangedInteger.func_233017_a_((int)5, (int)16);
    private static final RangedInteger LONG_JUMP_COOLDOWN_RANGE = RangedInteger.func_233017_a_((int)600, (int)1200);
    private static final RangedInteger RAM_COOLDOWN_RANGE = RangedInteger.func_233017_a_((int)600, (int)6000);
    private static final RangedInteger SCREAMING_RAM_COOLDOWN_RANGE = RangedInteger.func_233017_a_((int)100, (int)300);
    private static final EntityPredicate RAM_TARGET_PREDICATE = new EntityPredicate().func_221012_a(entity -> !entity.func_200600_R().equals(CCBEntityTypes.GOAT.get()) && entity.field_70170_p.func_175723_af().func_177743_a(entity.func_174813_aQ()));

    protected static void resetLongJumpCooldown(GoatEntity goat) {
        goat.func_213375_cj().func_218205_a((MemoryModuleType)CCBMemoryModuleTypes.LONG_JUMP_COOLING_DOWN.get(), (Object)LONG_JUMP_COOLDOWN_RANGE.func_233018_a_(goat.field_70170_p.func_201674_k()));
        goat.func_213375_cj().func_218205_a((MemoryModuleType)CCBMemoryModuleTypes.RAM_COOLDOWN_TICKS.get(), (Object)RAM_COOLDOWN_RANGE.func_233018_a_(goat.field_70170_p.func_201674_k()));
    }

    protected static Brain<?> makeBrain(Brain<GoatEntity> brain) {
        GoatTasks.addCoreActivities(brain);
        GoatTasks.addIdleActivities(brain);
        GoatTasks.addLongJumpActivities(brain);
        GoatTasks.addRamActivities(brain);
        brain.func_218199_a((Set)ImmutableSet.of((Object)Activity.field_221365_a));
        brain.func_218200_b(Activity.field_221366_b);
        brain.func_233714_e_();
        return brain;
    }

    private static void addCoreActivities(Brain<GoatEntity> brain) {
        brain.func_233698_a_(Activity.field_221365_a, 0, ImmutableList.of((Object)new SwimTask(0.8f), (Object)((Object)new WalkTask(2.0f)), (Object)new LookTask(45, 90), (Object)new WalkToTargetTask(), (Object)((Object)new TemptationCooldownTask((MemoryModuleType<Integer>)((MemoryModuleType)CCBMemoryModuleTypes.TEMPTATION_COOLDOWN_TICKS.get()))), (Object)((Object)new TemptationCooldownTask((MemoryModuleType<Integer>)((MemoryModuleType)CCBMemoryModuleTypes.LONG_JUMP_COOLING_DOWN.get()))), (Object)((Object)new TemptationCooldownTask((MemoryModuleType<Integer>)((MemoryModuleType)CCBMemoryModuleTypes.RAM_COOLDOWN_TICKS.get())))));
    }

    private static void addIdleActivities(Brain<GoatEntity> brain) {
        brain.func_233700_a_(Activity.field_221366_b, ImmutableList.of((Object)Pair.of((Object)0, (Object)new RunSometimesTask((Task)new LookAtEntityTask(EntityType.field_200729_aH, 6.0f), RangedInteger.func_233017_a_((int)30, (int)60))), (Object)Pair.of((Object)0, (Object)new AnimalBreedTask((EntityType)CCBEntityTypes.GOAT.get(), 1.0f)), (Object)Pair.of((Object)1, (Object)((Object)new TemptTask(goat -> Float.valueOf(1.25f)))), (Object)Pair.of((Object)2, (Object)new ChildFollowNearestAdultTask(WALKING_SPEED, 1.25f)), (Object)Pair.of((Object)3, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new WalkRandomlyTask(1.0f), (Object)2), (Object)Pair.of((Object)new WalkTowardsLookTargetTask(1.0f, 3), (Object)2), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)1))))), (Set)ImmutableSet.of((Object)Pair.of((Object)CCBMemoryModuleTypes.RAM_TARGET.get(), (Object)MemoryModuleStatus.VALUE_ABSENT), (Object)Pair.of((Object)CCBMemoryModuleTypes.LONG_JUMP_MID_JUMP.get(), (Object)MemoryModuleStatus.VALUE_ABSENT)));
    }

    private static void addLongJumpActivities(Brain<GoatEntity> brain) {
        brain.func_233700_a_((Activity)CCBActivities.LONG_JUMP.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new LeapingChargeTask(LONG_JUMP_COOLDOWN_RANGE, (SoundEvent)CCBSoundEvents.ENTITY_GOAT_STEP.get()))), (Object)Pair.of((Object)1, new LongJumpTask<GoatEntity>(LONG_JUMP_COOLDOWN_RANGE, 5, 5, 1.5f, goat -> goat.isScreaming() ? (SoundEvent)CCBSoundEvents.ENTITY_GOAT_SCREAMING_LONG_JUMP.get() : (SoundEvent)CCBSoundEvents.ENTITY_GOAT_LONG_JUMP.get()))), (Set)ImmutableSet.of((Object)Pair.of((Object)CCBMemoryModuleTypes.TEMPTING_PLAYER.get(), (Object)MemoryModuleStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.field_220953_n, (Object)MemoryModuleStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.field_220950_k, (Object)MemoryModuleStatus.VALUE_ABSENT), (Object)Pair.of((Object)CCBMemoryModuleTypes.LONG_JUMP_COOLING_DOWN.get(), (Object)MemoryModuleStatus.VALUE_ABSENT)));
    }

    private static void addRamActivities(Brain<GoatEntity> brain) {
        brain.func_233700_a_((Activity)CCBActivities.RAM.get(), ImmutableList.of((Object)Pair.of((Object)0, new RamImpactTask<GoatEntity>(goat -> goat.isScreaming() ? SCREAMING_RAM_COOLDOWN_RANGE : RAM_COOLDOWN_RANGE, RAM_TARGET_PREDICATE, 3.0f, goat -> goat.func_70631_g_() ? 1.0 : 2.5, goat -> goat.isScreaming() ? (SoundEvent)CCBSoundEvents.ENTITY_GOAT_SCREAMING_RAM_IMPACT.get() : (SoundEvent)CCBSoundEvents.ENTITY_GOAT_RAM_IMPACT.get())), (Object)Pair.of((Object)1, new PrepareRamTask<GoatEntity>(goat -> goat.isScreaming() ? SCREAMING_RAM_COOLDOWN_RANGE.func_233016_a_() : RAM_COOLDOWN_RANGE.func_233016_a_(), 4, 7, 1.25f, RAM_TARGET_PREDICATE, 20, entityIn -> entityIn.isScreaming() ? (SoundEvent)CCBSoundEvents.ENTITY_GOAT_SCREAMING_PREPARE_RAM.get() : (SoundEvent)CCBSoundEvents.ENTITY_GOAT_PREPARE_RAM.get()))), (Set)ImmutableSet.of((Object)Pair.of((Object)CCBMemoryModuleTypes.TEMPTING_PLAYER.get(), (Object)MemoryModuleStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.field_220953_n, (Object)MemoryModuleStatus.VALUE_ABSENT), (Object)Pair.of((Object)CCBMemoryModuleTypes.RAM_COOLDOWN_TICKS.get(), (Object)MemoryModuleStatus.VALUE_ABSENT)));
    }

    public static void updateActivities(GoatEntity goat) {
        goat.func_213375_cj().func_233706_a_((List)ImmutableList.of((Object)CCBActivities.RAM.get(), (Object)CCBActivities.LONG_JUMP.get(), (Object)Activity.field_221366_b));
    }

    public static Ingredient getTemptItems() {
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151015_O});
    }
}

