/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.entity.ai.task;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.world.server.ServerWorld;

public class UpdateAttackTargetTask<E extends MobEntity>
extends Task<E> {
    private final Predicate<E> startCondition;
    private final Function<E, Optional<? extends LivingEntity>> targetGetter;

    public UpdateAttackTargetTask(Predicate<E> startCondition, Function<E, Optional<? extends LivingEntity>> targetGetter) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.field_234103_o_, (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryModuleType.field_223021_x, (Object)MemoryModuleStatus.REGISTERED));
        this.startCondition = startCondition;
        this.targetGetter = targetGetter;
    }

    public UpdateAttackTargetTask(Function<E, Optional<? extends LivingEntity>> targetGetter) {
        this(mobEntity -> true, targetGetter);
    }

    protected boolean shouldExecute(ServerWorld worldIn, E owner) {
        if (!this.startCondition.test(owner)) {
            return false;
        }
        Optional<? extends LivingEntity> optional = this.targetGetter.apply(owner);
        if (!optional.isPresent()) {
            return false;
        }
        LivingEntity livingEntity = optional.get();
        return livingEntity.func_70089_S();
    }

    protected void startExecuting(ServerWorld worldIn, E entityIn, long gameTimeIn) {
        this.targetGetter.apply(entityIn).ifPresent(livingEntity -> this.updateAttackTarget(entityIn, (LivingEntity)livingEntity));
    }

    private void updateAttackTarget(E entity, LivingEntity target) {
        entity.func_213375_cj().func_218205_a(MemoryModuleType.field_234103_o_, (Object)target);
        entity.func_213375_cj().func_218189_b(MemoryModuleType.field_223021_x);
    }
}

