/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.events;

import com.blackgear.cavesandcliffs.common.blocks.ICaveVines;
import com.blackgear.cavesandcliffs.common.entity.AxolotlEntity;
import com.blackgear.cavesandcliffs.core.registries.entity.CCBEntityTypes;
import com.blackgear.cavesandcliffs.mixin.core.accessor.ShulkerEntityAccessor;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.state.Property;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cavesandcliffs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntityEvents {
    private static final Predicate<LivingEntity> AXOLOTL_SELECTOR = entity -> entity.func_200600_R() == CCBEntityTypes.AXOLOTL.get() && ((AxolotlEntity)entity).canTakeDamage();

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        Entity entity;
        DamageSource source = event.getSource();
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof ShulkerEntity && source.func_76352_a() && (entity = source.func_76364_f()) != null && entity.func_200600_R() == EntityType.field_200739_ae) {
            EntityEvents.spawnNewShulker((ShulkerEntity)livingEntity);
        }
    }

    private static void spawnNewShulker(ShulkerEntity entity) {
        Vector3d vec = entity.func_213303_ch();
        AxisAlignedBB box = entity.func_174813_aQ();
        if (!((ShulkerEntityAccessor)entity).callIsClosed() && ((ShulkerEntityAccessor)entity).callTryTeleportToNewPosition()) {
            int size = entity.field_70170_p.func_217394_a(EntityType.field_200738_ad, box.func_186662_g(8.0), Entity::func_70089_S).size();
            float chance = (float)(size - 1) / 5.0f;
            if (entity.field_70170_p.func_201674_k().nextFloat() > chance) {
                DyeColor dyeColor;
                ShulkerEntity shulker = (ShulkerEntity)EntityType.field_200738_ad.func_200721_a(entity.field_70170_p);
                Byte color = (Byte)entity.func_184212_Q().func_187225_a(ShulkerEntityAccessor.getCOLOR());
                DyeColor dyeColor2 = dyeColor = color != 16 && color <= 15 ? DyeColor.func_196056_a((int)color.byteValue()) : null;
                if (dyeColor != null) {
                    entity.func_184212_Q().func_187227_b(ShulkerEntityAccessor.getCOLOR(), (Object)((byte)dyeColor.func_196059_a()));
                }
                Objects.requireNonNull(shulker).func_233576_c_(vec);
                entity.field_70170_p.func_217376_c((Entity)shulker);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof DrownedEntity) {
            DrownedEntity drowned = (DrownedEntity)entity;
            drowned.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)drowned, AxolotlEntity.class, 10, true, false, AXOLOTL_SELECTOR));
        }
        if (entity instanceof GuardianEntity) {
            GuardianEntity guardian = (GuardianEntity)entity;
            guardian.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)guardian, AxolotlEntity.class, 10, true, false, (Predicate)new GuardianTargetPredicate(guardian)));
        }
        if (entity instanceof FoxEntity) {
            FoxEntity fox = (FoxEntity)entity;
            fox.field_70714_bg.func_75776_a(10, (Goal)new FoxEatBerriesGoal(fox, 1.2f, 12, 2));
        }
    }

    private static class FoxEatBerriesGoal
    extends MoveToBlockGoal {
        private final FoxEntity foxEntity;
        protected int timer;

        public FoxEatBerriesGoal(FoxEntity foxEntity, double speedIn, int length, int maxYDifference) {
            super((CreatureEntity)foxEntity, speedIn, length, maxYDifference);
            this.foxEntity = foxEntity;
        }

        public double func_203110_f() {
            return 2.0;
        }

        public boolean func_203108_i() {
            return this.field_179493_e % 100 == 0;
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            BlockState state = worldIn.func_180495_p(pos);
            return state.func_203425_a(Blocks.field_222434_lW) && (Integer)state.func_177229_b((Property)SweetBerryBushBlock.field_220125_a) >= 2 || ICaveVines.hasBerries(state);
        }

        public void func_75246_d() {
            if (this.func_179487_f()) {
                if (this.timer >= 40) {
                    this.eatBerries();
                } else {
                    ++this.timer;
                }
            } else if (!this.func_179487_f() && this.foxEntity.field_70170_p.field_73012_v.nextFloat() < 0.05f) {
                this.foxEntity.func_184185_a(SoundEvents.field_219628_dB, 1.0f, 1.0f);
            }
            super.func_75246_d();
        }

        protected void eatBerries() {
            BlockState state;
            if (ForgeEventFactory.getMobGriefingEvent((World)this.foxEntity.field_70170_p, (Entity)this.foxEntity) && ICaveVines.hasBerries(state = this.foxEntity.field_70170_p.func_180495_p(this.field_179494_b))) {
                this.pickGlowBerries(state);
            }
        }

        private void pickGlowBerries(BlockState state) {
            ICaveVines.pickBerries(state, this.foxEntity.field_70170_p, this.field_179494_b);
        }

        public boolean func_75250_a() {
            return !this.foxEntity.func_70608_bn() && super.func_75250_a();
        }

        public void func_75249_e() {
            this.timer = 0;
            this.foxEntity.func_213466_r(false);
            super.func_75249_e();
        }
    }

    private static class GuardianTargetPredicate
    implements Predicate<LivingEntity> {
        private final GuardianEntity guardian;

        private GuardianTargetPredicate(GuardianEntity guardian) {
            this.guardian = guardian;
        }

        @Override
        public boolean test(LivingEntity entity) {
            return entity != null && AXOLOTL_SELECTOR.test(entity) && entity.func_70068_e((Entity)this.guardian) > 9.0;
        }
    }
}

