/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.events;

import com.blackgear.cavesandcliffs.common.events.interactions.CandleCakeInteraction;
import com.blackgear.cavesandcliffs.common.events.interactions.CauldronInteraction;
import com.blackgear.cavesandcliffs.common.events.interactions.GlowSignInteraction;
import com.blackgear.cavesandcliffs.common.events.interactions.GrassPathInteraction;
import com.blackgear.cavesandcliffs.common.events.interactions.LitCandleInteraction;
import com.blackgear.cavesandcliffs.common.events.interactions.ScrapCopperInteraction;
import com.blackgear.cavesandcliffs.common.events.interactions.WaterloggableRailInteraction;
import com.blackgear.cavesandcliffs.common.events.interactions.WaxCopperInteraction;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cavesandcliffs")
public class PlayerInteraction {
    @SubscribeEvent
    public static void onBlockInteraction(PlayerInteractEvent.RightClickBlock event) {
        UseBlockContext context = new UseBlockContext(event);
        new CauldronInteraction(context);
        new GlowSignInteraction(context);
        new WaxCopperInteraction(context);
        new ScrapCopperInteraction(context);
        new LitCandleInteraction(context);
        new CandleCakeInteraction(context);
        new GrassPathInteraction(context);
        new WaterloggableRailInteraction(context);
    }

    public static class UseBlockContext {
        private final PlayerInteractEvent.RightClickBlock event;
        private final World world;
        private final PlayerEntity player;
        private final Hand hand;
        private final BlockPos pos;

        public UseBlockContext(PlayerInteractEvent.RightClickBlock event, World world, PlayerEntity player, Hand hand, BlockPos pos) {
            this.event = event;
            this.world = world;
            this.player = player;
            this.hand = hand;
            this.pos = pos;
        }

        public UseBlockContext(PlayerInteractEvent.RightClickBlock event) {
            this(event, event.getWorld(), event.getPlayer(), event.getHand(), event.getPos());
        }

        public PlayerInteractEvent.RightClickBlock getEvent() {
            return this.event;
        }

        public World getWorld() {
            return this.world;
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }

        public Hand getHand() {
            return this.hand;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public BlockState getState() {
            return this.world.func_180495_p(this.pos);
        }

        public Block getBlock() {
            return this.getState().func_177230_c();
        }

        public ItemStack getStack() {
            return this.player.func_184586_b(this.hand);
        }

        public Item getItem() {
            return this.getStack().func_77973_b();
        }
    }

    public static abstract class Interaction {
        public final PlayerInteractEvent.RightClickBlock event;

        public Interaction(UseBlockContext ctx, boolean condition) {
            this.event = ctx.getEvent();
            if (condition) {
                this.event.setCancellationResult(this.onInteraction(ctx.getWorld(), ctx.getPlayer(), ctx.getHand(), ctx.getPos(), ctx.getState(), ctx.getBlock(), ctx.getStack(), ctx.getItem()));
            }
        }

        public abstract ActionResultType onInteraction(World var1, PlayerEntity var2, Hand var3, BlockPos var4, BlockState var5, Block var6, ItemStack var7, Item var8);
    }
}

