/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.events;

import com.blackgear.cavesandcliffs.common.blocks.AbstractCandleBlock;
import com.blackgear.cavesandcliffs.common.entity.AxolotlEntity;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cavesandcliffs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ProjectileImpact {
    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent.Throwable event) {
        ThrowableEntity projectile = event.getThrowable();
        if (projectile instanceof PotionEntity) {
            PotionEntity potionEntity = (PotionEntity)projectile;
            ItemStack stack = potionEntity.func_184543_l();
            Potion potion = PotionUtils.func_185191_c((ItemStack)stack);
            List list = PotionUtils.func_185189_a((ItemStack)stack);
            if (potion == Potions.field_185230_b && list.isEmpty()) {
                AxisAlignedBB box = potionEntity.func_174813_aQ().func_72321_a(4.0, 2.0, 4.0);
                List axolotls = potionEntity.field_70170_p.func_225317_b(AxolotlEntity.class, box);
                for (AxolotlEntity axolotl : axolotls) {
                    axolotl.hydrateFromPotion();
                }
            }
            if (potion == Potions.field_185230_b && list.isEmpty() && event.getRayTraceResult() instanceof BlockRayTraceResult) {
                World world = potionEntity.field_70170_p;
                BlockRayTraceResult hit = (BlockRayTraceResult)event.getRayTraceResult();
                Direction direction = hit.func_216354_b();
                BlockPos pos = hit.func_216350_a().func_177972_a(direction);
                ProjectileImpact.extinguishCandle(world, pos);
                ProjectileImpact.extinguishCandle(world, pos.func_177972_a(direction.func_176734_d()));
                for (Direction horizontalPlane : Direction.Plane.HORIZONTAL) {
                    ProjectileImpact.extinguishCandle(world, pos.func_177972_a(horizontalPlane));
                }
            }
        }
    }

    private static void extinguishCandle(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (AbstractCandleBlock.isLitCandle(state)) {
            AbstractCandleBlock.extinguish(state, (IWorld)world, pos);
        }
    }
}

