/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.events.interactions;

import com.blackgear.cavesandcliffs.common.blocks.IOxidizable;
import com.blackgear.cavesandcliffs.common.events.PlayerInteraction;
import com.blackgear.cavesandcliffs.common.events.interactions.WaxCopperInteraction;
import com.blackgear.cavesandcliffs.common.util.BlockUtils;
import com.blackgear.cavesandcliffs.common.util.WorldEvents;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ScrapCopperInteraction
extends PlayerInteraction.Interaction {
    public ScrapCopperInteraction(PlayerInteraction.UseBlockContext ctx) {
        super(ctx, ctx.getItem() instanceof AxeItem);
    }

    @Override
    public ActionResultType onInteraction(World world, PlayerEntity player, Hand hand, BlockPos pos, BlockState state, Block block, ItemStack stack, Item item) {
        Optional<BlockState> decreasedOxidation = IOxidizable.getDecreasedOxidationState(state);
        Optional<BlockState> unwaxedState = Optional.ofNullable(WaxCopperInteraction.WAXED_TO_UNWAXED_BLOCKS.get().get((Object)state.func_177230_c())).map(blockIn -> BlockUtils.getStateWithProperties(blockIn, state));
        Optional<Object> blockState = Optional.empty();
        if (decreasedOxidation.isPresent()) {
            world.func_184133_a(player, pos, (SoundEvent)CCBSoundEvents.ITEM_AXE_SCRAPE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            WorldEvents.syncWorldEvent(world, 3005, pos, 0);
            blockState = decreasedOxidation;
        } else if (unwaxedState.isPresent()) {
            world.func_184133_a(player, pos, (SoundEvent)CCBSoundEvents.ITEM_AXE_WAX_OFF.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            WorldEvents.syncWorldEvent(world, 3004, pos, 0);
            blockState = unwaxedState;
        }
        if (blockState.isPresent()) {
            world.func_180501_a(pos, (BlockState)blockState.get(), 11);
            stack.func_222118_a(1, (LivingEntity)player, entityIn -> entityIn.func_213334_d(hand));
            this.event.setCanceled(true);
            return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
        }
        return ActionResultType.PASS;
    }
}

