/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.util;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class Codecs {
    public static final Codec<Integer> NONNEGATIVE_INT = Codecs.rangedInt(0, Integer.MAX_VALUE, value -> "Value must be non-negative: " + value);
    public static final Codec<Integer> POSITIVE_INT = Codecs.rangedInt(1, Integer.MAX_VALUE, value -> "Value must be positive: " + value);

    public static <F, S> Codec<Either<F, S>> xor(Codec<F> first, Codec<S> second) {
        return new Xor<F, S>(first, second);
    }

    private static <N extends Number> Function<N, DataResult<N>> createRangeChecker(N min, N max, Function<N, String> factory) {
        return value -> ((Comparable)((Object)value)).compareTo(min) >= 0 && ((Comparable)((Object)value)).compareTo(max) <= 0 ? DataResult.success((Object)value) : DataResult.error((String)((String)factory.apply(value)));
    }

    private static Codec<Integer> rangedInt(int min, int max, Function<Integer, String> factory) {
        Function<Integer, DataResult<Integer>> rangeChecker = Codecs.createRangeChecker(min, max, factory);
        return Codec.INT.flatXmap(rangeChecker, rangeChecker);
    }

    public static <T> Function<List<T>, DataResult<List<T>>> createNonEmptyListChecker() {
        return list -> list.isEmpty() ? DataResult.error((String)"List must have contents") : DataResult.success((Object)list);
    }

    public static <T> Codec<List<T>> nonEmptyList(Codec<List<T>> codec) {
        return codec.flatXmap(Codecs.createNonEmptyListChecker(), Codecs.createNonEmptyListChecker());
    }

    static final class Xor<F, S>
    implements Codec<Either<F, S>> {
        private final Codec<F> first;
        private final Codec<S> second;

        public Xor(Codec<F> first, Codec<S> second) {
            this.first = first;
            this.second = second;
        }

        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> ops, T input) {
            DataResult first = this.first.decode(ops, input).map(pair -> pair.mapFirst(Either::left));
            DataResult second = this.second.decode(ops, input).map(pair -> pair.mapFirst(Either::right));
            Optional firstOption = first.result();
            Optional secondOption = second.result();
            if (firstOption.isPresent() && secondOption.isPresent()) {
                return DataResult.error((String)("Both alternatives read successfully, can not pick the correct one; first: " + firstOption.get() + " second: " + secondOption.get()), firstOption.get());
            }
            return firstOption.isPresent() ? first : second;
        }

        public <T> DataResult<T> encode(Either<F, S> input, DynamicOps<T> ops, T prefix) {
            return (DataResult)input.map(left -> this.first.encode(left, ops, prefix), right -> this.second.encode(right, ops, prefix));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o != null && this.getClass() == o.getClass()) {
                Xor xor = (Xor)o;
                return Objects.equals(this.first, xor.first) && Objects.equals(this.second, xor.second);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second);
        }

        public String toString() {
            return "XorCodec[" + this.first + ", " + this.second + "]";
        }
    }
}

