/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.util;

import com.blackgear.cavesandcliffs.common.math.intprovider.UniformIntProvider;
import java.util.Random;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class ParticleUtil {
    public static void spawnParticle(World world, BlockPos pos, IParticleData effect, UniformIntProvider range) {
        Direction[] directions;
        for (Direction direction : directions = Direction.values()) {
            int spread = range.get(world.field_73012_v);
            for (int base = 0; base < spread; ++base) {
                ParticleUtil.spawnParticle(world, pos, direction, effect);
            }
        }
    }

    public static void spawnParticle(Direction.Axis axis, World world, BlockPos pos, double variance, IParticleData effect, UniformIntProvider range) {
        Vector3d vec3d = Vector3d.func_237489_a_((Vector3i)pos);
        boolean xAxis = axis == Direction.Axis.X;
        boolean yAxis = axis == Direction.Axis.Y;
        boolean zAxis = axis == Direction.Axis.Z;
        int spread = range.get(world.field_73012_v);
        for (int base = 0; base < spread; ++base) {
            double x = vec3d.field_72450_a + MathHelper.func_82716_a((Random)world.field_73012_v, (double)-1.0, (double)1.0) * (xAxis ? 0.5 : variance);
            double y = vec3d.field_72448_b + MathHelper.func_82716_a((Random)world.field_73012_v, (double)-1.0, (double)1.0) * (yAxis ? 0.5 : variance);
            double z = vec3d.field_72449_c + MathHelper.func_82716_a((Random)world.field_73012_v, (double)-1.0, (double)1.0) * (zAxis ? 0.5 : variance);
            double xVelocity = xAxis ? MathHelper.func_82716_a((Random)world.field_73012_v, (double)-1.0, (double)1.0) : 0.0;
            double yVelocity = yAxis ? MathHelper.func_82716_a((Random)world.field_73012_v, (double)-1.0, (double)1.0) : 0.0;
            double zVelocity = zAxis ? MathHelper.func_82716_a((Random)world.field_73012_v, (double)-1.0, (double)1.0) : 0.0;
            world.func_195594_a(effect, x, y, z, xVelocity, yVelocity, zVelocity);
        }
    }

    public static void spawnParticle(World world, BlockPos pos, Direction direction, IParticleData effect) {
        Vector3d vec3d = Vector3d.func_237489_a_((Vector3i)pos);
        int xOffset = direction.func_82601_c();
        int yOffset = direction.func_96559_d();
        int zOffset = direction.func_82599_e();
        double x = vec3d.field_72450_a + (xOffset == 0 ? MathHelper.func_82716_a((Random)world.field_73012_v, (double)-0.5, (double)0.5) : (double)xOffset * 0.55);
        double y = vec3d.field_72448_b + (yOffset == 0 ? MathHelper.func_82716_a((Random)world.field_73012_v, (double)-0.5, (double)0.5) : (double)yOffset * 0.55);
        double z = vec3d.field_72449_c + (zOffset == 0 ? MathHelper.func_82716_a((Random)world.field_73012_v, (double)-0.5, (double)0.5) : (double)zOffset * 0.55);
        double xVelocity = xOffset == 0 ? MathHelper.func_82716_a((Random)world.field_73012_v, (double)-1.0, (double)1.0) : 0.0;
        double yVelocity = yOffset == 0 ? MathHelper.func_82716_a((Random)world.field_73012_v, (double)-1.0, (double)1.0) : 0.0;
        double zVelocity = zOffset == 0 ? MathHelper.func_82716_a((Random)world.field_73012_v, (double)-1.0, (double)1.0) : 0.0;
        world.func_195594_a(effect, x, y, z, xVelocity, yVelocity, zVelocity);
    }
}

