/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.util;

import com.blackgear.cavesandcliffs.common.blocks.PointedDripstoneBlock;
import com.blackgear.cavesandcliffs.common.math.intprovider.UniformIntProvider;
import com.blackgear.cavesandcliffs.common.util.ParticleUtil;
import com.blackgear.cavesandcliffs.core.registries.CCBParticleTypes;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldEvents {
    public static final int POINTED_DRIPSTONE_LANDS = 1045;
    public static final int POINTED_DRIPSTONE_DRIPS_LAVA_INTO_CAULDRON = 1046;
    public static final int POINTED_DRIPSTONE_DRIPS_WATER_INTO_CAULDRON = 1047;
    public static final int SKELETON_CONVERTS_TO_STRAY = 1048;
    public static final int POINTED_DRIPSTONE_DRIPS = 1504;
    public static final int ELECTRICITY_SPARKS = 3002;
    public static final int BLOCK_WAXED = 3003;
    public static final int WAX_REMOVED = 3004;
    public static final int BLOCK_SCRAPED = 3005;

    public static void syncWorldEvent(World world, int eventId, BlockPos pos, int data) {
        WorldEvents.syncWorldEvent(world, null, eventId, pos, data);
    }

    public static void syncWorldEvent(World world, @Nullable PlayerEntity player, int eventId, BlockPos pos, int data) {
        try {
            WorldEvents.processWorldEvent(world, player, eventId, pos, data);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a((Throwable)throwable, (String)"Playing level event");
            CrashReportCategory crashReportSection = crashReport.func_85058_a("Level event being played");
            crashReportSection.func_71507_a("Block coordinates", (Object)CrashReportCategory.func_180522_a((BlockPos)pos));
            crashReportSection.func_71507_a("Event source", (Object)player);
            crashReportSection.func_71507_a("Event type", (Object)eventId);
            crashReportSection.func_71507_a("Event data", (Object)data);
            throw new ReportedException(crashReport);
        }
    }

    public static void processWorldEvent(World world, PlayerEntity source, int eventId, BlockPos pos, int data) {
        switch (eventId) {
            case 1045: {
                if (!world.field_72995_K) break;
                ((ClientWorld)world).func_184156_a(pos, (SoundEvent)CCBSoundEvents.BLOCK_POINTED_DRIPSTONE_LAND.get(), SoundCategory.BLOCKS, 2.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1046: {
                if (!world.field_72995_K) break;
                ((ClientWorld)world).func_184156_a(pos, (SoundEvent)CCBSoundEvents.BLOCK_POINTED_DRIPSTONE_DRIP_LAVA_INTO_CAULDRON.get(), SoundCategory.BLOCKS, 2.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1047: {
                if (!world.field_72995_K) break;
                ((ClientWorld)world).func_184156_a(pos, (SoundEvent)CCBSoundEvents.BLOCK_POINTED_DRIPSTONE_DRIP_WATER_INTO_CAULDRON.get(), SoundCategory.BLOCKS, 2.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1048: {
                if (!world.field_72995_K) break;
                ((ClientWorld)world).func_184156_a(pos, SoundEvents.field_187941_ho, SoundCategory.NEUTRAL, 2.0f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1504: {
                PointedDripstoneBlock.createParticle(world, pos, world.func_180495_p(pos));
                break;
            }
            case 3002: {
                if (data >= 0 && data < Direction.Axis.values().length) {
                    ParticleUtil.spawnParticle(Direction.Axis.values()[data], world, pos, 0.125, (IParticleData)CCBParticleTypes.ELECTRIC_SPARK.get(), UniformIntProvider.create(10, 19));
                    break;
                }
                ParticleUtil.spawnParticle(world, pos, (IParticleData)CCBParticleTypes.ELECTRIC_SPARK.get(), UniformIntProvider.create(3, 5));
                break;
            }
            case 3003: {
                ParticleUtil.spawnParticle(world, pos, (IParticleData)CCBParticleTypes.WAX_ON.get(), UniformIntProvider.create(3, 5));
                if (!world.field_72995_K) break;
                ((ClientWorld)world).func_184156_a(pos, SoundEvents.field_226137_eR_, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 3004: {
                ParticleUtil.spawnParticle(world, pos, (IParticleData)CCBParticleTypes.WAX_OFF.get(), UniformIntProvider.create(3, 5));
            }
            case 3005: {
                ParticleUtil.spawnParticle(world, pos, (IParticleData)CCBParticleTypes.SCRAPE.get(), UniformIntProvider.create(3, 5));
            }
        }
    }
}

