/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.common.blocks.GlowLichenBlock;
import com.blackgear.cavesandcliffs.common.world.gen.feature.GlowLichenFeatureConfig;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class GlowLichenFeature
extends Feature<GlowLichenFeatureConfig> {
    public GlowLichenFeature(Codec<GlowLichenFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, GlowLichenFeatureConfig config) {
        if (!GlowLichenFeature.isAirOrWater(reader.func_180495_p(pos))) {
            return false;
        }
        List<Direction> validDirections = GlowLichenFeature.shuffleDirections(config, rand);
        if (GlowLichenFeature.generate(reader, pos, reader.func_180495_p(pos), config, rand, validDirections)) {
            return true;
        }
        BlockPos.Mutable mutable = pos.func_239590_i_();
        block0: for (Direction direction : validDirections) {
            mutable.func_189533_g((Vector3i)pos);
            List<Direction> directions = GlowLichenFeature.shuffleDirections(config, rand, direction.func_176734_d());
            for (int range = 0; range < config.searchRange; ++range) {
                mutable.func_239622_a_((Vector3i)pos, direction);
                BlockState state = reader.func_180495_p((BlockPos)mutable);
                if (!GlowLichenFeature.isAirOrWater(state) && !state.func_203425_a((Block)CCBBlocks.GLOW_LICHEN.get())) continue block0;
                if (!GlowLichenFeature.generate(reader, (BlockPos)mutable, state, config, rand, directions)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean generate(ISeedReader reader, BlockPos pos, BlockState state, GlowLichenFeatureConfig config, Random random, List<Direction> directions) {
        BlockPos.Mutable mutable = pos.func_239590_i_();
        for (Direction direction : directions) {
            BlockState blockState = reader.func_180495_p((BlockPos)mutable.func_239622_a_((Vector3i)pos, direction));
            if (!config.canGrowOn(blockState.func_177230_c())) continue;
            GlowLichenBlock glowLichenBlock = (GlowLichenBlock)CCBBlocks.GLOW_LICHEN.get();
            BlockState directionalState = glowLichenBlock.withDirection(state, (IBlockReader)reader, pos, direction);
            if (directionalState == null) {
                return false;
            }
            reader.func_180501_a(pos, directionalState, 3);
            reader.func_217349_x(pos).func_201594_d(pos);
            if (random.nextFloat() < config.chanceOfSpreading) {
                glowLichenBlock.trySpreadRandomly(directionalState, (IWorld)reader, pos, direction, random, true);
            }
            return true;
        }
        return false;
    }

    public static List<Direction> shuffleDirections(GlowLichenFeatureConfig config, Random random) {
        ArrayList directions = Lists.newArrayList(config.validDirections);
        Collections.shuffle(directions, random);
        return directions;
    }

    public static List<Direction> shuffleDirections(GlowLichenFeatureConfig config, Random random, Direction excluded) {
        List<Direction> directions = config.validDirections.stream().filter(direction -> direction != excluded).collect(Collectors.toList());
        Collections.shuffle(directions, random);
        return directions;
    }

    private static boolean isAirOrWater(BlockState state) {
        return state.func_196958_f() || state.func_203425_a(Blocks.field_150355_j);
    }
}

