/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.core.other.tags.CCBBlockTags;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;

public class ModOreFeatureConfig
implements IFeatureConfig {
    public static final Codec<ModOreFeatureConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(Target.CODEC).fieldOf("targets").forGetter(config -> config.targets), (App)Codec.intRange((int)0, (int)64).fieldOf("size").forGetter(config -> config.size), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("discard_chance_on_air_exposure").forGetter(config -> Float.valueOf(config.discardOnAirChance))).apply((Applicative)instance, ModOreFeatureConfig::new));
    public final List<Target> targets;
    public final int size;
    public final float discardOnAirChance;

    public ModOreFeatureConfig(List<Target> targets, int size, float discardOnAirChance) {
        this.targets = targets;
        this.size = size;
        this.discardOnAirChance = discardOnAirChance;
    }

    public ModOreFeatureConfig(List<Target> targets, int size) {
        this(targets, size, 0.0f);
    }

    public ModOreFeatureConfig(RuleTest target, BlockState state, int size, float discardOnAirChance) {
        this((List<Target>)ImmutableList.of((Object)new Target(target, state)), size, discardOnAirChance);
    }

    public ModOreFeatureConfig(RuleTest target, BlockState state, int size) {
        this((List<Target>)ImmutableList.of((Object)new Target(target, state)), size, 0.0f);
    }

    public static Target createTarget(RuleTest target, BlockState state) {
        return new Target(target, state);
    }

    public static final class Rules {
        public static final RuleTest STONE_ORE_REPLACEABLES = new TagMatchRuleTest(CCBBlockTags.STONE_ORE_REPLACEABLES);
        public static final RuleTest DEEPSLATE_ORE_REPLACEABLES = new TagMatchRuleTest(CCBBlockTags.DEEPSLATE_ORE_REPLACEABLES);
    }

    public static class Target {
        public static final Codec<Target> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RuleTest.field_237127_c_.fieldOf("target").forGetter(target -> target.target), (App)BlockState.field_235877_b_.fieldOf("state").forGetter(target -> target.state)).apply((Applicative)instance, Target::new));
        public final RuleTest target;
        public final BlockState state;

        Target(RuleTest target, BlockState state) {
            this.target = target;
            this.state = state;
        }
    }
}

