/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.Template;

public class ModTreeFeature
extends Feature<BaseTreeFeatureConfig> {
    public ModTreeFeature(Codec<BaseTreeFeatureConfig> codec) {
        super(codec);
    }

    public static boolean canTreeReplace(IWorldGenerationBaseReader readerIn, BlockPos pos) {
        return ModTreeFeature.isReplaceableAt(readerIn, pos) || readerIn.func_217375_a(pos, state -> state.func_235714_a_((ITag)BlockTags.field_200031_h));
    }

    private static boolean isVine(IWorldGenerationBaseReader readerIn, BlockPos pos) {
        return readerIn.func_217375_a(pos, state -> state.func_203425_a(Blocks.field_150395_bd));
    }

    private static boolean isWaterAt(IWorldGenerationBaseReader readerIn, BlockPos pos) {
        return readerIn.func_217375_a(pos, state -> state.func_203425_a(Blocks.field_150355_j));
    }

    public static boolean isAirOrLeavesAt(IWorldGenerationBaseReader readerIn, BlockPos pos) {
        return readerIn.func_217375_a(pos, state -> state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_206952_E));
    }

    private static boolean isDirtOrFarmlandAt(IWorldGenerationBaseReader readerIn, BlockPos pos) {
        return readerIn.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            return ModTreeFeature.func_227250_b_((Block)block) || block == Blocks.field_150458_ak;
        });
    }

    private static boolean isTallPlantAt(IWorldGenerationBaseReader readerIn, BlockPos pos) {
        return readerIn.func_217375_a(pos, state -> {
            Material material = state.func_185904_a();
            return material == Material.field_151582_l;
        });
    }

    public static void setBlockStateWithoutUpdatingNeighbors(IWorldWriter readerIn, BlockPos pos, BlockState state) {
        readerIn.func_180501_a(pos, state, 19);
    }

    public static boolean isReplaceableAt(IWorldGenerationBaseReader readerIn, BlockPos pos) {
        return ModTreeFeature.isAirOrLeavesAt(readerIn, pos) || ModTreeFeature.isTallPlantAt(readerIn, pos) || ModTreeFeature.isWaterAt(readerIn, pos);
    }

    private boolean place(IWorldGenerationReader readerIn, Random random, BlockPos pos, Set<BlockPos> trunkReplacer, Set<BlockPos> foliageReplacer, MutableBoundingBox boundingBoxIn, BaseTreeFeatureConfig configIn) {
        int height = configIn.field_236678_g_.func_236917_a_(random);
        int randomHeight = configIn.field_236677_f_.func_230374_a_(random, height, configIn);
        int radius = height - randomHeight;
        int randomRadius = configIn.field_236677_f_.func_230376_a_(random, radius);
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + height + 1 <= 256) {
            OptionalInt minClippedHeight = configIn.field_236679_h_.func_236710_c_();
            int topPosition = this.getTopPosition((IWorldGenerationBaseReader)readerIn, height, pos, configIn);
            if (topPosition >= height || minClippedHeight.isPresent() && topPosition >= minClippedHeight.getAsInt()) {
                List foliages = configIn.field_236678_g_.func_230382_a_(readerIn, random, topPosition, pos, trunkReplacer, boundingBoxIn, configIn);
                foliages.forEach(foliage -> configIn.field_236677_f_.func_236752_a_(readerIn, random, configIn, topPosition, foliage, randomHeight, randomRadius, foliageReplacer, boundingBoxIn));
                return true;
            }
            return false;
        }
        return false;
    }

    private int getTopPosition(IWorldGenerationBaseReader readerIn, int height, BlockPos pos, BaseTreeFeatureConfig config) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int y = 0; y <= height + 1; ++y) {
            int radius = config.field_236679_h_.func_230369_a_(height, y);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    mutable.func_239621_a_((Vector3i)pos, x, y, z);
                    if (ModTreeFeature.canTreeReplace(readerIn, (BlockPos)mutable) && (config.field_236681_j_ || !ModTreeFeature.isVine(readerIn, (BlockPos)mutable))) continue;
                    return y - 2;
                }
            }
        }
        return height;
    }

    protected void func_230367_a_(IWorldWriter world, BlockPos pos, BlockState state) {
        ModTreeFeature.setBlockStateWithoutUpdatingNeighbors(world, pos, state);
    }

    public final boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, BaseTreeFeatureConfig config) {
        HashSet trunkPositions = Sets.newHashSet();
        HashSet foliagePositions = Sets.newHashSet();
        HashSet decorationPositions = Sets.newHashSet();
        MutableBoundingBox box = MutableBoundingBox.func_78887_a();
        boolean flag = this.place((IWorldGenerationReader)reader, rand, pos, trunkPositions, foliagePositions, box, config);
        if (box.field_78897_a <= box.field_78893_d && flag && !trunkPositions.isEmpty()) {
            if (!config.field_227370_o_.isEmpty()) {
                ArrayList list = Lists.newArrayList((Iterable)trunkPositions);
                ArrayList list1 = Lists.newArrayList((Iterable)foliagePositions);
                list.sort(Comparator.comparingInt(Vector3i::func_177956_o));
                list1.sort(Comparator.comparingInt(Vector3i::func_177956_o));
                config.field_227370_o_.forEach(p_236405_6_ -> p_236405_6_.func_225576_a_(reader, rand, list, list1, decorationPositions, box));
            }
            VoxelShapePart shapePart = this.placeLogsAndLeaves((IWorld)reader, box, trunkPositions, decorationPositions);
            Template.func_222857_a((IWorld)reader, (int)3, (VoxelShapePart)shapePart, (int)box.field_78897_a, (int)box.field_78895_b, (int)box.field_78896_c);
            return true;
        }
        return false;
    }

    private VoxelShapePart placeLogsAndLeaves(IWorld worldIn, MutableBoundingBox box, Set<BlockPos> trunkPositions, Set<BlockPos> decorationPositions) {
        ArrayList positions = Lists.newArrayList();
        BitSetVoxelShapePart shapePart = new BitSetVoxelShapePart(box.func_78883_b(), box.func_78882_c(), box.func_78880_d());
        for (int i = 0; i < 6; ++i) {
            positions.add(Sets.newHashSet());
        }
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (BlockPos pos : Lists.newArrayList(decorationPositions)) {
            if (!box.func_175898_b((Vector3i)pos)) continue;
            shapePart.func_199625_a(pos.func_177958_n() - box.field_78897_a, pos.func_177956_o() - box.field_78895_b, pos.func_177952_p() - box.field_78896_c, true, true);
        }
        for (BlockPos pos : Lists.newArrayList(trunkPositions)) {
            if (box.func_175898_b((Vector3i)pos)) {
                shapePart.func_199625_a(pos.func_177958_n() - box.field_78897_a, pos.func_177956_o() - box.field_78895_b, pos.func_177952_p() - box.field_78896_c, true, true);
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                mutable.func_239622_a_((Vector3i)pos, direction);
                if (trunkPositions.contains(mutable) || !(blockstate = worldIn.func_180495_p((BlockPos)mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa)) continue;
                ((Set)positions.get(0)).add(mutable.func_185334_h());
                ModTreeFeature.setBlockStateWithoutUpdatingNeighbors((IWorldWriter)worldIn, (BlockPos)mutable, (BlockState)blockstate.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(1)));
                if (!box.func_175898_b((Vector3i)mutable)) continue;
                shapePart.func_199625_a(mutable.func_177958_n() - box.field_78897_a, mutable.func_177956_o() - box.field_78895_b, mutable.func_177952_p() - box.field_78896_c, true, true);
            }
        }
        for (int i = 1; i < 6; ++i) {
            Set set = (Set)positions.get(i - 1);
            Set set1 = (Set)positions.get(i);
            for (BlockPos blockpos2 : set) {
                if (box.func_175898_b((Vector3i)blockpos2)) {
                    shapePart.func_199625_a(blockpos2.func_177958_n() - box.field_78897_a, blockpos2.func_177956_o() - box.field_78895_b, blockpos2.func_177952_p() - box.field_78896_c, true, true);
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    mutable.func_239622_a_((Vector3i)blockpos2, direction1);
                    if (set.contains(mutable) || set1.contains(mutable) || !(blockstate1 = worldIn.func_180495_p((BlockPos)mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa) || (k = ((Integer)blockstate1.func_177229_b((Property)BlockStateProperties.field_208514_aa)).intValue()) <= i + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(i + 1));
                    ModTreeFeature.setBlockStateWithoutUpdatingNeighbors((IWorldWriter)worldIn, (BlockPos)mutable, blockstate2);
                    if (box.func_175898_b((Vector3i)mutable)) {
                        shapePart.func_199625_a(mutable.func_177958_n() - box.field_78897_a, mutable.func_177956_o() - box.field_78895_b, mutable.func_177952_p() - box.field_78896_c, true, true);
                    }
                    set1.add(mutable.func_185334_h());
                }
            }
        }
        return shapePart;
    }
}

