/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.feature;

import com.blackgear.cavesandcliffs.common.world.gen.feature.VegetationPatchFeature;
import com.blackgear.cavesandcliffs.common.world.gen.feature.VegetationPatchFeatureConfig;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;

public class WaterLoggedVegetationPatchFeature
extends VegetationPatchFeature {
    public WaterLoggedVegetationPatchFeature(Codec<VegetationPatchFeatureConfig> codec) {
        super(codec);
    }

    @Override
    protected Set<BlockPos> placeGroundAndGetPositions(ISeedReader readerIn, VegetationPatchFeatureConfig config, Random rand, BlockPos pos, Predicate<BlockState> replaceable, int radiusX, int radiusZ) {
        Set<BlockPos> positions = super.placeGroundAndGetPositions(readerIn, config, rand, pos, replaceable, radiusX, radiusZ);
        HashSet<BlockPos> waterloggedPositions = new HashSet<BlockPos>();
        for (BlockPos posIn : positions) {
            if (this.isSolidBlockAroundPos(readerIn, positions, posIn, posIn.func_239590_i_())) continue;
            waterloggedPositions.add(posIn);
        }
        for (BlockPos posIn : waterloggedPositions) {
            readerIn.func_180501_a(posIn, Blocks.field_150355_j.func_176223_P(), 2);
        }
        return waterloggedPositions;
    }

    private boolean isSolidBlockAroundPos(ISeedReader readerIn, Set<BlockPos> positions, BlockPos pos, BlockPos.Mutable mutable) {
        return this.isSolidBlockSide(readerIn, pos, mutable, Direction.NORTH) || this.isSolidBlockSide(readerIn, pos, mutable, Direction.EAST) || this.isSolidBlockSide(readerIn, pos, mutable, Direction.SOUTH) || this.isSolidBlockSide(readerIn, pos, mutable, Direction.WEST) || this.isSolidBlockSide(readerIn, pos, mutable, Direction.DOWN);
    }

    private boolean isSolidBlockSide(ISeedReader readerIn, BlockPos pos, BlockPos.Mutable mutable, Direction direction) {
        mutable.func_239622_a_((Vector3i)pos, direction);
        return !readerIn.func_180495_p((BlockPos)mutable).func_224755_d((IBlockReader)readerIn, (BlockPos)mutable, direction.func_176734_d());
    }

    @Override
    protected boolean generateVegetationFeature(ISeedReader readerIn, VegetationPatchFeatureConfig config, ChunkGenerator generator, Random rand, BlockPos pos) {
        if (super.generateVegetationFeature(readerIn, config, generator, rand, pos.func_177977_b())) {
            BlockState state = readerIn.func_180495_p(pos);
            if (state.func_235901_b_((Property)BlockStateProperties.field_208198_y) && !((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                readerIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), 2);
            }
            return true;
        }
        return false;
    }
}

