/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.other;

import com.blackgear.cavesandcliffs.common.math.intprovider.IntProvider;
import com.blackgear.cavesandcliffs.common.util.Codecs;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.worldgen.CCBTreeGenerators;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;

public class BendingTrunkPlacer
extends AbstractTrunkPlacer {
    public static final Codec<BendingTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> BendingTrunkPlacer.func_236915_a_((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codecs.POSITIVE_INT.optionalFieldOf("min_height_for_leaves", (Object)1).forGetter(placer -> placer.minHeightForLeaves), (App)IntProvider.createValidatingCodec(1, 64).fieldOf("bend_length").forGetter(placer -> placer.bendLength))).apply((Applicative)instance, BendingTrunkPlacer::new));
    private final int minHeightForLeaves;
    private final IntProvider bendLength;

    public BendingTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, int minHeightForLeaves, IntProvider bendLength) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.minHeightForLeaves = minHeightForLeaves;
        this.bendLength = bendLength;
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return CCBTreeGenerators.BENDING_TRUNK_PLACER;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader readerIn, Random rand, int height, BlockPos startPos, Set<BlockPos> positions, MutableBoundingBox box, BaseTreeFeatureConfig config) {
        int i;
        Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
        int y = height - 1;
        BlockPos.Mutable mutable = startPos.func_239590_i_();
        BlockPos blockPos = mutable.func_177977_b();
        this.setToDirt(readerIn, blockPos);
        ArrayList foliages = Lists.newArrayList();
        for (i = 0; i <= y; ++i) {
            if (i + 1 >= y + rand.nextInt(2)) {
                mutable.func_189536_c(direction);
            }
            if (TreeFeature.func_236404_a_((IWorldGenerationBaseReader)readerIn, (BlockPos)mutable)) {
                BendingTrunkPlacer.func_236911_a_((IWorldGenerationReader)readerIn, (Random)rand, (BlockPos)mutable, positions, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config);
            }
            if (i >= this.minHeightForLeaves) {
                foliages.add(new FoliagePlacer.Foliage(mutable.func_185334_h(), 0, false));
            }
            mutable.func_189536_c(Direction.UP);
        }
        i = this.bendLength.get(rand);
        for (int length = 0; length <= i; ++length) {
            if (TreeFeature.func_236404_a_((IWorldGenerationBaseReader)readerIn, (BlockPos)mutable)) {
                BendingTrunkPlacer.func_236911_a_((IWorldGenerationReader)readerIn, (Random)rand, (BlockPos)mutable, positions, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config);
            }
            foliages.add(new FoliagePlacer.Foliage(mutable.func_185334_h(), 0, false));
            mutable.func_189536_c(direction);
        }
        return foliages;
    }

    private void setToDirt(IWorldGenerationReader readerIn, BlockPos pos) {
        if (!BendingTrunkPlacer.func_236912_a_((IWorldGenerationBaseReader)readerIn, (BlockPos)pos)) {
            TreeFeature.func_236408_b_((IWorldWriter)readerIn, (BlockPos)pos, (BlockState)((Block)CCBBlocks.ROOTED_DIRT.get()).func_176223_P());
        }
    }
}

