/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.structure;

import com.blackgear.cavesandcliffs.common.world.gen.structure.ModMineshaftStructure;
import com.blackgear.cavesandcliffs.common.world.gen.structure.ModStructurePiece;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.worldgen.CCBStructurePieces;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.RailBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class MineshaftGenerator {
    private static MineshaftPart pickPiece(List<StructurePiece> pieces, Random random, int x, int y, int z, Direction orientation, int chainLength, ModMineshaftStructure.Type type) {
        int i = random.nextInt(100);
        if (i >= 80) {
            MutableBoundingBox boundingBox = MineshaftCrossing.getBoundingBox(pieces, random, x, y, z, orientation);
            if (boundingBox != null) {
                return new MineshaftCrossing(chainLength, boundingBox, orientation, type);
            }
        } else if (i >= 70) {
            MutableBoundingBox boundingBox = MineshaftStairs.getBoundingBox(pieces, random, x, y, z, orientation);
            if (boundingBox != null) {
                return new MineshaftStairs(chainLength, boundingBox, orientation, type);
            }
        } else {
            MutableBoundingBox boundingBox = MineshaftCorridor.getBoundingBox(pieces, random, x, y, z, orientation);
            if (boundingBox != null) {
                return new MineshaftCorridor(chainLength, random, boundingBox, orientation, type);
            }
        }
        return null;
    }

    static MineshaftPart pieceGenerator(StructurePiece piece, List<StructurePiece> pieces, Random random, int x, int y, int z, Direction orientation, int chainLength) {
        if (chainLength > 8) {
            return null;
        }
        if (Math.abs(x - piece.func_74874_b().field_78897_a) <= 80 && Math.abs(z - piece.func_74874_b().field_78896_c) <= 80) {
            ModMineshaftStructure.Type type = ((MineshaftPart)piece).mineshaftType;
            MineshaftPart part = MineshaftGenerator.pickPiece(pieces, random, x, y, z, orientation, chainLength + 1, type);
            if (part != null) {
                pieces.add(part);
                part.func_74861_a(piece, pieces, random);
            }
            return part;
        }
        return null;
    }

    public static class MineshaftRoom
    extends MineshaftPart {
        private final List<MutableBoundingBox> entrances = Lists.newLinkedList();

        public MineshaftRoom(int componentType, Random random, int x, int z, ModMineshaftStructure.Type type) {
            super(CCBStructurePieces.MINESHAFT_ROOM, componentType, type, new MutableBoundingBox(x, 50, z, x + 7 + random.nextInt(6), 54 + random.nextInt(6), z + 7 + random.nextInt(6)));
            this.mineshaftType = type;
        }

        public MineshaftRoom(TemplateManager manager, CompoundNBT compoundNBT) {
            super(CCBStructurePieces.MINESHAFT_ROOM, compoundNBT);
            ListNBT listnbt = compoundNBT.func_150295_c("Entrances", 11);
            for (int i = 0; i < listnbt.size(); ++i) {
                this.entrances.add(new MutableBoundingBox(listnbt.func_150306_c(i)));
            }
        }

        public void func_74861_a(StructurePiece piece, List<StructurePiece> pieces, Random random) {
            MutableBoundingBox blockBox;
            MineshaftPart mineshaftPart;
            int localXZ;
            int componentType = this.func_74877_c();
            int localY = this.field_74887_e.func_78882_c() - 3 - 1;
            if (localY <= 0) {
                localY = 1;
            }
            for (localXZ = 0; localXZ < this.field_74887_e.func_78883_b() && (localXZ += random.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b(); localXZ += 4) {
                mineshaftPart = MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a + localXZ, this.field_74887_e.field_78895_b + random.nextInt(localY) + 1, this.field_74887_e.field_78896_c - 1, Direction.NORTH, componentType);
                if (mineshaftPart == null) continue;
                blockBox = mineshaftPart.func_74874_b();
                this.entrances.add(new MutableBoundingBox(blockBox.field_78897_a, blockBox.field_78895_b, this.field_74887_e.field_78896_c, blockBox.field_78893_d, blockBox.field_78894_e, this.field_74887_e.field_78896_c + 1));
            }
            for (localXZ = 0; localXZ < this.field_74887_e.func_78883_b() && (localXZ += random.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b(); localXZ += 4) {
                mineshaftPart = MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a + localXZ, this.field_74887_e.field_78895_b + random.nextInt(localY) + 1, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, componentType);
                if (mineshaftPart == null) continue;
                blockBox = mineshaftPart.func_74874_b();
                this.entrances.add(new MutableBoundingBox(blockBox.field_78897_a, blockBox.field_78895_b, this.field_74887_e.field_78892_f - 1, blockBox.field_78893_d, blockBox.field_78894_e, this.field_74887_e.field_78892_f));
            }
            for (localXZ = 0; localXZ < this.field_74887_e.func_78880_d() && (localXZ += random.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d(); localXZ += 4) {
                mineshaftPart = MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + random.nextInt(localY) + 1, this.field_74887_e.field_78896_c + localXZ, Direction.WEST, componentType);
                if (mineshaftPart == null) continue;
                blockBox = mineshaftPart.func_74874_b();
                this.entrances.add(new MutableBoundingBox(this.field_74887_e.field_78897_a, blockBox.field_78895_b, blockBox.field_78896_c, this.field_74887_e.field_78897_a + 1, blockBox.field_78894_e, blockBox.field_78892_f));
            }
            for (localXZ = 0; localXZ < this.field_74887_e.func_78880_d() && (localXZ += random.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d(); localXZ += 4) {
                mineshaftPart = MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + random.nextInt(localY) + 1, this.field_74887_e.field_78896_c + localXZ, Direction.EAST, componentType);
                if (mineshaftPart == null) continue;
                blockBox = mineshaftPart.func_74874_b();
                this.entrances.add(new MutableBoundingBox(this.field_74887_e.field_78893_d - 1, blockBox.field_78895_b, blockBox.field_78896_c, this.field_74887_e.field_78893_d, blockBox.field_78894_e, blockBox.field_78892_f));
            }
        }

        public boolean func_230383_a_(ISeedReader readerIn, StructureManager manager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos) {
            if (this.func_74860_a((IBlockReader)readerIn, boundingBox)) {
                return false;
            }
            this.func_175804_a(readerIn, boundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, Blocks.field_150346_d.func_176223_P(), field_202556_l, true);
            this.func_175804_a(readerIn, boundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, Math.min(this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78894_e), this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
            for (MutableBoundingBox box : this.entrances) {
                this.func_175804_a(readerIn, boundingBox, box.field_78897_a, box.field_78894_e - 2, box.field_78896_c, box.field_78893_d, box.field_78894_e, box.field_78892_f, field_202556_l, field_202556_l, false);
            }
            this.func_180777_a(readerIn, boundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, field_202556_l, false);
            return true;
        }

        public void func_181138_a(int x, int y, int z) {
            super.func_181138_a(x, y, z);
            for (MutableBoundingBox boundingBox : this.entrances) {
                boundingBox.func_78886_a(x, y, z);
            }
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            ListNBT list = new ListNBT();
            for (MutableBoundingBox boundingBox : this.entrances) {
                list.add((Object)boundingBox.func_151535_h());
            }
            tagCompound.func_218657_a("Entrances", (INBT)list);
        }
    }

    private static abstract class MineshaftPart
    extends ModStructurePiece {
        protected ModMineshaftStructure.Type mineshaftType;

        protected MineshaftPart(IStructurePieceType structurePieceType, int componentType, ModMineshaftStructure.Type type, MutableBoundingBox boundingBox) {
            super(structurePieceType, componentType, boundingBox);
            this.mineshaftType = type;
        }

        public MineshaftPart(IStructurePieceType structurePieceType, CompoundNBT compoundNBT) {
            super(structurePieceType, compoundNBT);
            this.mineshaftType = ModMineshaftStructure.Type.byIndex(compoundNBT.func_74762_e("MST"));
        }

        @Override
        protected boolean canAddBlock(IWorldReader worldIn, int x, int y, int z, MutableBoundingBox boundingBox) {
            BlockState state = this.func_175807_a((IBlockReader)worldIn, x, y, z, boundingBox);
            return !state.func_203425_a(this.mineshaftType.getPlanks().func_177230_c()) && !state.func_203425_a(this.mineshaftType.getLog().func_177230_c()) && !state.func_203425_a(this.mineshaftType.getFence().func_177230_c()) && !state.func_203425_a(Blocks.field_235341_dI_);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            tagCompound.func_74768_a("MST", this.mineshaftType.ordinal());
        }

        protected boolean isSolidCeiling(IBlockReader readerIn, MutableBoundingBox boundingBox, int minX, int maxX, int y, int z) {
            for (int x = minX; x <= maxX; ++x) {
                if (!this.func_175807_a(readerIn, x, y + 1, z, boundingBox).func_196958_f()) continue;
                return false;
            }
            return true;
        }

        protected void generatePlanks(ISeedReader readerIn, MutableBoundingBox boundingBox, BlockState state, int x, int y, int z) {
            BlockPos.Mutable pos;
            BlockState blockState;
            if (this.func_189916_b((IWorldReader)readerIn, x, y, z, boundingBox) && ((blockState = readerIn.func_180495_p((BlockPos)(pos = new BlockPos.Mutable(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z))))).func_196958_f() || blockState.func_203425_a(Blocks.field_235341_dI_))) {
                readerIn.func_180501_a((BlockPos)pos, state, 2);
            }
        }

        public boolean canReplace(BlockState state) {
            return state.func_196958_f() || state.func_185904_a().func_76224_d() || state.func_203425_a((Block)CCBBlocks.GLOW_LICHEN.get()) || state.func_203425_a(Blocks.field_203198_aQ) || state.func_203425_a(Blocks.field_203199_aR);
        }

        public static BlockPos.Mutable setY(BlockPos.Mutable pos, int y) {
            pos.func_185336_p(y);
            return pos;
        }
    }

    public static class MineshaftCorridor
    extends MineshaftPart {
        private final boolean hasRails;
        private final boolean hasCobwebs;
        private boolean hasSpawner;
        private final int length;

        public MineshaftCorridor(TemplateManager manager, CompoundNBT compoundNBT) {
            super(CCBStructurePieces.MINESHAFT_CORRIDOR, compoundNBT);
            this.hasRails = compoundNBT.func_74767_n("hr");
            this.hasCobwebs = compoundNBT.func_74767_n("sc");
            this.hasSpawner = compoundNBT.func_74767_n("hps");
            this.length = compoundNBT.func_74762_e("Num");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("hr", this.hasRails);
            tagCompound.func_74757_a("sc", this.hasCobwebs);
            tagCompound.func_74757_a("hps", this.hasSpawner);
            tagCompound.func_74768_a("Num", this.length);
        }

        protected MineshaftCorridor(int componentType, Random random, MutableBoundingBox boundingBox, Direction direction, ModMineshaftStructure.Type type) {
            super(CCBStructurePieces.MINESHAFT_CORRIDOR, componentType, type, boundingBox);
            this.func_186164_a(direction);
            this.hasRails = random.nextInt(3) == 0;
            this.hasCobwebs = !this.hasRails && random.nextInt(23) == 0;
            this.length = this.func_186165_e().func_176740_k() == Direction.Axis.Z ? boundingBox.func_78880_d() / 5 : boundingBox.func_78883_b() / 5;
        }

        public static MutableBoundingBox getBoundingBox(List<StructurePiece> pieces, Random random, int x, int y, int z, Direction direction) {
            for (int chance = random.nextInt(3) + 2; chance > 0; --chance) {
                MutableBoundingBox boundingBox;
                int minY = chance * 5;
                switch (direction) {
                    default: {
                        boundingBox = new MutableBoundingBox(0, 0, -(minY - 1), 2, 2, 0);
                        break;
                    }
                    case SOUTH: {
                        boundingBox = new MutableBoundingBox(0, 0, 0, 2, 2, minY - 1);
                        break;
                    }
                    case WEST: {
                        boundingBox = new MutableBoundingBox(-(minY - 1), 0, 0, 0, 2, 2);
                        break;
                    }
                    case EAST: {
                        boundingBox = new MutableBoundingBox(0, 0, 0, minY - 1, 2, 2);
                    }
                }
                boundingBox.func_78886_a(x, y, z);
                StructurePiece.func_74883_a(pieces, (MutableBoundingBox)boundingBox);
            }
            return null;
        }

        public void func_74861_a(StructurePiece piece, List<StructurePiece> pieces, Random random) {
            block24: {
                int chainLength = this.func_74877_c();
                int chance = random.nextInt(4);
                Direction direction = this.func_186165_e();
                if (direction != null) {
                    switch (direction) {
                        default: {
                            if (chance <= 1) {
                                MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c - 1, direction, chainLength);
                                break;
                            }
                            if (chance == 2) {
                                MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c, Direction.WEST, chainLength);
                                break;
                            }
                            MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c, Direction.EAST, chainLength);
                            break;
                        }
                        case SOUTH: {
                            if (chance <= 1) {
                                MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78892_f + 1, direction, chainLength);
                                break;
                            }
                            if (chance == 2) {
                                MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78892_f - 3, Direction.WEST, chainLength);
                                break;
                            }
                            MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78892_f - 3, Direction.EAST, chainLength);
                            break;
                        }
                        case WEST: {
                            if (chance <= 1) {
                                MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c, direction, chainLength);
                                break;
                            }
                            if (chance == 2) {
                                MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c - 1, Direction.NORTH, chainLength);
                                break;
                            }
                            MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78892_f + 1, Direction.SOUTH, chainLength);
                            break;
                        }
                        case EAST: {
                            if (chance <= 1) {
                                MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c, direction, chainLength);
                                break;
                            }
                            if (chance == 2) {
                                MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c - 1, Direction.NORTH, chainLength);
                                break;
                            }
                            MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78892_f + 1, Direction.SOUTH, chainLength);
                        }
                    }
                }
                if (chainLength >= 8) break block24;
                if (direction != Direction.NORTH && direction != Direction.SOUTH) {
                    int localXZ = this.field_74887_e.field_78897_a + 3;
                    while (localXZ + 3 <= this.field_74887_e.field_78893_d) {
                        int directionChance = random.nextInt(5);
                        if (directionChance == 0) {
                            MineshaftGenerator.pieceGenerator(piece, pieces, random, localXZ, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, chainLength + 1);
                        } else if (directionChance == 1) {
                            MineshaftGenerator.pieceGenerator(piece, pieces, random, localXZ, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, chainLength + 1);
                        }
                        localXZ += 5;
                    }
                } else {
                    int localXZ = this.field_74887_e.field_78896_c + 3;
                    while (localXZ + 3 <= this.field_74887_e.field_78892_f) {
                        int directionChance = random.nextInt(5);
                        if (directionChance == 0) {
                            MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, localXZ, Direction.WEST, chainLength + 1);
                        } else if (directionChance == 1) {
                            MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, localXZ, Direction.EAST, chainLength + 1);
                        }
                        localXZ += 5;
                    }
                }
            }
        }

        protected boolean func_186167_a(ISeedReader readerIn, MutableBoundingBox boundingBox, Random random, int x, int y, int z, ResourceLocation lootId) {
            BlockPos blockPos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            if (boundingBox.func_175898_b((Vector3i)blockPos) && readerIn.func_180495_p(blockPos).func_196958_f() && !readerIn.func_180495_p(blockPos.func_177977_b()).func_196958_f()) {
                BlockState blockState = (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)(random.nextBoolean() ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST));
                this.func_175811_a(readerIn, blockState, x, y, z, this.field_74887_e);
                ChestMinecartEntity chestMinecart = new ChestMinecartEntity((World)readerIn.func_201672_e(), (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5);
                chestMinecart.func_184289_a(lootId, random.nextLong());
                readerIn.func_217376_c((Entity)chestMinecart);
                return true;
            }
            return false;
        }

        public boolean func_230383_a_(ISeedReader readerIn, StructureManager manager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos) {
            if (!this.func_74860_a((IBlockReader)readerIn, boundingBox)) {
                int realZ;
                int localZ;
                int localX;
                int maxZ = this.length * 5 - 1;
                BlockState blockState = this.mineshaftType.getPlanks();
                this.func_175804_a(readerIn, boundingBox, 0, 0, 0, 2, 1, maxZ, field_202556_l, field_202556_l, false);
                this.func_189914_a(readerIn, boundingBox, random, 0.8f, 0, 2, 0, 2, 2, maxZ, field_202556_l, field_202556_l, false, false);
                if (this.hasCobwebs) {
                    this.func_189914_a(readerIn, boundingBox, random, 0.6f, 0, 0, 0, 2, 1, maxZ, Blocks.field_196553_aF.func_176223_P(), field_202556_l, false, true);
                }
                for (localX = 0; localX < this.length; ++localX) {
                    int z;
                    localZ = 2 + localX * 5;
                    this.generateSupports(readerIn, boundingBox, 0, 0, localZ, 2, 2, random);
                    this.addCobwebsUnderground(readerIn, boundingBox, random, 0.1f, 0, 2, localZ - 1);
                    this.addCobwebsUnderground(readerIn, boundingBox, random, 0.1f, 2, 2, localZ - 1);
                    this.addCobwebsUnderground(readerIn, boundingBox, random, 0.1f, 0, 2, localZ + 1);
                    this.addCobwebsUnderground(readerIn, boundingBox, random, 0.1f, 2, 2, localZ + 1);
                    this.addCobwebsUnderground(readerIn, boundingBox, random, 0.05f, 0, 2, localZ - 2);
                    this.addCobwebsUnderground(readerIn, boundingBox, random, 0.05f, 2, 2, localZ - 2);
                    this.addCobwebsUnderground(readerIn, boundingBox, random, 0.05f, 0, 2, localZ + 2);
                    this.addCobwebsUnderground(readerIn, boundingBox, random, 0.05f, 2, 2, localZ + 2);
                    if (random.nextInt(100) == 0) {
                        this.func_186167_a(readerIn, boundingBox, random, 2, 0, localZ - 1, LootTables.field_186424_f);
                    }
                    if (random.nextInt(100) == 0) {
                        this.func_186167_a(readerIn, boundingBox, random, 0, 0, localZ + 1, LootTables.field_186424_f);
                    }
                    if (!this.hasCobwebs || this.hasSpawner) continue;
                    int y = this.func_74862_a(0);
                    realZ = localZ - 1 + random.nextInt(3);
                    int x = this.func_74865_a(1, realZ);
                    BlockPos blockPos = new BlockPos(x, y, z = this.func_74873_b(1, realZ));
                    if (!boundingBox.func_175898_b((Vector3i)blockPos) || !this.func_189916_b((IWorldReader)readerIn, 1, 0, realZ, boundingBox)) continue;
                    this.hasSpawner = true;
                    readerIn.func_180501_a(blockPos, Blocks.field_150474_ac.func_176223_P(), 2);
                    TileEntity tileEntity = readerIn.func_175625_s(blockPos);
                    if (!(tileEntity instanceof MobSpawnerTileEntity)) continue;
                    ((MobSpawnerTileEntity)tileEntity).func_145881_a().func_200876_a(EntityType.field_200794_h);
                }
                for (localX = 0; localX <= 2; ++localX) {
                    for (localZ = 0; localZ <= maxZ; ++localZ) {
                        this.generatePlanks(readerIn, boundingBox, blockState, localX, -1, localZ);
                    }
                }
                this.fillSupportBeam(readerIn, boundingBox, 0, -1, 2);
                if (this.length > 1) {
                    localZ = maxZ - 2;
                    this.fillSupportBeam(readerIn, boundingBox, 0, -1, localZ);
                }
                if (this.hasRails) {
                    BlockState blockState2 = (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.NORTH_SOUTH);
                    for (realZ = 0; realZ <= maxZ; ++realZ) {
                        BlockState state = this.func_175807_a((IBlockReader)readerIn, 1, -1, realZ, boundingBox);
                        if (state.func_196958_f() || !state.func_200015_d((IBlockReader)readerIn, new BlockPos(this.func_74865_a(1, realZ), this.func_74862_a(-1), this.func_74873_b(1, realZ)))) continue;
                        float chance = this.func_189916_b((IWorldReader)readerIn, 1, 0, realZ, boundingBox) ? 0.7f : 0.9f;
                        this.func_175809_a(readerIn, boundingBox, random, chance, 1, 0, realZ, blockState2);
                    }
                }
                return true;
            }
            return false;
        }

        private void fillSupportBeam(ISeedReader readerIn, MutableBoundingBox boundingBox, int x, int y, int z) {
            BlockState logState = this.mineshaftType.getLog();
            BlockState plankState = this.mineshaftType.getPlanks();
            if (this.func_175807_a((IBlockReader)readerIn, x, y, z, boundingBox).func_203425_a(plankState.func_177230_c())) {
                this.placePillarOrChain(readerIn, logState, x, y, z, boundingBox);
            }
            if (this.func_175807_a((IBlockReader)readerIn, x + 2, y, z, boundingBox).func_203425_a(plankState.func_177230_c())) {
                this.placePillarOrChain(readerIn, logState, x + 2, y, z, boundingBox);
            }
        }

        protected void func_175808_b(ISeedReader readerIn, BlockState state, int x, int y, int z, MutableBoundingBox boundingBox) {
            BlockPos.Mutable mutable = new BlockPos.Mutable(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            if (boundingBox.func_175898_b((Vector3i)mutable)) {
                int height = mutable.func_177956_o();
                while (this.canReplace(readerIn.func_180495_p((BlockPos)mutable)) && mutable.func_177956_o() > 1) {
                    mutable.func_189536_c(Direction.DOWN);
                }
                if (this.isNotRailOrLava(readerIn.func_180495_p((BlockPos)mutable))) {
                    while (mutable.func_177956_o() < height) {
                        mutable.func_189536_c(Direction.UP);
                        readerIn.func_180501_a((BlockPos)mutable, state, 3);
                    }
                }
            }
        }

        protected void placePillarOrChain(ISeedReader readerIn, BlockState state, int x, int y, int z, MutableBoundingBox box) {
            BlockPos.Mutable mutable = new BlockPos.Mutable(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            if (box.func_175898_b((Vector3i)mutable)) {
                int height = mutable.func_177956_o();
                int length = 1;
                boolean canGeneratePillars = true;
                boolean canGenerateChains = true;
                while (canGeneratePillars || canGenerateChains) {
                    boolean canReplace;
                    BlockState blockState;
                    if (canGeneratePillars) {
                        mutable.func_185336_p(height - length);
                        blockState = readerIn.func_180495_p((BlockPos)mutable);
                        boolean bl = canReplace = this.canReplace(blockState) && !blockState.func_203425_a(Blocks.field_150353_l);
                        if (!canReplace && this.isNotRailOrLava(blockState)) {
                            MineshaftCorridor.fillColumn(readerIn, state, mutable, height - length + 1, height);
                            return;
                        }
                        boolean bl2 = canGeneratePillars = length <= 20 && canReplace && mutable.func_177956_o() > 1;
                    }
                    if (canGenerateChains) {
                        mutable.func_185336_p(height + length);
                        blockState = readerIn.func_180495_p((BlockPos)mutable);
                        canReplace = this.canReplace(blockState);
                        if (!canReplace && this.sideCoversSmallSquare((IWorldReader)readerIn, (BlockPos)mutable, blockState)) {
                            readerIn.func_180501_a((BlockPos)MineshaftCorridor.setY(mutable, height + 1), this.mineshaftType.getFence(), 2);
                            MineshaftCorridor.fillColumn(readerIn, Blocks.field_235341_dI_.func_176223_P(), mutable, height + 2, height + length);
                            return;
                        }
                        canGenerateChains = length <= 50 && canReplace && mutable.func_177956_o() < readerIn.func_217301_I() - 1;
                    }
                    ++length;
                }
            }
        }

        private static void fillColumn(ISeedReader readerIn, BlockState state, BlockPos.Mutable pos, int startY, int endY) {
            for (int y = startY; y < endY; ++y) {
                readerIn.func_180501_a((BlockPos)MineshaftCorridor.setY(pos, y), state, 2);
            }
        }

        private boolean isNotRailOrLava(BlockState state) {
            return !state.func_203425_a(Blocks.field_150448_aq) && !state.func_203425_a(Blocks.field_150353_l);
        }

        private boolean sideCoversSmallSquare(IWorldReader readerIn, BlockPos pos, BlockState state) {
            return Block.func_220055_a((IWorldReader)readerIn, (BlockPos)pos, (Direction)Direction.DOWN) && !(state.func_177230_c() instanceof FallingBlock);
        }

        private void generateSupports(ISeedReader world, MutableBoundingBox boundingBox, int minX, int minY, int z, int maxY, int maxX, Random random) {
            if (this.isSolidCeiling((IBlockReader)world, boundingBox, minX, maxX, maxY, z)) {
                BlockState plankState = this.mineshaftType.getPlanks();
                BlockState fenceState = this.mineshaftType.getFence();
                this.func_175804_a(world, boundingBox, minX, minY, z, minX, maxY - 1, z, (BlockState)fenceState.func_206870_a((Property)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), field_202556_l, false);
                this.func_175804_a(world, boundingBox, maxX, minY, z, maxX, maxY - 1, z, (BlockState)fenceState.func_206870_a((Property)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), field_202556_l, false);
                if (random.nextInt(4) == 0) {
                    this.func_175804_a(world, boundingBox, minX, maxY, z, minX, maxY, z, plankState, field_202556_l, false);
                    this.func_175804_a(world, boundingBox, maxX, maxY, z, maxX, maxY, z, plankState, field_202556_l, false);
                } else {
                    this.func_175804_a(world, boundingBox, minX, maxY, z, maxX, maxY, z, plankState, field_202556_l, false);
                    this.func_175809_a(world, boundingBox, random, 0.05f, minX + 1, maxY, z - 1, (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.NORTH));
                    this.func_175809_a(world, boundingBox, random, 0.05f, minX + 1, maxY, z + 1, (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.SOUTH));
                }
            }
        }

        private void addCobwebsUnderground(ISeedReader world, MutableBoundingBox box, Random random, float threshold, int x, int y, int z) {
            if (this.func_189916_b((IWorldReader)world, x, y, z, box) && random.nextFloat() < threshold && this.isNeighbourSturdy(world, box, x, y, z, 2)) {
                this.func_175811_a(world, Blocks.field_196553_aF.func_176223_P(), x, y, z, box);
            }
        }

        private boolean isNeighbourSturdy(ISeedReader world, MutableBoundingBox box, int x, int y, int z, int count) {
            BlockPos.Mutable mutable = new BlockPos.Mutable(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            int i = 0;
            for (Direction direction : Direction.values()) {
                mutable.func_189536_c(direction);
                if (box.func_175898_b((Vector3i)mutable) && world.func_180495_p((BlockPos)mutable).func_224755_d((IBlockReader)world, (BlockPos)mutable, direction.func_176734_d()) && ++i >= count) {
                    return true;
                }
                mutable.func_189536_c(direction.func_176734_d());
            }
            return false;
        }
    }

    public static class MineshaftStairs
    extends MineshaftPart {
        protected MineshaftStairs(int componentType, MutableBoundingBox boundingBox, Direction direction, ModMineshaftStructure.Type type) {
            super(CCBStructurePieces.MINESHAFT_STAIRS, componentType, type, boundingBox);
            this.func_186164_a(direction);
        }

        public MineshaftStairs(TemplateManager manager, CompoundNBT compoundNBT) {
            super(CCBStructurePieces.MINESHAFT_STAIRS, compoundNBT);
        }

        public static MutableBoundingBox getBoundingBox(List<StructurePiece> pieces, Random random, int x, int y, int z, Direction direction) {
            MutableBoundingBox blockBox4;
            switch (direction) {
                default: {
                    blockBox4 = new MutableBoundingBox(0, -5, -8, 2, 2, 0);
                    break;
                }
                case SOUTH: {
                    blockBox4 = new MutableBoundingBox(0, -5, 0, 2, 2, 8);
                    break;
                }
                case WEST: {
                    blockBox4 = new MutableBoundingBox(-8, -5, 0, 0, 2, 2);
                    break;
                }
                case EAST: {
                    blockBox4 = new MutableBoundingBox(0, -5, 0, 8, 2, 2);
                }
            }
            blockBox4.func_78886_a(x, y, z);
            return StructurePiece.func_74883_a(pieces, (MutableBoundingBox)blockBox4) != null ? null : blockBox4;
        }

        public void func_74861_a(StructurePiece piece, List<StructurePiece> pieces, Random random) {
            int chainLength = this.func_74877_c();
            Direction direction = this.func_186165_e();
            if (direction != null) {
                switch (direction) {
                    default: {
                        MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, chainLength);
                        break;
                    }
                    case SOUTH: {
                        MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, chainLength);
                        break;
                    }
                    case WEST: {
                        MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, Direction.WEST, chainLength);
                        break;
                    }
                    case EAST: {
                        MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, Direction.EAST, chainLength);
                    }
                }
            }
        }

        public boolean func_230383_a_(ISeedReader readerIn, StructureManager manager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos) {
            if (!this.func_74860_a((IBlockReader)readerIn, boundingBox)) {
                this.func_175804_a(readerIn, boundingBox, 0, 5, 0, 2, 7, 1, field_202556_l, field_202556_l, false);
                this.func_175804_a(readerIn, boundingBox, 0, 0, 7, 2, 2, 8, field_202556_l, field_202556_l, false);
                for (int i = 0; i < 5; ++i) {
                    this.func_175804_a(readerIn, boundingBox, 0, 5 - i - (i < 4 ? 1 : 0), 2 + i, 2, 7 - i, 2 + i, field_202556_l, field_202556_l, false);
                }
                return true;
            }
            return false;
        }
    }

    public static class MineshaftCrossing
    extends MineshaftPart {
        private final Direction direction;
        private final boolean twoFloors;

        public MineshaftCrossing(TemplateManager manager, CompoundNBT compoundNBT) {
            super(CCBStructurePieces.MINESHAFT_CROSSING, compoundNBT);
            this.twoFloors = compoundNBT.func_74767_n("tf");
            this.direction = Direction.func_176731_b((int)compoundNBT.func_74762_e("D"));
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("tf", this.twoFloors);
            tagCompound.func_74768_a("D", this.direction.func_176736_b());
        }

        public MineshaftCrossing(int componentType, MutableBoundingBox boundingBox, Direction direction, ModMineshaftStructure.Type type) {
            super(CCBStructurePieces.MINESHAFT_CROSSING, componentType, type, boundingBox);
            this.direction = direction;
            this.twoFloors = boundingBox.func_78882_c() > 3;
        }

        public static MutableBoundingBox getBoundingBox(List<StructurePiece> pieces, Random random, int x, int y, int z, Direction direction) {
            MutableBoundingBox boundingBox;
            int maxY = random.nextInt(4) == 0 ? 6 : 2;
            switch (direction) {
                default: {
                    boundingBox = new MutableBoundingBox(-1, 0, -4, 3, maxY, 0);
                    break;
                }
                case SOUTH: {
                    boundingBox = new MutableBoundingBox(-1, 0, 0, 3, maxY, 4);
                    break;
                }
                case WEST: {
                    boundingBox = new MutableBoundingBox(-4, 0, -1, 0, maxY, 3);
                    break;
                }
                case EAST: {
                    boundingBox = new MutableBoundingBox(0, 0, -1, 4, maxY, 3);
                }
            }
            boundingBox.func_78886_a(x, y, z);
            return StructurePiece.func_74883_a(pieces, (MutableBoundingBox)boundingBox) != null ? null : boundingBox;
        }

        public void func_74861_a(StructurePiece piece, List<StructurePiece> pieces, Random random) {
            int chainLength = this.func_74877_c();
            switch (this.direction) {
                default: {
                    MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, chainLength);
                    MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.WEST, chainLength);
                    MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.EAST, chainLength);
                    break;
                }
                case SOUTH: {
                    MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, chainLength);
                    MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.WEST, chainLength);
                    MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.EAST, chainLength);
                    break;
                }
                case WEST: {
                    MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, chainLength);
                    MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, chainLength);
                    MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.WEST, chainLength);
                    break;
                }
                case EAST: {
                    MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, chainLength);
                    MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, chainLength);
                    MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.EAST, chainLength);
                }
            }
            if (this.twoFloors) {
                if (random.nextBoolean()) {
                    MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c - 1, Direction.NORTH, chainLength);
                }
                if (random.nextBoolean()) {
                    MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, Direction.WEST, chainLength);
                }
                if (random.nextBoolean()) {
                    MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, Direction.EAST, chainLength);
                }
                if (random.nextBoolean()) {
                    MineshaftGenerator.pieceGenerator(piece, pieces, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, chainLength);
                }
            }
        }

        public boolean func_230383_a_(ISeedReader readerIn, StructureManager manager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos) {
            if (!this.func_74860_a((IBlockReader)readerIn, boundingBox)) {
                BlockState state = this.mineshaftType.getPlanks();
                if (this.twoFloors) {
                    this.func_175804_a(readerIn, boundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
                    this.func_175804_a(readerIn, boundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
                    this.func_175804_a(readerIn, boundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
                    this.func_175804_a(readerIn, boundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
                    this.func_175804_a(readerIn, boundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
                } else {
                    this.func_175804_a(readerIn, boundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
                    this.func_175804_a(readerIn, boundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
                }
                this.generateCrossingPillar(readerIn, boundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78894_e);
                this.generateCrossingPillar(readerIn, boundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78894_e);
                this.generateCrossingPillar(readerIn, boundingBox, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78894_e);
                this.generateCrossingPillar(readerIn, boundingBox, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78894_e);
                int y = this.field_74887_e.field_78895_b - 1;
                for (int x = this.field_74887_e.field_78897_a; x <= this.field_74887_e.field_78893_d; ++x) {
                    for (int z = this.field_74887_e.field_78896_c; z <= this.field_74887_e.field_78892_f; ++z) {
                        this.generatePlanks(readerIn, boundingBox, state, x, y, z);
                    }
                }
                return true;
            }
            return false;
        }

        private void generateCrossingPillar(ISeedReader readerIn, MutableBoundingBox boundingBox, int x, int minY, int z, int maxY) {
            if (!this.func_175807_a((IBlockReader)readerIn, x, maxY + 1, z, boundingBox).func_196958_f()) {
                this.func_175804_a(readerIn, boundingBox, x, minY, z, x, maxY, z, this.mineshaftType.getPlanks(), field_202556_l, false);
            }
        }
    }
}

