/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.surfacebuilder;

import com.blackgear.cavesandcliffs.common.world.gen.NoiseHelper;
import com.blackgear.cavesandcliffs.core.registries.worldgen.CCBSurfaceBuilders;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.MaxMinNoiseMixer;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class StoneSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private long seed;
    private MaxMinNoiseMixer layerBlockNoise;
    private MaxMinNoiseMixer layerNoise;

    public StoneSurfaceBuilder(Codec<SurfaceBuilderConfig> config) {
        super(config);
    }

    public void buildSurface(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        SurfaceBuilderConfig surfaceBuilderConfig;
        double layerNoise = this.layerNoise.func_237211_a_((double)x, (double)z, (double)startHeight);
        if (layerNoise > -0.25 && layerNoise < 0.25) {
            double layerBlockNoise = this.layerBlockNoise.func_237211_a_((double)x, (double)startHeight, (double)z);
            surfaceBuilderConfig = this.getLayerBlockConfig(layerBlockNoise);
        } else {
            surfaceBuilderConfig = SurfaceBuilder.field_215427_x;
        }
        SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)surfaceBuilderConfig);
    }

    protected SurfaceBuilderConfig getLayerBlockConfig(double noise) {
        SurfaceBuilderConfig config = noise < (double)-0.3f ? CCBSurfaceBuilders.Configs.DIORITE_CONFIG : (noise < 0.0 ? CCBSurfaceBuilders.Configs.ANDESITE_CONFIG : (noise < (double)0.3f ? SurfaceBuilder.field_215424_u : CCBSurfaceBuilders.Configs.GRANITE_CONFIG));
        return config;
    }

    public void func_205548_a(long seed) {
        if (this.seed != seed) {
            SharedSeedRandom random = new SharedSeedRandom(seed);
            this.layerNoise = NoiseHelper.createMultiNoise(random, -7, 1.0, 1.0, 0.0);
            this.layerBlockNoise = NoiseHelper.createMultiNoise(random, -8, 1.0);
        }
        this.seed = seed;
    }
}

