/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.core.registries.worldgen;

import com.blackgear.cavesandcliffs.common.world.gen.surfacebuilder.GroveSurfaceBuilder;
import com.blackgear.cavesandcliffs.common.world.gen.surfacebuilder.LoftyPeaksSurfaceBuilder;
import com.blackgear.cavesandcliffs.common.world.gen.surfacebuilder.SnowcappedPeaksSurfaceBuilder;
import com.blackgear.cavesandcliffs.common.world.gen.surfacebuilder.SnowySlopesSurfaceBuilder;
import com.blackgear.cavesandcliffs.common.world.gen.surfacebuilder.StoneSurfaceBuilder;
import com.blackgear.cavesandcliffs.common.world.gen.surfacebuilder.StonyPeaksSurfaceBuilder;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.mojang.serialization.Codec;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="cavesandcliffs", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CCBSurfaceBuilders {
    public static final SurfaceBuilder<SurfaceBuilderConfig> GROVE = new GroveSurfaceBuilder((Codec<SurfaceBuilderConfig>)SurfaceBuilderConfig.field_237203_a_);
    public static final SurfaceBuilder<SurfaceBuilderConfig> SNOWCAPPED_PEAKS = new SnowcappedPeaksSurfaceBuilder((Codec<SurfaceBuilderConfig>)SurfaceBuilderConfig.field_237203_a_);
    public static final SurfaceBuilder<SurfaceBuilderConfig> SNOWY_SLOPES = new SnowySlopesSurfaceBuilder((Codec<SurfaceBuilderConfig>)SurfaceBuilderConfig.field_237203_a_);
    public static final SurfaceBuilder<SurfaceBuilderConfig> LOFTY_PEAKS = new LoftyPeaksSurfaceBuilder((Codec<SurfaceBuilderConfig>)SurfaceBuilderConfig.field_237203_a_);
    public static final SurfaceBuilder<SurfaceBuilderConfig> STONE_SHORE = new StoneSurfaceBuilder((Codec<SurfaceBuilderConfig>)SurfaceBuilderConfig.field_237203_a_);
    public static final SurfaceBuilder<SurfaceBuilderConfig> STONY_PEAKS = new StonyPeaksSurfaceBuilder((Codec<SurfaceBuilderConfig>)SurfaceBuilderConfig.field_237203_a_);

    @SubscribeEvent
    public static void registerSurfaceBuilder(RegistryEvent.Register<SurfaceBuilder<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SurfaceBuilder[]{(SurfaceBuilder)GROVE.setRegistryName("cavesandcliffs", "grove"), (SurfaceBuilder)SNOWCAPPED_PEAKS.setRegistryName("cavesandcliffs", "snowcapped_peaks"), (SurfaceBuilder)SNOWY_SLOPES.setRegistryName("cavesandcliffs", "snowy_slopes"), (SurfaceBuilder)LOFTY_PEAKS.setRegistryName("cavesandcliffs", "lofty_peaks"), (SurfaceBuilder)STONE_SHORE.setRegistryName("cavesandcliffs", "stone_shore"), (SurfaceBuilder)STONY_PEAKS.setRegistryName("cavesandcliffs", "stony_peaks")});
    }

    public static class Configured {
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> GROVE = GROVE.func_242929_a((ISurfaceBuilderConfig)Configs.DIRT_SNOW_CONFIG);
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> SNOWCAPPED_PEAKS = SNOWCAPPED_PEAKS.func_242929_a((ISurfaceBuilderConfig)Configs.SNOW_PEAKS_CONFIG);
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> LOFTY_PEAKS = LOFTY_PEAKS.func_242929_a((ISurfaceBuilderConfig)Configs.LOFTY_PEAKS_CONFIG);
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> STONY_PEAKS = STONY_PEAKS.func_242929_a((ISurfaceBuilderConfig)SurfaceBuilder.field_215427_x);
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> SNOWY_SLOPES = SNOWY_SLOPES.func_242929_a((ISurfaceBuilderConfig)Configs.SNOW_CONFIG);
        public static final ConfiguredSurfaceBuilder<SurfaceBuilderConfig> STONE_SHORE = STONE_SHORE.func_242929_a((ISurfaceBuilderConfig)SurfaceBuilder.field_215427_x);

        private static <SC extends ISurfaceBuilderConfig> void register(String key, ConfiguredSurfaceBuilder<SC> surface) {
            WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243651_c, (ResourceLocation)new ResourceLocation("cavesandcliffs", key), surface);
        }

        public static void registerConfiguredSurfaceBuilders() {
            Configured.register("grove", GROVE);
            Configured.register("snowcapped_peaks", SNOWCAPPED_PEAKS);
            Configured.register("lofty_peaks", LOFTY_PEAKS);
            Configured.register("stony_peaks", STONY_PEAKS);
            Configured.register("snowy_slopes", SNOWY_SLOPES);
            Configured.register("stone_shore", STONE_SHORE);
        }
    }

    public static class Configs {
        public static final BlockState DIRT = Blocks.field_150346_d.func_176223_P();
        public static final BlockState GRAVEL = Blocks.field_150351_n.func_176223_P();
        public static final BlockState GRANITE = Blocks.field_196650_c.func_176223_P();
        public static final BlockState ANDESITE = Blocks.field_196656_g.func_176223_P();
        public static final BlockState DIORITE = Blocks.field_196654_e.func_176223_P();
        public static final BlockState CALCITE = ((Block)CCBBlocks.CALCITE.get()).func_176223_P();
        public static final BlockState STONE = Blocks.field_150348_b.func_176223_P();
        public static final BlockState SNOW_BLOCK = Blocks.field_196604_cC.func_176223_P();
        public static final SurfaceBuilderConfig GRANITE_CONFIG = new SurfaceBuilderConfig(GRANITE, GRANITE, GRANITE);
        public static final SurfaceBuilderConfig ANDESITE_CONFIG = new SurfaceBuilderConfig(ANDESITE, ANDESITE, ANDESITE);
        public static final SurfaceBuilderConfig DIORITE_CONFIG = new SurfaceBuilderConfig(DIORITE, DIORITE, DIORITE);
        public static final SurfaceBuilderConfig CALCITE_CONFIG = new SurfaceBuilderConfig(CALCITE, CALCITE, CALCITE);
        public static final SurfaceBuilderConfig DIRT_SNOW_CONFIG = new SurfaceBuilderConfig(SNOW_BLOCK, DIRT, GRAVEL);
        public static final SurfaceBuilderConfig SNOW_CONFIG = new SurfaceBuilderConfig(SNOW_BLOCK, SNOW_BLOCK, GRAVEL);
        public static final SurfaceBuilderConfig LOFTY_PEAKS_CONFIG = new SurfaceBuilderConfig(SNOW_BLOCK, STONE, STONE);
        public static final SurfaceBuilderConfig SNOW_PEAKS_CONFIG = new SurfaceBuilderConfig(SNOW_BLOCK, SNOW_BLOCK, STONE);
    }
}

