/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.mixin.common.entity;

import com.blackgear.cavesandcliffs.common.blocks.PowderSnowBlock;
import com.blackgear.cavesandcliffs.common.entity.IFreezeable;
import com.blackgear.cavesandcliffs.common.util.EntityHelper;
import com.blackgear.cavesandcliffs.core.other.tags.CCBEntityTypeTags;
import com.blackgear.cavesandcliffs.core.other.tags.CCBItemTags;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements IFreezeable {
    @Shadow
    protected boolean field_70703_bu;
    private static final DataParameter<Integer> FROZEN_TICKS = EntityDataManager.func_187226_a(LivingEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final UUID POWDER_SNOW_SLOW_ID = UUID.fromString("1eaf83ff-7207-4596-b37a-d7a07b3ec4ce");
    public boolean inPowderSnow;
    public boolean wasInPowderSnow;

    @Shadow
    @Nullable
    public abstract ModifiableAttributeInstance func_110148_a(Attribute var1);

    @Shadow
    public abstract void func_70037_a(CompoundNBT var1);

    @Shadow
    public abstract boolean func_70097_a(DamageSource var1, float var2);

    @Shadow
    protected abstract ItemStack func_241346_d_(EquipmentSlotType var1);

    @Shadow
    public abstract boolean func_70617_f_();

    @Shadow
    public abstract BlockState func_213339_cH();

    @Shadow
    protected abstract float func_213335_r(float var1);

    @Shadow
    protected abstract Vector3d func_213362_f(Vector3d var1);

    public LivingEntityMixin(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Inject(method={"registerData"}, at={@At(value="HEAD")})
    public void ccb$registerData(CallbackInfo ci) {
        this.field_70180_af.func_187214_a(FROZEN_TICKS, (Object)0);
    }

    @Inject(method={"func_233633_a_(Lnet/minecraft/util/math/vector/Vector3d;F)Lnet/minecraft/util/math/vector/Vector3d;"}, at={@At(value="HEAD")}, cancellable=true)
    public void ccb$applyMovementInput(Vector3d vec, float slipperiness, CallbackInfoReturnable<Vector3d> cir) {
        this.func_213309_a(this.func_213335_r(slipperiness), vec);
        this.func_213317_d(this.func_213362_f(this.func_213322_ci()));
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        Vector3d motion = this.func_213322_ci();
        if ((this.field_70123_F || this.field_70703_bu) && (this.func_70617_f_() || this.field_70170_p.func_180495_p(this.func_233580_cy_()).func_203425_a((Block)CCBBlocks.POWDER_SNOW.get()) && PowderSnowBlock.canWalkOnPowderSnow(this))) {
            motion = new Vector3d(motion.field_72450_a, 0.2, motion.field_72449_c);
        }
        cir.setReturnValue((Object)motion);
    }

    @Inject(method={"baseTick()V"}, at={@At(value="HEAD")})
    public void ccb$baseTick(CallbackInfo ci) {
        this.wasInPowderSnow = this.inPowderSnow;
        this.inPowderSnow = false;
        if (this.func_223314_ad() > 0 && (Integer)this.field_70180_af.func_187225_a(FROZEN_TICKS) > 0) {
            this.field_70180_af.func_187227_b(FROZEN_TICKS, (Object)0);
            this.field_70170_p.func_217378_a(null, 1009, this.func_233580_cy_(), 1);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void ccb$livingTickTest(CallbackInfo ci) {
        int ticks;
        this.field_70170_p.func_217381_Z().func_76320_a("freezing");
        boolean freezeHurtExtra = this.func_200600_R().func_220341_a(CCBEntityTypeTags.FREEZE_HURT_EXTRA_TYPES);
        if (!this.field_70170_p.func_201670_d() && this.func_70089_S()) {
            ticks = this.getFrozenTicks();
            if (this.inPowderSnow && this.canFreeze()) {
                this.setFrozenTicks(Math.min(this.getMinFreezeDamageTicks(), ticks + 1));
            } else {
                this.setFrozenTicks(Math.max(0, ticks - 2));
            }
        }
        this.removePowderSnowSlow();
        this.addPowderSnowSlowIfNeeded();
        if (!this.field_70170_p.func_201670_d() && this.field_70173_aa % 40 == 0 && this.isFreezing() && this.canFreeze()) {
            ticks = freezeHurtExtra ? 5 : 1;
            LivingEntity entity = (LivingEntity)this;
            if (entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_() || entity instanceof SkeletonEntity) {
                return;
            }
            this.func_70097_a(EntityHelper.FREEZE, ticks);
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
    }

    protected void removePowderSnowSlow() {
        ModifiableAttributeInstance attribute = this.func_110148_a(Attributes.field_233821_d_);
        if (attribute != null && attribute.func_111127_a(POWDER_SNOW_SLOW_ID) != null) {
            attribute.func_188479_b(POWDER_SNOW_SLOW_ID);
        }
    }

    protected void addPowderSnowSlowIfNeeded() {
        int ticks;
        if (!this.func_233568_aJ_().func_196958_f() && (ticks = ((Integer)this.field_70180_af.func_187225_a(FROZEN_TICKS)).intValue()) > 0) {
            ModifiableAttributeInstance attribute = this.func_110148_a(Attributes.field_233821_d_);
            if (attribute == null) {
                return;
            }
            float value = -0.05f * this.getFreezingScale();
            attribute.func_233767_b_(new AttributeModifier(POWDER_SNOW_SLOW_ID, "Powder snow slow", (double)value, AttributeModifier.Operation.ADDITION));
        }
    }

    @Override
    public void setInPowderSnow(boolean inPowderSnow) {
        this.inPowderSnow = inPowderSnow;
    }

    @Override
    public boolean canFreeze() {
        if (this.func_175149_v()) {
            return false;
        }
        boolean hasFreezeImmunity = !this.func_241346_d_(EquipmentSlotType.HEAD).func_77973_b().func_206844_a(CCBItemTags.FREEZE_IMMUNE_WEARABLES) && !this.func_241346_d_(EquipmentSlotType.CHEST).func_77973_b().func_206844_a(CCBItemTags.FREEZE_IMMUNE_WEARABLES) && !this.func_241346_d_(EquipmentSlotType.LEGS).func_77973_b().func_206844_a(CCBItemTags.FREEZE_IMMUNE_WEARABLES) && !this.func_241346_d_(EquipmentSlotType.FEET).func_77973_b().func_206844_a(CCBItemTags.FREEZE_IMMUNE_WEARABLES);
        return hasFreezeImmunity && !CCBEntityTypeTags.FREEZE_IMMUNE_ENTITY_TYPES.func_230235_a_((Object)this.func_200600_R());
    }

    @Override
    public boolean inPowderSnow() {
        return this.inPowderSnow;
    }

    @Override
    public int getFrozenTicks() {
        return (Integer)this.field_70180_af.func_187225_a(FROZEN_TICKS);
    }

    @Override
    public void setFrozenTicks(int frozenTicks) {
        this.field_70180_af.func_187227_b(FROZEN_TICKS, (Object)frozenTicks);
    }

    @Override
    public float getFreezingScale() {
        int minTicks = this.getMinFreezeDamageTicks();
        return (float)Math.min(this.getFrozenTicks(), minTicks) / (float)minTicks;
    }

    @Override
    public boolean isFreezing() {
        return this.getFrozenTicks() >= this.getMinFreezeDamageTicks();
    }

    @Override
    public int getMinFreezeDamageTicks() {
        return 140;
    }
}

