/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.chocolate.mixin.world.biome;

import com.alcatrazescapee.chocolate.common.biome.BiomeBridge;
import com.alcatrazescapee.chocolate.common.biome.BiomeContainerBridge;
import net.minecraft.util.IObjectIntIterable;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BiomeContainer.class})
public abstract class BiomeContainerMixin
implements BiomeContainerBridge {
    @Shadow
    @Final
    private Biome[] field_227054_f_;
    private Registry<Biome> chocolate$biomeRegistry;

    @Override
    public Registry<Biome> bridge$getActualBiomeRegistry() {
        return this.chocolate$biomeRegistry;
    }

    @Override
    public Biome[] bridge$getInternalBiomeArray() {
        return this.field_227054_f_;
    }

    @Inject(method={"<init>(Lnet/minecraft/util/IObjectIntIterable;[Lnet/minecraft/world/biome/Biome;)V"}, at={@At(value="RETURN")})
    private void inject$init(IObjectIntIterable<Biome> biomeRegistry, Biome[] biomes, CallbackInfo ci) {
        if (!(biomeRegistry instanceof Registry)) {
            throw new IllegalArgumentException("[Please Report this to Chocolate!] Biome Registry was not a subclass of Registry<Biome>. This is very bad and will cause many problems!");
        }
        this.chocolate$biomeRegistry = (Registry)biomeRegistry;
    }

    @Inject(method={"writeBiomes"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject$writeBiomes(CallbackInfoReturnable<int[]> cir) {
        int[] biomeIds = new int[this.field_227054_f_.length];
        Biome lastBiome = null;
        int lastId = -1;
        for (int i = 0; i < this.field_227054_f_.length; ++i) {
            Biome biome = this.field_227054_f_[i];
            if (biome != lastBiome) {
                lastBiome = biome;
                lastId = this.chocolate$biomeRegistry.func_148757_b(this.chocolate$biomeRegistry.func_230516_a_(BiomeBridge.of(biome).bridge$getKey()));
            }
            biomeIds[i] = lastId;
        }
        cir.setReturnValue((Object)biomeIds);
    }
}

