/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.QueuedTooltip;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.ScrollingContainer;
import me.shedaniel.clothconfig2.api.Tooltip;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.gui.AbstractTabbedConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigTabButton;
import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.clothconfig2.impl.EasingMethod;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public class ClothConfigScreen
extends AbstractTabbedConfigScreen {
    private final ScrollingContainer tabsScroller = new ScrollingContainer(){

        @Override
        public Rectangle getBounds() {
            return new Rectangle(0, 0, 1, ClothConfigScreen.this.field_230708_k_ - 40);
        }

        @Override
        public int getMaxScrollHeight() {
            return (int)ClothConfigScreen.this.getTabsMaximumScrolled();
        }

        @Override
        public void updatePosition(float delta) {
            super.updatePosition(delta);
            this.scrollAmount = this.clamp(this.scrollAmount, 0.0);
        }
    };
    public ListWidget<AbstractConfigEntry<AbstractConfigEntry<?>>> listWidget;
    private final LinkedHashMap<ITextComponent, List<AbstractConfigEntry<?>>> categorizedEntries = Maps.newLinkedHashMap();
    private final List<Tuple<ITextComponent, Integer>> tabs;
    private Widget quitButton;
    private Widget saveButton;
    private Widget buttonLeftTab;
    private Widget buttonRightTab;
    private Rectangle tabsBounds;
    private Rectangle tabsLeftBounds;
    private Rectangle tabsRightBounds;
    private double tabsMaximumScrolled = -1.0;
    private final List<ClothConfigTabButton> tabButtons = Lists.newArrayList();
    private final Map<ITextComponent, ConfigCategory> categoryMap;

    @ApiStatus.Internal
    public ClothConfigScreen(Screen parent, ITextComponent title, Map<ITextComponent, ConfigCategory> categoryMap, ResourceLocation backgroundLocation) {
        super(parent, title, backgroundLocation);
        categoryMap.forEach((categoryName, category) -> {
            ArrayList entries = Lists.newArrayList();
            for (Object object : category.getEntries()) {
                AbstractConfigListEntry entry = object instanceof Tuple ? (AbstractConfigListEntry)((Tuple)object).func_76340_b() : (AbstractConfigListEntry)object;
                entry.setScreen(this);
                entries.add(entry);
            }
            this.categorizedEntries.put((ITextComponent)categoryName, entries);
            if (category.getBackground() != null) {
                this.registerCategoryBackground((ITextComponent)categoryName, category.getBackground());
            }
        });
        this.tabs = this.categorizedEntries.keySet().stream().map(s -> new Tuple(s, (Object)(Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)s) + 8))).collect(Collectors.toList());
        this.categoryMap = categoryMap;
    }

    @Override
    public ITextComponent getSelectedCategory() {
        return (ITextComponent)this.tabs.get(this.selectedCategoryIndex).func_76341_a();
    }

    @Override
    public Map<ITextComponent, List<AbstractConfigEntry<?>>> getCategorizedEntries() {
        return this.categorizedEntries;
    }

    @Override
    public boolean isEdited() {
        return super.isEdited();
    }

    @Override
    @Deprecated
    public void setEdited(boolean edited) {
        super.setEdited(edited);
    }

    @Override
    @Deprecated
    public void setEdited(boolean edited, boolean requiresRestart) {
        super.setEdited(edited, requiresRestart);
    }

    @Override
    public void saveAll(boolean openOtherScreens) {
        super.saveAll(openOtherScreens);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.tabButtons.clear();
        this.listWidget = new ListWidget(this, this.field_230706_i_, this.field_230708_k_, this.field_230709_l_, this.isShowingTabs() ? 70 : 30, this.field_230709_l_ - 32, this.getBackgroundLocation());
        this.field_230705_e_.add(this.listWidget);
        if (this.categorizedEntries.size() > this.selectedCategoryIndex) {
            this.listWidget.func_231039_at__().addAll((List)Lists.newArrayList(this.categorizedEntries.values()).get(this.selectedCategoryIndex));
        }
        int buttonWidths = Math.min(200, (this.field_230708_k_ - 50 - 12) / 3);
        this.quitButton = new Button(this.field_230708_k_ / 2 - buttonWidths - 3, this.field_230709_l_ - 26, buttonWidths, 20, (ITextComponent)(this.isEdited() ? new TranslationTextComponent("text.cloth-config.cancel_discard") : new TranslationTextComponent("gui.cancel")), widget -> this.quit());
        this.func_230480_a_(this.quitButton);
        this.saveButton = new Button(this.field_230708_k_ / 2 + 3, this.field_230709_l_ - 26, buttonWidths, 20, NarratorChatListener.field_216868_a, button -> this.saveAll(true)){

            public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
                boolean hasErrors = false;
                for (List entries : Lists.newArrayList(ClothConfigScreen.this.categorizedEntries.values())) {
                    for (AbstractConfigEntry entry : entries) {
                        if (!entry.getConfigError().isPresent()) continue;
                        hasErrors = true;
                        break;
                    }
                    if (!hasErrors) continue;
                    break;
                }
                this.field_230693_o_ = ClothConfigScreen.this.isEdited() && !hasErrors;
                this.func_238482_a_((ITextComponent)(hasErrors ? new TranslationTextComponent("text.cloth-config.error_cannot_save") : new TranslationTextComponent("text.cloth-config.save_and_done")));
                super.func_230430_a_(matrices, mouseX, mouseY, delta);
            }
        };
        this.func_230480_a_(this.saveButton);
        this.saveButton.field_230693_o_ = this.isEdited();
        if (this.isShowingTabs()) {
            this.tabsBounds = new Rectangle(0, 41, this.field_230708_k_, 24);
            this.tabsLeftBounds = new Rectangle(0, 41, 18, 24);
            this.tabsRightBounds = new Rectangle(this.field_230708_k_ - 18, 41, 18, 24);
            this.buttonLeftTab = new Button(4, 44, 12, 18, NarratorChatListener.field_216868_a, button -> this.tabsScroller.scrollTo(0.0, true)){

                public void func_230431_b_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
                    ClothConfigScreen.this.field_230706_i_.func_110434_K().func_110577_a(AbstractConfigScreen.CONFIG_TEX);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
                    int int_3 = this.func_230989_a_(this.func_230449_g_());
                    RenderSystem.enableBlend();
                    RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
                    RenderSystem.blendFunc((int)770, (int)771);
                    this.func_238474_b_(matrices, this.field_230690_l_, this.field_230691_m_, 12, 18 * int_3, this.field_230688_j_, this.field_230689_k_);
                }
            };
            this.field_230705_e_.add(this.buttonLeftTab);
            int j = 0;
            for (Tuple<ITextComponent, Integer> tab : this.tabs) {
                this.tabButtons.add(new ClothConfigTabButton(this, j, -100, 43, (Integer)tab.func_76340_b(), 20, (ITextComponent)tab.func_76341_a(), this.categoryMap.get(tab.func_76341_a()).getDescription()));
                ++j;
            }
            this.field_230705_e_.addAll(this.tabButtons);
            this.buttonRightTab = new Button(this.field_230708_k_ - 16, 44, 12, 18, NarratorChatListener.field_216868_a, button -> this.tabsScroller.scrollTo(this.tabsScroller.getMaxScroll(), true)){

                public void func_230431_b_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
                    ClothConfigScreen.this.field_230706_i_.func_110434_K().func_110577_a(AbstractConfigScreen.CONFIG_TEX);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
                    int int_3 = this.func_230989_a_(this.func_230449_g_());
                    RenderSystem.enableBlend();
                    RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
                    RenderSystem.blendFunc((int)770, (int)771);
                    this.func_238474_b_(matrices, this.field_230690_l_, this.field_230691_m_, 0, 18 * int_3, this.field_230688_j_, this.field_230689_k_);
                }
            };
            this.field_230705_e_.add(this.buttonRightTab);
        } else {
            this.tabsLeftBounds = this.tabsRightBounds = new Rectangle();
            this.tabsBounds = this.tabsRightBounds;
        }
        Optional.ofNullable(this.afterInitConsumer).ifPresent(consumer -> consumer.accept(this));
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (this.tabsBounds.contains(mouseX, mouseY) && !this.tabsLeftBounds.contains(mouseX, mouseY) && !this.tabsRightBounds.contains(mouseX, mouseY) && amount != 0.0) {
            this.tabsScroller.offset(-amount * 16.0, true);
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, amount);
    }

    public double getTabsMaximumScrolled() {
        if (this.tabsMaximumScrolled == -1.0) {
            int[] i = new int[]{0};
            for (Tuple<ITextComponent, Integer> pair : this.tabs) {
                i[0] = i[0] + ((Integer)pair.func_76340_b() + 2);
            }
            this.tabsMaximumScrolled = i[0];
        }
        return this.tabsMaximumScrolled + 6.0;
    }

    public void resetTabsMaximumScrolled() {
        this.tabsMaximumScrolled = -1.0;
    }

    @Override
    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        if (this.isShowingTabs()) {
            this.tabsScroller.updatePosition(delta * 3.0f);
            int xx = 24 - (int)this.tabsScroller.scrollAmount;
            for (ClothConfigTabButton tabButton : this.tabButtons) {
                tabButton.field_230690_l_ = xx;
                xx += tabButton.func_230998_h_() + 2;
            }
            this.buttonLeftTab.field_230693_o_ = this.tabsScroller.scrollAmount > 0.0;
            boolean bl = this.buttonRightTab.field_230693_o_ = this.tabsScroller.scrollAmount < this.getTabsMaximumScrolled() - (double)this.field_230708_k_ + 40.0;
        }
        if (this.isTransparentBackground()) {
            this.func_238468_a_(matrices, 0, 0, this.field_230708_k_, this.field_230709_l_, -1072689136, -804253680);
        } else {
            this.func_231165_f_(0);
        }
        this.listWidget.func_230430_a_(matrices, mouseX, mouseY, delta);
        ScissorsHandler.INSTANCE.scissor(new Rectangle(this.listWidget.left, this.listWidget.top, this.listWidget.width, this.listWidget.bottom - this.listWidget.top));
        for (Object child : this.listWidget.func_231039_at__()) {
            ((AbstractConfigEntry)child).lateRender(matrices, mouseX, mouseY, delta);
        }
        ScissorsHandler.INSTANCE.removeLastScissor();
        if (this.isShowingTabs()) {
            ClothConfigScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)18, (int)-1);
            Rectangle onlyInnerTabBounds = new Rectangle(this.tabsBounds.x + 20, this.tabsBounds.y, this.tabsBounds.width - 40, this.tabsBounds.height);
            ScissorsHandler.INSTANCE.scissor(onlyInnerTabBounds);
            if (this.isTransparentBackground()) {
                this.func_238468_a_(matrices, onlyInnerTabBounds.x, onlyInnerTabBounds.y, onlyInnerTabBounds.getMaxX(), onlyInnerTabBounds.getMaxY(), 0x68000000, 0x68000000);
            } else {
                this.overlayBackground(matrices, onlyInnerTabBounds, 32, 32, 32, 255, 255);
            }
            this.tabButtons.forEach(widget -> widget.func_230430_a_(matrices, mouseX, mouseY, delta));
            this.drawTabsShades(matrices, 0, this.isTransparentBackground() ? 120 : 255);
            ScissorsHandler.INSTANCE.removeLastScissor();
            this.buttonLeftTab.func_230430_a_(matrices, mouseX, mouseY, delta);
            this.buttonRightTab.func_230430_a_(matrices, mouseX, mouseY, delta);
        } else {
            ClothConfigScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)12, (int)-1);
        }
        if (this.isEditable()) {
            ArrayList errors = Lists.newArrayList();
            for (List entries : Lists.newArrayList(this.categorizedEntries.values())) {
                for (AbstractConfigEntry entry : entries) {
                    if (!entry.getConfigError().isPresent()) continue;
                    errors.add(entry.getConfigError().get());
                }
            }
            if (errors.size() > 0) {
                this.field_230706_i_.func_110434_K().func_110577_a(CONFIG_TEX);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                String text = "\u00a7c" + (errors.size() == 1 ? ((ITextComponent)errors.get(0)).func_230531_f_().getString() : I18n.func_135052_a((String)"text.cloth-config.multi_error", (Object[])new Object[0]));
                if (this.isTransparentBackground()) {
                    int stringWidth = this.field_230706_i_.field_71466_p.func_78256_a(text);
                    Objects.requireNonNull(this.field_230706_i_.field_71466_p);
                    this.func_238468_a_(matrices, 8, 9, 20 + stringWidth, 14 + 9, 0x68000000, 0x68000000);
                }
                this.func_238474_b_(matrices, 10, 10, 0, 54, 3, 11);
                ClothConfigScreen.func_238476_c_((MatrixStack)matrices, (FontRenderer)this.field_230706_i_.field_71466_p, (String)text, (int)18, (int)12, (int)-1);
                if (errors.size() > 1) {
                    int stringWidth = this.field_230706_i_.field_71466_p.func_78256_a(text);
                    if (mouseX >= 10 && mouseY >= 10 && mouseX <= 18 + stringWidth) {
                        Objects.requireNonNull(this.field_230706_i_.field_71466_p);
                        if (mouseY <= 14 + 9) {
                            this.addTooltip(Tooltip.of(new Point(mouseX, mouseY), errors.toArray(new ITextComponent[0])));
                        }
                    }
                }
            }
        } else if (!this.isEditable()) {
            this.field_230706_i_.func_110434_K().func_110577_a(CONFIG_TEX);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            String text = "\u00a7c" + I18n.func_135052_a((String)"text.cloth-config.not_editable", (Object[])new Object[0]);
            if (this.isTransparentBackground()) {
                int stringWidth = this.field_230706_i_.field_71466_p.func_78256_a(text);
                Objects.requireNonNull(this.field_230706_i_.field_71466_p);
                this.func_238468_a_(matrices, 8, 9, 20 + stringWidth, 14 + 9, 0x68000000, 0x68000000);
            }
            this.func_238474_b_(matrices, 10, 10, 0, 54, 3, 11);
            ClothConfigScreen.func_238476_c_((MatrixStack)matrices, (FontRenderer)this.field_230706_i_.field_71466_p, (String)text, (int)18, (int)12, (int)-1);
        }
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void queueTooltip(QueuedTooltip queuedTooltip) {
        super.addTooltip(queuedTooltip);
    }

    private void drawTabsShades(MatrixStack matrices, int lightColor, int darkColor) {
        this.drawTabsShades(matrices.func_227866_c_().func_227870_a_(), lightColor, darkColor);
    }

    private void drawTabsShades(Matrix4f matrix, int lightColor, int darkColor) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
        RenderSystem.disableAlphaTest();
        RenderSystem.shadeModel((int)7425);
        RenderSystem.disableTexture();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_227888_a_(matrix, (float)(this.tabsBounds.getMinX() + 20), (float)(this.tabsBounds.getMinY() + 4), 0.0f).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, lightColor).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(this.tabsBounds.getMaxX() - 20), (float)(this.tabsBounds.getMinY() + 4), 0.0f).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, lightColor).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(this.tabsBounds.getMaxX() - 20), (float)this.tabsBounds.getMinY(), 0.0f).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, darkColor).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(this.tabsBounds.getMinX() + 20), (float)this.tabsBounds.getMinY(), 0.0f).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, darkColor).func_181675_d();
        tessellator.func_78381_a();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_227888_a_(matrix, (float)(this.tabsBounds.getMinX() + 20), (float)this.tabsBounds.getMaxY(), 0.0f).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, darkColor).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(this.tabsBounds.getMaxX() - 20), (float)this.tabsBounds.getMaxY(), 0.0f).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, darkColor).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(this.tabsBounds.getMaxX() - 20), (float)(this.tabsBounds.getMaxY() - 4), 0.0f).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, lightColor).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(this.tabsBounds.getMinX() + 20), (float)(this.tabsBounds.getMaxY() - 4), 0.0f).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, lightColor).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
    }

    @Override
    public void save() {
        super.save();
    }

    @Override
    public boolean isEditable() {
        return super.isEditable();
    }

    public static class ListWidget<R extends DynamicElementListWidget.ElementEntry<R>>
    extends DynamicElementListWidget<R> {
        private final AbstractConfigScreen screen;
        private boolean hasCurrent;
        private double currentX;
        private double currentY;
        private double currentWidth;
        private double currentHeight;
        public Rectangle target;
        public Rectangle thisTimeTarget;
        public long lastTouch;
        public long start;
        public long duration;

        public ListWidget(AbstractConfigScreen screen, Minecraft client, int width, int height, int top, int bottom, ResourceLocation backgroundLocation) {
            super(client, width, height, top, bottom, backgroundLocation);
            this.setRenderSelection(false);
            this.screen = screen;
        }

        @Override
        public int getItemWidth() {
            return this.width - 80;
        }

        @Override
        protected int getScrollbarPosition() {
            return this.left + this.width - 36;
        }

        @Override
        protected void renderItem(MatrixStack matrices, R item, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            if (item instanceof AbstractConfigEntry) {
                ((AbstractConfigEntry)item).updateSelected(this.getFocused() == item);
            }
            super.renderItem(matrices, item, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        }

        @Override
        protected void renderList(MatrixStack matrices, int startX, int startY, int int_3, int int_4, float delta) {
            long timePast;
            this.thisTimeTarget = null;
            if (this.hasCurrent) {
                timePast = System.currentTimeMillis() - this.lastTouch;
                int alpha = timePast <= 200L ? 255 : MathHelper.func_76143_f((double)(255.0 - (double)(Math.min((float)(timePast - 200L), 500.0f) / 500.0f) * 255.0));
                alpha = alpha * 36 / 255 << 24;
                this.fillGradient(matrices, this.currentX, this.currentY, this.currentX + this.currentWidth, this.currentY + this.currentHeight, 0xFFFFFF | alpha, 0xFFFFFF | alpha);
            }
            super.renderList(matrices, startX, startY, int_3, int_4, delta);
            if (this.thisTimeTarget != null && this.func_231047_b_(int_3, int_4)) {
                this.lastTouch = System.currentTimeMillis();
            }
            if (this.thisTimeTarget != null && !this.thisTimeTarget.equals(this.target)) {
                if (!this.hasCurrent) {
                    this.currentX = this.thisTimeTarget.x;
                    this.currentY = this.thisTimeTarget.y;
                    this.currentWidth = this.thisTimeTarget.width;
                    this.currentHeight = this.thisTimeTarget.height;
                    this.hasCurrent = true;
                }
                this.target = this.thisTimeTarget.clone();
                this.start = this.lastTouch;
                this.duration = 40L;
            } else if (this.hasCurrent && this.target != null) {
                timePast = System.currentTimeMillis() - this.start;
                this.currentX = (int)ScrollingContainer.ease(this.currentX, this.target.x, Math.min((double)timePast / (double)this.duration * (double)delta * 3.0, 1.0), EasingMethod.EasingMethodImpl.LINEAR);
                this.currentY = (int)ScrollingContainer.ease(this.currentY, this.target.y, Math.min((double)timePast / (double)this.duration * (double)delta * 3.0, 1.0), EasingMethod.EasingMethodImpl.LINEAR);
                this.currentWidth = (int)ScrollingContainer.ease(this.currentWidth, this.target.width, Math.min((double)timePast / (double)this.duration * (double)delta * 3.0, 1.0), EasingMethod.EasingMethodImpl.LINEAR);
                this.currentHeight = (int)ScrollingContainer.ease(this.currentHeight, this.target.height, Math.min((double)timePast / (double)this.duration * (double)delta * 3.0, 1.0), EasingMethod.EasingMethodImpl.LINEAR);
            }
        }

        protected void fillGradient(MatrixStack matrices, double xStart, double yStart, double xEnd, double yEnd, int colorStart, int colorEnd) {
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.disableAlphaTest();
            RenderSystem.defaultBlendFunc();
            RenderSystem.shadeModel((int)7425);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferBuilder = tessellator.func_178180_c();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            ListWidget.fillGradient(matrices.func_227866_c_().func_227870_a_(), bufferBuilder, xStart, yStart, xEnd, yEnd, this.func_230927_p_(), colorStart, colorEnd);
            tessellator.func_78381_a();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableTexture();
        }

        protected static void fillGradient(Matrix4f matrix4f, BufferBuilder bufferBuilder, double xStart, double yStart, double xEnd, double yEnd, int i, int j, int k) {
            float f = (float)(j >> 24 & 0xFF) / 255.0f;
            float g = (float)(j >> 16 & 0xFF) / 255.0f;
            float h = (float)(j >> 8 & 0xFF) / 255.0f;
            float l = (float)(j & 0xFF) / 255.0f;
            float m = (float)(k >> 24 & 0xFF) / 255.0f;
            float n = (float)(k >> 16 & 0xFF) / 255.0f;
            float o = (float)(k >> 8 & 0xFF) / 255.0f;
            float p = (float)(k & 0xFF) / 255.0f;
            bufferBuilder.func_227888_a_(matrix4f, (float)xEnd, (float)yStart, (float)i).func_227885_a_(g, h, l, f).func_181675_d();
            bufferBuilder.func_227888_a_(matrix4f, (float)xStart, (float)yStart, (float)i).func_227885_a_(g, h, l, f).func_181675_d();
            bufferBuilder.func_227888_a_(matrix4f, (float)xStart, (float)yEnd, (float)i).func_227885_a_(n, o, p, m).func_181675_d();
            bufferBuilder.func_227888_a_(matrix4f, (float)xEnd, (float)yEnd, (float)i).func_227885_a_(n, o, p, m).func_181675_d();
        }

        @Override
        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            this.updateScrollingState(mouseX, mouseY, button);
            if (!this.func_231047_b_(mouseX, mouseY)) {
                return false;
            }
            for (DynamicElementListWidget.ElementEntry entry : this.func_231039_at__()) {
                if (!entry.func_231044_a_(mouseX, mouseY, button)) continue;
                this.func_231035_a_(entry);
                this.func_231037_b__(true);
                return true;
            }
            if (button == 0) {
                this.clickedHeader((int)(mouseX - (double)(this.left + this.width / 2 - this.getItemWidth() / 2)), (int)(mouseY - (double)this.top) + (int)this.getScroll() - 4);
                return true;
            }
            return this.scrolling;
        }

        @Override
        protected void renderBackBackground(MatrixStack matrices, BufferBuilder buffer, Tessellator tessellator) {
            if (!this.screen.isTransparentBackground()) {
                super.renderBackBackground(matrices, buffer, tessellator);
            } else {
                this.func_238468_a_(matrices, this.left, this.top, this.right, this.bottom, 0x68000000, 0x68000000);
            }
        }

        @Override
        protected void renderHoleBackground(MatrixStack matrices, int y1, int y2, int alpha1, int alpha2) {
            if (!this.screen.isTransparentBackground()) {
                super.renderHoleBackground(matrices, y1, y2, alpha1, alpha2);
            }
        }
    }
}

