/*
 * Decompiled with CFR 0.152.
 */
package azmalent.cuneiform.lib.compat;

import azmalent.cuneiform.Cuneiform;
import azmalent.cuneiform.lib.compat.BasicModDummy;
import azmalent.cuneiform.lib.compat.IModIntegration;
import azmalent.cuneiform.lib.compat.ModProxy;
import azmalent.cuneiform.lib.compat.ModProxyDummy;
import azmalent.cuneiform.lib.compat.ModProxyImpl;
import azmalent.cuneiform.lib.util.ReflectionUtil;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;

public class ModCompatUtil {
    public static void initModProxies(Class modCompatClass, String modid) {
        Object instance = ReflectionUtil.getSingletonInstance(modCompatClass);
        Map<String, Field> proxyFields = ModCompatUtil.findProxyFields(modCompatClass);
        Map<String, Class> dummies = ModCompatUtil.getDummies(modid);
        for (Map.Entry<String, Field> proxyField : proxyFields.entrySet()) {
            String targetModid = proxyField.getKey();
            Field field = proxyField.getValue();
            try {
                Object proxy = ModCompatUtil.createProxy(modid, targetModid, dummies.get(targetModid), field.getType());
                field.set(instance, proxy);
            }
            catch (Exception e) {
                Cuneiform.LOGGER.error(String.format("Failed to instantiate proxy for mod %s!", targetModid));
                Cuneiform.LOGGER.catching((Throwable)e);
            }
        }
    }

    private static <TMod> Map<String, Field> findProxyFields(Class<TMod> clazz) {
        HashMap proxies = Maps.newHashMap();
        for (Field field : clazz.getFields()) {
            ModProxy proxyAnnotation = field.getAnnotation(ModProxy.class);
            if (proxyAnnotation == null) continue;
            String modid = proxyAnnotation.value();
            proxies.put(modid, field);
        }
        return proxies;
    }

    private static <TAnnotation extends Annotation> Map<String, Class> getDummies(String modid) {
        List<ModFileScanData.AnnotationData> annotationData = ReflectionUtil.getAnnotationDataFromMod(modid, ModProxyDummy.class);
        HashMap result = Maps.newHashMap();
        for (ModFileScanData.AnnotationData data : annotationData) {
            String targetModid = (String)data.getAnnotationData().get("value");
            Class<?> clazz = ReflectionUtil.tryGetClass(data.getClassType().getClassName());
            result.put(targetModid, clazz);
        }
        return result;
    }

    private static Class getImpl(String thisModid, String targetModid) {
        List<ModFileScanData.AnnotationData> annotationData = ReflectionUtil.getAnnotationDataFromMod(thisModid, ModProxyImpl.class);
        for (ModFileScanData.AnnotationData data : annotationData) {
            String modid = (String)data.getAnnotationData().get("value");
            if (!modid.equals(targetModid)) continue;
            return ReflectionUtil.tryGetClass(data.getClassType().getClassName());
        }
        return null;
    }

    private static Object createProxy(String thisModid, String targetModid, Class dummyClass, Class fieldType) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (dummyClass == null) {
            if (fieldType != IModIntegration.class) {
                throw new ClassNotFoundException("Missing dummy proxy for " + targetModid);
            }
            dummyClass = BasicModDummy.class;
        }
        try {
            if (ModList.get().isLoaded(targetModid)) {
                Class implClass = ModCompatUtil.getImpl(thisModid, targetModid);
                if (implClass == null) {
                    throw new ClassNotFoundException("Failed to instantiate  " + targetModid);
                }
                return implClass.asSubclass(fieldType).newInstance();
            }
            return dummyClass.asSubclass(fieldType).newInstance();
        }
        catch (ReflectiveOperationException e) {
            Cuneiform.LOGGER.error(String.format("Failed to instantiate proxy for mod %s!", targetModid));
            throw e;
        }
    }
}

