/*
 * Decompiled with CFR 0.152.
 */
package azmalent.cuneiform.lib.config.options.lazy;

import azmalent.cuneiform.lib.config.options.AbstractConfigOption;
import azmalent.cuneiform.lib.config.options.lazy.ILazyOption;
import java.lang.reflect.Field;
import java.util.function.Function;
import net.minecraftforge.common.ForgeConfigSpec;

public class LazyOption<T>
extends AbstractConfigOption<T, String>
implements ILazyOption {
    protected ForgeConfigSpec.ConfigValue<String> stringValue;
    protected final String defaultValue;
    protected final Function<String, T> constructor;
    protected T value;
    protected boolean initialized = false;

    protected LazyOption(String defaultValue) {
        this.defaultValue = defaultValue;
        this.constructor = null;
    }

    public LazyOption(String defaultValue, Function<String, T> constructor) {
        this.defaultValue = defaultValue;
        this.constructor = constructor;
    }

    @Override
    public T get() {
        if (!this.initialized) {
            this.initValue();
        }
        return this.value;
    }

    protected T getDefault() {
        String defaultString = (String)this.stringValue.get();
        return this.constructor.apply(defaultString);
    }

    @Override
    public void set(String newValue) {
        this.stringValue.set((Object)newValue);
        this.invalidate();
    }

    @Override
    public void init(ForgeConfigSpec.Builder builder, Field field) {
        this.stringValue = this.addComment(builder, field, "Default: " + this.defaultValue).define(this.getName(field), (Object)this.defaultValue);
    }

    @Override
    public void invalidate() {
        this.value = null;
        this.initialized = false;
    }

    @Override
    public void initValue() {
        this.initialized = true;
        String stringValue = (String)this.stringValue.get();
        this.value = this.constructor.apply(stringValue);
        if (this.value == null) {
            this.value = this.getDefault();
        }
    }
}

