/*
 * Decompiled with CFR 0.152.
 */
package azmalent.cuneiform.lib.registry;

import azmalent.cuneiform.common.item.CeilingOrFloorItem;
import azmalent.cuneiform.lib.config.options.BooleanOption;
import azmalent.cuneiform.lib.registry.BlockRegistryHelper;
import azmalent.cuneiform.lib.registry.BlockRenderType;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TallBlockItem;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;

public class BlockEntry
implements IItemProvider {
    public final RegistryObject<Block> block;
    public final RegistryObject<Item> item;

    private BlockEntry() {
        this.block = null;
        this.item = null;
    }

    private BlockEntry(DeferredRegister<Block> blockRegistry, String id, Supplier<? extends Block> constructor) {
        this.block = blockRegistry.register(id, constructor);
        this.item = null;
    }

    private BlockEntry(DeferredRegister<Block> blockRegistry, DeferredRegister<Item> itemRegistry, String id, Supplier<? extends Block> constructor, ItemGroup creativeTab) {
        this(blockRegistry, itemRegistry, id, constructor, (Block block) -> new BlockItem(block, new Item.Properties().func_200916_a(creativeTab)));
    }

    private BlockEntry(DeferredRegister<Block> blockRegistry, DeferredRegister<Item> itemRegistry, String id, Supplier<? extends Block> constructor, Function<Block, ? extends BlockItem> blockItemConstructor) {
        this.block = blockRegistry.register(id, constructor);
        this.item = itemRegistry.register(id, () -> (BlockItem)blockItemConstructor.apply((Block)this.block.get()));
    }

    public boolean hasItemForm() {
        return this.item != null;
    }

    public Block getBlock() {
        return (Block)this.block.get();
    }

    public BlockState getDefaultState() {
        return ((Block)this.block.get()).func_176223_P();
    }

    public ItemStack makeStack() {
        return this.makeStack(1);
    }

    public ItemStack makeStack(int amount) {
        return new ItemStack((IItemProvider)this.func_199767_j(), amount);
    }

    @Deprecated
    public Item getItem() {
        return this.func_199767_j();
    }

    @Nonnull
    public Item func_199767_j() {
        if (this.item == null) {
            throw new NullPointerException(String.format("The block %s doesn't have an item form!", this.getBlock().getRegistryName()));
        }
        return (Item)this.item.get();
    }

    public static class Builder {
        protected String id;
        protected Supplier<? extends Block> constructor;
        protected Function<Block, ? extends BlockItem> blockItemConstructor;
        protected Consumer<BlockEntry> postInitCallback;
        protected boolean noItemForm = false;
        protected BlockRenderType renderType = BlockRenderType.SOLID;
        protected BlockRegistryHelper helper;

        public Builder(BlockRegistryHelper helper, String id, Supplier<? extends Block> constructor) {
            this.helper = helper;
            this.id = id;
            this.constructor = constructor;
        }

        public Builder(BlockRegistryHelper helper, String id, Function<AbstractBlock.Properties, ? extends Block> constructor, AbstractBlock.Properties properties) {
            this(helper, id, () -> (Block)constructor.apply(properties));
        }

        public Builder(BlockRegistryHelper helper, String id, AbstractBlock.Properties properties) {
            this(helper, id, () -> new Block(properties));
        }

        public BlockEntry build() {
            BlockEntry entry = this.noItemForm ? new BlockEntry(this.helper.blocks, this.id, this.constructor) : (this.blockItemConstructor != null ? new BlockEntry(this.helper.blocks, this.helper.items, this.id, this.constructor, this.blockItemConstructor) : new BlockEntry(this.helper.blocks, this.helper.items, this.id, this.constructor, this.helper.defaultTab));
            if (this.postInitCallback != null) {
                this.postInitCallback.accept(entry);
            }
            if (this.renderType != BlockRenderType.SOLID) {
                this.helper.setRenderType(entry, this.renderType);
            }
            return entry;
        }

        @Deprecated
        public final Optional<BlockEntry> buildIf(boolean condition) {
            return condition ? Optional.of(this.build()) : Optional.empty();
        }

        @Deprecated
        public final Optional<BlockEntry> buildIf(BooleanOption condition) {
            return this.buildIf(condition.get());
        }

        public Builder withBlockItem(Function<Block, ? extends BlockItem> blockItemConstructor) {
            this.blockItemConstructor = blockItemConstructor;
            return this;
        }

        public Builder withBlockItem(BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemConstructor, Item.Properties properties) {
            this.blockItemConstructor = block -> (BlockItem)blockItemConstructor.apply((Block)block, properties);
            return this;
        }

        public Builder withBlockItem(BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemConstructor, ItemGroup group) {
            return this.withBlockItem(blockItemConstructor, new Item.Properties().func_200916_a(group));
        }

        public Builder withTallBlockItem(Item.Properties properties) {
            return this.withBlockItem(TallBlockItem::new, properties);
        }

        public Builder withTallBlockItem(ItemGroup group) {
            return this.withBlockItem(TallBlockItem::new, group);
        }

        public Builder withWallOrFloorItem(BlockEntry wallBlock, Item.Properties properties) {
            return this.withBlockItem(block -> new WallOrFloorItem(wallBlock.getBlock(), block, properties));
        }

        public Builder withWallOrFloorItem(BlockEntry wallBlock, ItemGroup group) {
            return this.withWallOrFloorItem(wallBlock, new Item.Properties().func_200916_a(group));
        }

        public Builder withCeilingOrFloorItem(BlockEntry floorBlock, Item.Properties properties) {
            return this.withBlockItem(block -> new CeilingOrFloorItem(floorBlock.getBlock(), (Block)block, properties));
        }

        public Builder withCeilingOrFloorItem(BlockEntry floorBlock, ItemGroup group) {
            return this.withCeilingOrFloorItem(floorBlock, new Item.Properties().func_200916_a(group));
        }

        @Deprecated
        public Builder withBlockItemProperties(Item.Properties properties) {
            return this.withItemProperties(properties);
        }

        public Builder withItemProperties(Item.Properties properties) {
            return this.withBlockItem(BlockItem::new, properties);
        }

        public Builder withItemGroup(ItemGroup group) {
            return this.withItemProperties(new Item.Properties().func_200916_a(group));
        }

        public Builder withoutItemForm() {
            this.noItemForm = true;
            return this;
        }

        public Builder withRenderType(BlockRenderType type) {
            this.renderType = type;
            return this;
        }

        public Builder cutoutRender() {
            return this.withRenderType(BlockRenderType.CUTOUT);
        }

        public Builder cutoutMippedRender() {
            return this.withRenderType(BlockRenderType.CUTOUT_MIPPED);
        }

        public Builder transculentRender() {
            return this.withRenderType(BlockRenderType.TRANSCULENT);
        }

        public Builder onInit(Consumer<BlockEntry> callback) {
            this.postInitCallback = callback;
            return this;
        }
    }
}

