/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.inventory;

import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.event.CurioEquipEvent;
import top.theillusivec4.curios.api.event.CurioUnequipEvent;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CurioSlot
extends SlotItemHandler {
    private final String identifier;
    private final PlayerEntity player;
    private final SlotContext slotContext;
    private final NonNullList<Boolean> renderStatuses;

    public CurioSlot(PlayerEntity player, IDynamicStackHandler handler, int index, String identifier, int xPosition, int yPosition, NonNullList<Boolean> renders) {
        super((IItemHandler)handler, index, xPosition, yPosition);
        this.identifier = identifier;
        this.renderStatuses = renders;
        this.player = player;
        this.slotContext = new SlotContext(identifier, (LivingEntity)player, index);
        this.setBackground(PlayerContainer.field_226615_c_, player.func_130014_f_().func_201670_d() ? CuriosApi.getIconHelper().getIcon(identifier) : new ResourceLocation("curios", "item/empty_curio_slot"));
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean getRenderStatus() {
        return (Boolean)this.renderStatuses.get(this.getSlotIndex());
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getSlotName() {
        return I18n.func_135052_a((String)("curios.identifier." + this.identifier), (Object[])new Object[0]);
    }

    public boolean func_75214_a(@Nonnull ItemStack stack) {
        CurioEquipEvent equipEvent = new CurioEquipEvent(stack, this.slotContext);
        MinecraftForge.EVENT_BUS.post((Event)equipEvent);
        Event.Result result = equipEvent.getResult();
        if (result == Event.Result.DENY) {
            return false;
        }
        return result == Event.Result.ALLOW || CuriosApi.getCuriosHelper().isStackValid(this.slotContext, stack) && CuriosApi.getCuriosHelper().getCurio(stack).map(curio -> curio.canEquip(this.identifier, (LivingEntity)this.player)).orElse(true) != false && super.func_75214_a(stack);
    }

    public boolean func_82869_a(PlayerEntity playerIn) {
        ItemStack stack = this.func_75211_c();
        CurioUnequipEvent unequipEvent = new CurioUnequipEvent(stack, this.slotContext);
        MinecraftForge.EVENT_BUS.post((Event)unequipEvent);
        Event.Result result = unequipEvent.getResult();
        if (result == Event.Result.DENY) {
            return false;
        }
        return result == Event.Result.ALLOW || (stack.func_190926_b() || playerIn.func_184812_l_() || !EnchantmentHelper.func_190938_b((ItemStack)stack)) && CuriosApi.getCuriosHelper().getCurio(stack).map(curio -> curio.canUnequip(this.identifier, (LivingEntity)playerIn)).orElse(true) != false && super.func_82869_a(playerIn);
    }
}

