/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.entities;

import com.naterbobber.darkerdepths.core.registries.DDItems;
import com.naterbobber.darkerdepths.core.registries.DDSoundEvents;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GlowshroomMonsterEntity
extends MonsterEntity {
    private int attackTick;

    public GlowshroomMonsterEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 20;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 45.0).func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233824_g_, 1.3).func_233815_a_(Attributes.field_233823_f_, 8.0).func_233815_a_(Attributes.field_233820_c_, 0.75);
    }

    public static boolean canSpawn(EntityType<? extends MobEntity> typeIn, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL && pos.func_177956_o() <= 40 && GlowshroomMonsterEntity.func_223315_a(typeIn, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, this.func_233637_b_(Attributes.field_233821_d_) + 0.2, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, this.func_233637_b_(Attributes.field_233821_d_)));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 0, false, false, entity -> !(entity instanceof CreeperEntity) && !(entity instanceof GlowshroomMonsterEntity) && !(entity instanceof BatEntity)));
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)DDSoundEvents.ENTITY_GLOWSHROOM_MONSTER_AMBIENT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)DDSoundEvents.ENTITY_GLOWSHROOM_MONSTER_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)DDSoundEvents.ENTITY_GLOWSHROOM_MONSTER_HURT.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_219648_fh, 0.15f, 0.8f);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTick > 0) {
            --this.attackTick;
        }
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
        ItemEntity itemEntity = this.func_199703_a((IItemProvider)DDItems.GLOWSHROOM_CAP.get());
        if (itemEntity != null) {
            itemEntity.func_174873_u();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTick = 10;
            this.func_184185_a(SoundEvents.field_219644_fd, 1.0f, 1.0f);
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackTimer() {
        return this.attackTick;
    }

    public boolean func_70652_k(Entity entityIn) {
        this.attackTick = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        float f = (float)this.func_233637_b_(Attributes.field_233823_f_);
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), f);
        this.func_184185_a(SoundEvents.field_219644_fd, 1.0f, 1.0f);
        return flag;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)DDItems.GLOWSHROOM_MONSTER_SPAWN_EGG.get());
    }
}

