/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.events;

import com.google.gson.JsonObject;
import com.naterbobber.darkerdepths.core.DarkerDepthsConfig;
import com.naterbobber.darkerdepths.core.registries.DDItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class RawOreLootModifier
extends LootModifier {
    public RawOreLootModifier(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (((Boolean)DarkerDepthsConfig.dropSilverRawOre.get()).booleanValue()) {
            Random random = new Random();
            ItemStack ctxTool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
            if (generatedLoot.size() == 0) {
                return generatedLoot;
            }
            ArrayList<ItemStack> returnable = this.checkLoot(generatedLoot);
            if (generatedLoot.get(0).func_77973_b() == returnable.get(0).func_77973_b() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)ctxTool) != 0) {
                return generatedLoot;
            }
            int enchantmentLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)ctxTool);
            ArrayList<ItemStack> rawOre = new ArrayList<ItemStack>();
            int size = generatedLoot.size();
            rawOre.add(new ItemStack((IItemProvider)returnable.get(0).func_77973_b(), size + random.nextInt(1 + enchantmentLevel)));
            return rawOre;
        }
        return generatedLoot;
    }

    private static ArrayList<ItemStack> getRawSilverOre() {
        ArrayList<ItemStack> returnable = new ArrayList<ItemStack>();
        returnable.add(new ItemStack((IItemProvider)DDItems.RAW_SILVER.get()));
        return returnable;
    }

    private ArrayList<ItemStack> checkLoot(List<ItemStack> generatedLoot) {
        Item rawOre = generatedLoot.get(0).func_77973_b();
        if (rawOre.getTags().contains(new ResourceLocation("forge", "ores/silver"))) {
            return RawOreLootModifier.getRawSilverOre();
        }
        return (ArrayList)generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<RawOreLootModifier> {
        public RawOreLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] ailootcondition) {
            return new RawOreLootModifier(ailootcondition);
        }

        public JsonObject write(RawOreLootModifier instance) {
            return new JsonObject();
        }
    }
}

