/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.math;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.naterbobber.darkerdepths.common.math.ConstantIntProvider;
import com.naterbobber.darkerdepths.common.math.IntProviderType;
import com.naterbobber.darkerdepths.common.math.ModRegistry;
import java.util.Random;
import java.util.function.Function;

public abstract class IntProvider {
    private static final Codec<Either<Integer, IntProvider>> INT_CODEC = Codec.either((Codec)Codec.INT, (Codec)ModRegistry.INT_PROVIDER_TYPE.dispatch(IntProvider::getType, IntProviderType::codec));
    public static final Codec<IntProvider> CODEC = INT_CODEC.xmap(either -> (IntProvider)either.map(ConstantIntProvider::create, provider -> provider), provider -> provider.getType() == IntProviderType.CONSTANT ? Either.left((Object)((ConstantIntProvider)provider).getValue()) : Either.right((Object)provider));

    public static Codec<IntProvider> createValidatingCodec(int min, int max) {
        Function<IntProvider, DataResult> function = provider -> {
            if (provider.getMin() < min) {
                return DataResult.error((String)("Value provider too low: " + min + " [" + provider.getMin() + "-" + provider.getMax() + "]"));
            }
            return provider.getMax() > max ? DataResult.error((String)("Value provider too high: " + max + " [" + provider.getMin() + "-" + provider.getMax() + "]")) : DataResult.success((Object)provider);
        };
        return CODEC.flatXmap(function, function);
    }

    public abstract int get(Random var1);

    public abstract int getMin();

    public abstract int getMax();

    public abstract IntProviderType<?> getType();
}

