/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.world.gen.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.IntegrityProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class CaveFossilFeature
extends Feature<NoFeatureConfig> {
    private static final ResourceLocation STRUCTURE_SPINE_01 = new ResourceLocation("fossil/spine_1");
    private static final ResourceLocation STRUCTURE_SPINE_02 = new ResourceLocation("fossil/spine_2");
    private static final ResourceLocation STRUCTURE_SPINE_03 = new ResourceLocation("fossil/spine_3");
    private static final ResourceLocation STRUCTURE_SPINE_04 = new ResourceLocation("fossil/spine_4");
    private static final ResourceLocation STRUCTURE_SPINE_01_COAL = new ResourceLocation("fossil/spine_1_coal");
    private static final ResourceLocation STRUCTURE_SPINE_02_COAL = new ResourceLocation("fossil/spine_2_coal");
    private static final ResourceLocation STRUCTURE_SPINE_03_COAL = new ResourceLocation("fossil/spine_3_coal");
    private static final ResourceLocation STRUCTURE_SPINE_04_COAL = new ResourceLocation("fossil/spine_4_coal");
    private static final ResourceLocation STRUCTURE_SKULL_01 = new ResourceLocation("fossil/skull_1");
    private static final ResourceLocation STRUCTURE_SKULL_02 = new ResourceLocation("fossil/skull_2");
    private static final ResourceLocation STRUCTURE_SKULL_03 = new ResourceLocation("fossil/skull_3");
    private static final ResourceLocation STRUCTURE_SKULL_04 = new ResourceLocation("fossil/skull_4");
    private static final ResourceLocation STRUCTURE_SKULL_01_COAL = new ResourceLocation("fossil/skull_1_coal");
    private static final ResourceLocation STRUCTURE_SKULL_02_COAL = new ResourceLocation("fossil/skull_2_coal");
    private static final ResourceLocation STRUCTURE_SKULL_03_COAL = new ResourceLocation("fossil/skull_3_coal");
    private static final ResourceLocation STRUCTURE_SKULL_04_COAL = new ResourceLocation("fossil/skull_4_coal");
    private static final ResourceLocation[] FOSSILS = new ResourceLocation[]{STRUCTURE_SPINE_01, STRUCTURE_SPINE_02, STRUCTURE_SPINE_03, STRUCTURE_SPINE_04, STRUCTURE_SKULL_01, STRUCTURE_SKULL_02, STRUCTURE_SKULL_03, STRUCTURE_SKULL_04};
    private static final ResourceLocation[] FOSSILS_COAL = new ResourceLocation[]{STRUCTURE_SPINE_01_COAL, STRUCTURE_SPINE_02_COAL, STRUCTURE_SPINE_03_COAL, STRUCTURE_SPINE_04_COAL, STRUCTURE_SKULL_01_COAL, STRUCTURE_SKULL_02_COAL, STRUCTURE_SKULL_03_COAL, STRUCTURE_SKULL_04_COAL};

    public CaveFossilFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (worldIn.func_175623_d(pos.func_177977_b()) || worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_150355_j) || worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_150353_l)) {
            return false;
        }
        Rotation rotation = Rotation.func_222466_a((Random)rand);
        int index = rand.nextInt(FOSSILS.length);
        TemplateManager templateManager = worldIn.func_201672_e().func_73046_m().func_240792_aT_();
        Template fossilsTemplate = templateManager.func_200220_a(FOSSILS[index]);
        Template coalFossilsTemplate = templateManager.func_200220_a(FOSSILS_COAL[index]);
        ChunkPos chunkPos = new ChunkPos(pos);
        MutableBoundingBox boundingBox = new MutableBoundingBox(chunkPos.func_180334_c(), 0, chunkPos.func_180333_d(), chunkPos.func_180332_e(), 40, chunkPos.func_180330_f());
        PlacementSettings placementSettings = new PlacementSettings().func_186220_a(rotation).func_186223_a(boundingBox).func_189950_a(rand).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
        BlockPos blockPos = fossilsTemplate.func_186257_a(rotation);
        int xChunk = rand.nextInt(16 - blockPos.func_177958_n());
        int zChunk = rand.nextInt(16 - blockPos.func_177952_p());
        int y = 40;
        for (int x = 0; x < blockPos.func_177958_n(); ++x) {
            for (int z = 0; z < blockPos.func_177952_p(); ++z) {
                y = Math.min(y, worldIn.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, pos.func_177958_n() + x + xChunk, pos.func_177952_p() + z + zChunk));
            }
        }
        int height = Math.max(y - 15 - rand.nextInt(10), 10);
        BlockPos fossilsPosition = fossilsTemplate.func_189961_a(pos.func_177982_a(xChunk, height, zChunk), Mirror.NONE, rotation);
        IntegrityProcessor integrityProcessor = new IntegrityProcessor(0.9f);
        placementSettings.func_215219_b().func_215222_a((StructureProcessor)integrityProcessor);
        fossilsTemplate.func_237146_a_((IServerWorld)worldIn, fossilsPosition, fossilsPosition, placementSettings, rand, 4);
        placementSettings.func_215220_b((StructureProcessor)integrityProcessor);
        IntegrityProcessor integrityProcessor1 = new IntegrityProcessor(0.1f);
        placementSettings.func_215219_b().func_215222_a((StructureProcessor)integrityProcessor1);
        coalFossilsTemplate.func_237146_a_((IServerWorld)worldIn, fossilsPosition, fossilsPosition, placementSettings, rand, 4);
        return true;
    }
}

