/*
 * Decompiled with CFR 0.152.
 */
package com.naterbobber.darkerdepths.common.world.gen.feature;

import com.mojang.serialization.Codec;
import com.naterbobber.darkerdepths.common.world.gen.feature.CavePillarConfig;
import com.naterbobber.darkerdepths.core.registries.DDBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class CrystalPeakFeature
extends Feature<CavePillarConfig> {
    public CrystalPeakFeature(Codec<CavePillarConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, CavePillarConfig configIn) {
        boolean isValidDirection;
        boolean bl = isValidDirection = configIn.pointingDirection == Direction.UP || configIn.pointingDirection == Direction.DOWN;
        if (isValidDirection) {
            if (CrystalPeakFeature.isEmptyOrWaterOrLava((IWorld)worldIn, pos)) {
                this.generateCrystalPillar((IWorld)worldIn, rand, pos, configIn);
                return true;
            }
            return false;
        }
        return false;
    }

    private void generateCrystalPillar(IWorld worldIn, Random rand, BlockPos pos, CavePillarConfig configIn) {
        this.generateMainCrystalPillar(worldIn, rand, pos, configIn);
        this.generateSideCrystalPillar(worldIn, rand, pos, Direction.NORTH, configIn);
        this.generateSideCrystalPillar(worldIn, rand, pos, Direction.SOUTH, configIn);
        this.generateSideCrystalPillar(worldIn, rand, pos, Direction.WEST, configIn);
        this.generateSideCrystalPillar(worldIn, rand, pos, Direction.EAST, configIn);
        this.generateCornerCrystalPillar(worldIn, rand, pos, Direction.NORTH, Direction.EAST, configIn);
        this.generateCornerCrystalPillar(worldIn, rand, pos, Direction.NORTH, Direction.WEST, configIn);
        this.generateCornerCrystalPillar(worldIn, rand, pos, Direction.SOUTH, Direction.EAST, configIn);
        this.generateCornerCrystalPillar(worldIn, rand, pos, Direction.SOUTH, Direction.WEST, configIn);
        this.generateCasing(worldIn, rand, pos, configIn);
    }

    private void generateCasing(IWorld worldIn, Random rand, BlockPos pos, CavePillarConfig configIn) {
        this.generateCrystalPillarCasing(worldIn, rand, pos, Direction.NORTH, Direction.EAST, 1, configIn);
        this.generateCrystalPillarCasing(worldIn, rand, pos, Direction.NORTH, Direction.EAST, 0, configIn);
        this.generateCrystalPillarCasing(worldIn, rand, pos, Direction.NORTH, Direction.EAST, -1, configIn);
        this.generateCrystalPillarCasing(worldIn, rand, pos, Direction.SOUTH, Direction.WEST, 1, configIn);
        this.generateCrystalPillarCasing(worldIn, rand, pos, Direction.SOUTH, Direction.WEST, 0, configIn);
        this.generateCrystalPillarCasing(worldIn, rand, pos, Direction.SOUTH, Direction.WEST, -1, configIn);
        this.generateCrystalPillarCasing(worldIn, rand, pos, Direction.EAST, Direction.SOUTH, 1, configIn);
        this.generateCrystalPillarCasing(worldIn, rand, pos, Direction.EAST, Direction.SOUTH, 0, configIn);
        this.generateCrystalPillarCasing(worldIn, rand, pos, Direction.EAST, Direction.SOUTH, -1, configIn);
        this.generateCrystalPillarCasing(worldIn, rand, pos, Direction.WEST, Direction.NORTH, 1, configIn);
        this.generateCrystalPillarCasing(worldIn, rand, pos, Direction.WEST, Direction.NORTH, 0, configIn);
        this.generateCrystalPillarCasing(worldIn, rand, pos, Direction.WEST, Direction.NORTH, -1, configIn);
    }

    private void generateMainCrystalPillar(IWorld worldIn, Random rand, BlockPos pos, CavePillarConfig configIn) {
        boolean isPointingUp = configIn.pointingDirection == Direction.UP;
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        for (int height = 0; height < MathHelper.func_76136_a((Random)rand, (int)8, (int)13); ++height) {
            blockPos.func_189533_g((Vector3i)pos).func_189534_c(configIn.pointingDirection, height);
            if ((!isPointingUp || CrystalPeakFeature.isEmptyOrWaterOrLava(worldIn, blockPos.func_177977_b())) && (isPointingUp || CrystalPeakFeature.isEmptyOrWaterOrLava(worldIn, blockPos.func_177984_a()))) continue;
            this.func_230367_a_((IWorldWriter)worldIn, (BlockPos)blockPos, configIn.pillarState);
        }
    }

    private void generateSideCrystalPillar(IWorld worldIn, Random rand, BlockPos pos, Direction side, CavePillarConfig configIn) {
        boolean isPointingUp = configIn.pointingDirection == Direction.UP;
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        for (int height = 0; height < MathHelper.func_76136_a((Random)rand, (int)5, (int)10); ++height) {
            blockPos.func_189533_g((Vector3i)pos).func_189534_c(configIn.pointingDirection, height).func_189536_c(side);
            if ((!isPointingUp || CrystalPeakFeature.isEmptyOrWaterOrLava(worldIn, blockPos.func_177977_b())) && (isPointingUp || CrystalPeakFeature.isEmptyOrWaterOrLava(worldIn, blockPos.func_177984_a()))) continue;
            this.func_230367_a_((IWorldWriter)worldIn, (BlockPos)blockPos, configIn.pillarState);
        }
    }

    private void generateCornerCrystalPillar(IWorld worldIn, Random rand, BlockPos pos, Direction xSide, Direction zSide, CavePillarConfig configIn) {
        boolean isPointingUp = configIn.pointingDirection == Direction.UP;
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        for (int height = 0; height < MathHelper.func_76136_a((Random)rand, (int)2, (int)4); ++height) {
            blockPos.func_189533_g((Vector3i)pos).func_189534_c(configIn.pointingDirection, height).func_189536_c(xSide).func_189536_c(zSide);
            if ((!isPointingUp || CrystalPeakFeature.isEmptyOrWaterOrLava(worldIn, blockPos.func_177977_b())) && (isPointingUp || CrystalPeakFeature.isEmptyOrWaterOrLava(worldIn, blockPos.func_177984_a()))) continue;
            this.func_230367_a_((IWorldWriter)worldIn, (BlockPos)blockPos, configIn.pillarState);
        }
    }

    private void generateCrystalPillarCasing(IWorld worldIn, Random rand, BlockPos pos, Direction xSide, Direction zSide, int zOffset, CavePillarConfig configIn) {
        boolean isPointingUp = configIn.pointingDirection == Direction.UP;
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        for (int height = 0; height < MathHelper.func_76136_a((Random)rand, (int)1, (int)3); ++height) {
            blockPos.func_189533_g((Vector3i)pos).func_189534_c(configIn.pointingDirection, height).func_189534_c(xSide, 2).func_189534_c(zSide, zOffset);
            if ((!isPointingUp || CrystalPeakFeature.isEmptyOrWaterOrLava(worldIn, blockPos.func_177977_b())) && (isPointingUp || CrystalPeakFeature.isEmptyOrWaterOrLava(worldIn, blockPos.func_177984_a()))) continue;
            this.func_230367_a_((IWorldWriter)worldIn, (BlockPos)blockPos, ((Block)DDBlocks.SHALE.get()).func_176223_P());
        }
    }

    public static boolean isEmptyOrWaterOrLava(IWorld worldIn, BlockPos pos) {
        return worldIn.func_175623_d(pos) || worldIn.func_180495_p(pos).func_203425_a(Blocks.field_150355_j) || worldIn.func_180495_p(pos).func_203425_a(Blocks.field_150353_l);
    }
}

