/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.decorative_blocks.blocks;

import com.lilypuree.decorative_blocks.datagen.types.IWoodType;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class SeatPostBlock
extends HorizontalBlock
implements IWaterLoggable {
    protected static final VoxelShape POST_SHAPE = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    protected static final VoxelShape JOIST_SHAPE_NS = Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)7.0, (double)12.0);
    protected static final VoxelShape JOIST_SHAPE_EW = Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)7.0, (double)16.0);
    protected static final VoxelShape SEAT_SHAPE_NS = VoxelShapes.func_197872_a((VoxelShape)POST_SHAPE, (VoxelShape)JOIST_SHAPE_NS);
    protected static final VoxelShape SEAT_SHAPE_EW = VoxelShapes.func_197872_a((VoxelShape)POST_SHAPE, (VoxelShape)JOIST_SHAPE_EW);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private IWoodType woodType;

    public SeatPostBlock(AbstractBlock.Properties properties, IWoodType woodType) {
        super(properties);
        this.woodType = woodType;
    }

    public IWoodType getWoodType() {
        return this.woodType;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction facing = (Direction)state.func_177229_b((Property)field_185512_D);
        switch (facing) {
            case NORTH: 
            case SOUTH: {
                return SEAT_SHAPE_NS;
            }
            case EAST: 
            case WEST: {
                return SEAT_SHAPE_EW;
            }
        }
        return SEAT_SHAPE_NS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState blockstate = world.func_180495_p(pos);
        FluidState ifluidstate = world.func_204610_c(pos);
        boolean waterloggedFlag = ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8;
        Direction facingDir = context.func_196000_l();
        Direction placementDir = facingDir == Direction.DOWN || facingDir == Direction.UP ? context.func_195992_f().func_176734_d() : facingDir.func_176746_e();
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)placementDir)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterloggedFlag));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return stateIn;
    }

    private boolean isInAttachablePos(IWorldReader worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_222432_lU) {
            return true;
        }
        return Block.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, WATERLOGGED});
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) == false;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean isFlammable(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return this.woodType.isFlammable();
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        if (this.woodType.isFlammable()) {
            return 20;
        }
        return super.getFlammability(state, world, pos, face);
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        if (this.woodType.isFlammable()) {
            return 5;
        }
        return super.getFireSpreadSpeed(state, world, pos, face);
    }
}

