/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.decorative_blocks.setup;

import com.lilypuree.decorative_blocks.fluid.ThatchFluid;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="decorative_blocks", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FogHandler {
    private static ITag.INamedTag<Fluid> fluidTag = FluidTags.func_206956_a((String)new ResourceLocation("decorative_blocks", "thatch").toString());

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        World world = event.getInfo().func_216773_g().func_130014_f_();
        BlockPos pos = event.getInfo().func_216780_d();
        FluidState state = world.func_204610_c(pos);
        FluidState actualState = event.getInfo().func_216771_k();
        if (FogHandler.isEntityInHay(state)) {
            RenderSystem.fogMode((GlStateManager.FogMode)GlStateManager.FogMode.EXP2);
            event.setDensity(2.0f);
            event.setCanceled(true);
        } else {
            if (actualState.func_206884_a((ITag)FluidTags.field_206960_b)) {
                event.setCanceled(false);
                return;
            }
            if (actualState.func_206888_e()) {
                event.setDensity(1.0E-5f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onFogColor(EntityViewRenderEvent.FogColors event) {
        World world = event.getInfo().func_216773_g().func_130014_f_();
        BlockPos pos = event.getInfo().func_216780_d();
        FluidState state = world.func_204610_c(pos);
        FluidState actualState = event.getInfo().func_216771_k();
        if (FogHandler.isEntityInHay(state)) {
            int color = ((ThatchFluid)state.func_206886_c()).getReferenceHolder().getColor();
            event.setRed((float)(color >> 16 & 0xFF) / 255.0f);
            event.setGreen((float)(color >> 8 & 0xFF) / 255.0f);
            event.setBlue((float)(color & 0xFF) / 255.0f);
        }
    }

    private static boolean isEntityInHay(FluidState fluidState) {
        return fluidTag.func_230235_a_((Object)fluidState.func_206886_c());
    }
}

