/*
 * Decompiled with CFR 0.152.
 */
package com.lilypuree.decorative_blocks_abnormals.setup;

import com.google.common.collect.ImmutableMap;
import com.lilypuree.decorative_blocks.blocks.BeamBlock;
import com.lilypuree.decorative_blocks.blocks.BonfireBlock;
import com.lilypuree.decorative_blocks.blocks.BrazierBlock;
import com.lilypuree.decorative_blocks.blocks.ChandelierBlock;
import com.lilypuree.decorative_blocks.blocks.PalisadeBlock;
import com.lilypuree.decorative_blocks.blocks.SeatBlock;
import com.lilypuree.decorative_blocks.blocks.SupportBlock;
import com.lilypuree.decorative_blocks.datagen.types.IWoodType;
import com.lilypuree.decorative_blocks.datagen.types.WoodDecorativeBlockTypes;
import com.lilypuree.decorative_blocks.items.BurnableBlockItem;
import com.lilypuree.decorative_blocks.setup.ModSetup;
import com.lilypuree.decorative_blocks_abnormals.block.EnderBrazierBlock;
import com.lilypuree.decorative_blocks_abnormals.block.EnderChandelierBlock;
import com.lilypuree.decorative_blocks_abnormals.datagen.type.CompatModWoodTypes;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class Registration {
    public static final DeferredRegister<Item> ITEMS;
    public static final DeferredRegister<Block> BLOCKS;
    public static final DeferredRegister<EntityType<?>> ENTITIES;
    public static final DeferredRegister<Fluid> FLUIDS;
    public static final ImmutableMap<String, RegistryObject<Block>> DECORATIVE_BLOCKS;
    public static final ImmutableMap<String, RegistryObject<Item>> DECORATIVE_ITEMBLOCKS;
    public static final Item.Properties dummyProperty;
    public static final Item.Properties modItemProperties;
    public static final RegistryObject<ChandelierBlock> ENDER_CHANDELIER;
    public static final RegistryObject<BrazierBlock> ENDER_BRAZIER;
    public static final RegistryObject<BonfireBlock> ENDER_BONFIRE;
    public static final RegistryObject<Item> ENDER_BRAZIER_ITEM;
    public static final RegistryObject<Item> ENDER_CHANDELIER_ITEM;

    public static void register() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(modEventBus);
        BLOCKS.register(modEventBus);
        ENTITIES.register(modEventBus);
        FLUIDS.register(modEventBus);
    }

    public static Block getWoodDecorativeBlock(IWoodType wood, WoodDecorativeBlockTypes decorativeBlockType) {
        String name = wood + "_" + decorativeBlockType;
        return (Block)((RegistryObject)DECORATIVE_BLOCKS.get((Object)name)).get();
    }

    public static RotatedPillarBlock getBeamBlock(IWoodType wood) {
        return (RotatedPillarBlock)Registration.getWoodDecorativeBlock(wood, WoodDecorativeBlockTypes.BEAM);
    }

    public static PalisadeBlock getPalisadeBlock(IWoodType wood) {
        return (PalisadeBlock)Registration.getWoodDecorativeBlock(wood, WoodDecorativeBlockTypes.PALISADE);
    }

    public static SeatBlock getSeatBlock(IWoodType wood) {
        return (SeatBlock)Registration.getWoodDecorativeBlock(wood, WoodDecorativeBlockTypes.SEAT);
    }

    public static SupportBlock getSupportBlock(IWoodType wood) {
        return (SupportBlock)Registration.getWoodDecorativeBlock(wood, WoodDecorativeBlockTypes.SUPPORT);
    }

    private static Block createDecorativeBlock(IWoodType wood, WoodDecorativeBlockTypes woodDecorativeBlockType) {
        AbstractBlock.Properties woodProperty = AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200943_b(1.2f).func_200947_a(SoundType.field_185848_a);
        AbstractBlock.Properties palisadeProperty = AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200948_a(2.0f, 4.0f).func_200947_a(SoundType.field_185848_a);
        switch (woodDecorativeBlockType) {
            default: {
                return new BeamBlock(woodProperty, wood);
            }
            case SEAT: {
                return new SeatBlock(woodProperty, wood);
            }
            case SUPPORT: {
                return new SupportBlock(woodProperty, wood);
            }
            case PALISADE: 
        }
        return new PalisadeBlock(palisadeProperty, wood);
    }

    static {
        String name;
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"decorative_blocks_abnormals");
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"decorative_blocks_abnormals");
        ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"decorative_blocks_abnormals");
        FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"decorative_blocks_abnormals");
        dummyProperty = new Item.Properties();
        modItemProperties = new Item.Properties().func_200916_a(ModSetup.ITEM_GROUP);
        ENDER_CHANDELIER = BLOCKS.register("ender_chandelier", () -> new EnderChandelierBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200943_b(0.3f).func_200947_a(SoundType.field_185848_a).func_226896_b_().func_235838_a_(state -> 15)));
        ENDER_BRAZIER = BLOCKS.register("ender_brazier", () -> new EnderBrazierBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(3.0f).func_200947_a(SoundType.field_185852_e).func_235838_a_(state -> (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? 15 : 0).func_226896_b_()));
        ENDER_BONFIRE = BLOCKS.register("ender_bonfire", () -> new BonfireBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151581_o, (MaterialColor)MaterialColor.field_151678_z).func_200942_a().func_200943_b(0.0f).func_200947_a(SoundType.field_185854_g).func_235838_a_(state -> 15).func_222380_e()));
        ENDER_BRAZIER_ITEM = ITEMS.register("ender_brazier", () -> new BlockItem((Block)ENDER_BRAZIER.get(), modItemProperties));
        ENDER_CHANDELIER_ITEM = ITEMS.register("ender_chandelier", () -> new BurnableBlockItem((Block)ENDER_CHANDELIER.get(), modItemProperties, 1600));
        ImmutableMap.Builder decorativeBlockBuilder = ImmutableMap.builder();
        ImmutableMap.Builder itemBuilder = ImmutableMap.builder();
        for (WoodDecorativeBlockTypes type : WoodDecorativeBlockTypes.values()) {
            for (IWoodType wood : CompatModWoodTypes.allWoodTypes()) {
                name = wood + "_" + type;
                decorativeBlockBuilder.put((Object)name, (Object)BLOCKS.register(name, () -> Registration.createDecorativeBlock(wood, type)));
            }
        }
        DECORATIVE_BLOCKS = decorativeBlockBuilder.build();
        for (WoodDecorativeBlockTypes type : WoodDecorativeBlockTypes.values()) {
            for (IWoodType wood : CompatModWoodTypes.allWoodTypes()) {
                name = wood + "_" + type;
                itemBuilder.put((Object)name, (Object)ITEMS.register(name, () -> new BurnableBlockItem((Block)((RegistryObject)DECORATIVE_BLOCKS.get((Object)name)).get(), wood.isAvailable() ? modItemProperties : dummyProperty, 300)));
            }
        }
        DECORATIVE_ITEMBLOCKS = itemBuilder.build();
    }
}

