/*
 * Decompiled with CFR 0.152.
 */
package co.eltrut.differentiate.core.registrator;

import co.eltrut.differentiate.common.block.DifferStairsBlock;
import co.eltrut.differentiate.common.block.VerticalSlabBlock;
import co.eltrut.differentiate.common.item.FuelBlockItem;
import co.eltrut.differentiate.common.repo.VariantBlocksRepo;
import co.eltrut.differentiate.core.registrator.AbstractHelper;
import co.eltrut.differentiate.core.registrator.ItemHelper;
import co.eltrut.differentiate.core.registrator.Registrator;
import co.eltrut.differentiate.core.util.GroupUtil;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.ArrayUtils;

public class BlockHelper
extends AbstractHelper<Block> {
    protected final ItemHelper itemRegister;

    public BlockHelper(Registrator parent) {
        super(parent, ForgeRegistries.BLOCKS);
        this.itemRegister = (ItemHelper)this.parent.getHelper(ForgeRegistries.ITEMS);
    }

    public RegistryObject<Block> createBlock(String name, Supplier<Block> block, Item.Properties props) {
        RegistryObject registeredBlock = this.registry.register(name, block);
        this.itemRegister.createItem(name, () -> new BlockItem((Block)registeredBlock.get(), props));
        return registeredBlock;
    }

    public RegistryObject<Block> createSimpleBlock(String name, Supplier<Block> block, ItemGroup group, String ... mods) {
        return this.createBlock(name, block, GroupUtil.getProps(group, mods));
    }

    public RegistryObject<Block> createFuelBlock(String name, Supplier<Block> block, Item.Properties props, int burnTime) {
        RegistryObject registeredBlock = this.registry.register(name, block);
        this.itemRegister.createItem(name, () -> new FuelBlockItem((Block)registeredBlock.get(), props, burnTime));
        return registeredBlock;
    }

    public RegistryObject<Block> createSimpleFuelBlock(String name, Supplier<Block> block, ItemGroup group, int burnTime, String ... mods) {
        return this.createFuelBlock(name, block, GroupUtil.getProps(group, mods), burnTime);
    }

    public VariantBlocksRepo createSimpleBlockWithVariants(String name, Supplier<Block> block, AbstractBlock.Properties props, ItemGroup group, String ... mods) {
        RegistryObject<Block> baseBlock = this.createSimpleBlock(name, block, group, mods);
        RegistryObject<Block> slabBlock = this.createSlabBlock(name, props, mods);
        RegistryObject<Block> stairsBlock = this.createStairsBlock(name, () -> new DifferStairsBlock(() -> ((Block)((Block)baseBlock.get())).func_176223_P(), props), mods);
        RegistryObject<Block> wallBlock = this.createWallBlock(name, props, mods);
        RegistryObject<Block> verticalSlabBlock = this.createVerticalSlabBlock(name, props, mods);
        return new VariantBlocksRepo.Builder().setBlock(baseBlock).setSlabBlock(slabBlock).setStairsBlock(stairsBlock).setWallBlock(wallBlock).setVerticalSlabBlock(verticalSlabBlock).build();
    }

    public VariantBlocksRepo createSimpleBlockWithVariants(String name, AbstractBlock.Properties props, ItemGroup group, String ... mods) {
        return this.createSimpleBlockWithVariants(name, () -> new Block(props), props, group, mods);
    }

    protected RegistryObject<Block> createSlabBlock(String name, AbstractBlock.Properties props, String ... mods) {
        String prefix = name.endsWith("bricks") || name.endsWith("tiles") ? name.replace("_bricks", "_brick").replace("_tiles", "_tile") : name;
        return this.createSimpleBlock(prefix + "_slab", () -> new SlabBlock(props), ItemGroup.field_78030_b, mods);
    }

    protected RegistryObject<Block> createStairsBlock(String name, Supplier<Block> block, String ... mods) {
        String prefix = name.endsWith("bricks") || name.endsWith("tiles") ? name.replace("_bricks", "_brick").replace("_tiles", "_tile") : name;
        return this.createSimpleBlock(prefix + "_stairs", block, ItemGroup.field_78030_b, mods);
    }

    protected RegistryObject<Block> createWallBlock(String name, AbstractBlock.Properties props, String ... mods) {
        String prefix = name.endsWith("bricks") || name.endsWith("tiles") ? name.replace("_bricks", "_brick").replace("_tiles", "_tile") : name;
        return this.createSimpleBlock(prefix + "_wall", () -> new WallBlock(props), ItemGroup.field_78031_c, mods);
    }

    protected RegistryObject<Block> createVerticalSlabBlock(String name, AbstractBlock.Properties props, String ... mods) {
        String prefix = name.endsWith("bricks") || name.endsWith("tiles") ? name.replace("_bricks", "_brick").replace("_tiles", "_tile") : name;
        String[] modsWithQuark = ArrayUtils.contains((Object[])mods, (Object)"quark") ? mods : (String[])ArrayUtils.add((Object[])mods, (Object)"quark");
        return this.createSimpleBlock(prefix + "_vertical_slab", () -> new VerticalSlabBlock(props), ItemGroup.field_78030_b, modsWithQuark);
    }
}

