/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.projectiles;

import com.infamous.dungeons_mobs.client.models.projectile.OrbModel;
import com.infamous.dungeons_mobs.entities.projectiles.AbstractOrbEntity;
import com.infamous.dungeons_mobs.entities.projectiles.LaserOrbEntity;
import com.infamous.dungeons_mobs.entities.projectiles.TridentFumeEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class OrbRenderer<T extends AbstractOrbEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation LASER_ORB_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/laser_orb.png");
    private static final ResourceLocation TRIDENT_FUME_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/trident_fume.png");
    protected final OrbModel<T> orbModel = new OrbModel();

    public OrbRenderer(EntityRendererManager rendererManager) {
        super(rendererManager);
    }

    public void render(T orb, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrixStackIn.func_227861_a_(0.0, -1.5, 0.0);
        ResourceLocation texture = this.getTextureLocation(orb);
        RenderType renderType = this.orbModel.func_228282_a_(texture);
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(renderType);
        this.orbModel.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
        super.func_225623_a_(orb, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(T orb) {
        if (orb instanceof LaserOrbEntity) {
            return LASER_ORB_TEXTURE;
        }
        if (orb instanceof TridentFumeEntity) {
            return TRIDENT_FUME_TEXTURE;
        }
        return LASER_ORB_TEXTURE;
    }
}

