/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.redstone;

import com.infamous.dungeons_mobs.client.models.redstone.RedstoneCubeModel;
import com.infamous.dungeons_mobs.entities.redstone.RedstoneCubeEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RedstoneCubeRenderer
extends MobRenderer<RedstoneCubeEntity, RedstoneCubeModel<RedstoneCubeEntity>> {
    private static final ResourceLocation REDSTONE_CUBE_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/redstone/redstone_cube.png");

    public RedstoneCubeRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new RedstoneCubeModel(0), 0.25f);
    }

    public void render(RedstoneCubeEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        this.field_76989_e = 0.5f;
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected void setupRotations(RedstoneCubeEntity redstoneCubeEntity, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_225621_a_((LivingEntity)redstoneCubeEntity, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        if (redstoneCubeEntity.isRolling()) {
            float rotationPerTick = 18.0f;
            float rotationAmount = ((float)redstoneCubeEntity.field_70173_aa + partialTicks) * -rotationPerTick;
            this.rollCube(matrixStackIn, rotationAmount);
        }
    }

    private void rollCube(MatrixStack matrixStackIn, float rotationAmount) {
        Vector3d offset = new Vector3d(0.0, 0.5, 0.0);
        matrixStackIn.func_227861_a_(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
        matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rotationAmount));
        matrixStackIn.func_227861_a_(-offset.field_72450_a, -offset.field_72448_b, -offset.field_72449_c);
    }

    protected void scale(RedstoneCubeEntity redstoneCubeEntity, MatrixStack matrixStackIn, float partialTickTime) {
        matrixStackIn.func_227861_a_(0.0, (double)0.001f, 0.0);
        float sizeScaleFactor = 2.0f;
        matrixStackIn.func_227862_a_(sizeScaleFactor, sizeScaleFactor, sizeScaleFactor);
    }

    public ResourceLocation getTextureLocation(RedstoneCubeEntity entity) {
        return REDSTONE_CUBE_TEXTURE;
    }
}

