/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.redstone;

import com.infamous.dungeons_mobs.client.models.redstone.RedstoneMineModel;
import com.infamous.dungeons_mobs.entities.redstone.RedstoneMineEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RedstoneMineRenderer<T extends RedstoneMineEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation REDSTONE_MINE_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/redstone/redstone_mine.png");
    protected final RedstoneMineModel<T> mineModel = new RedstoneMineModel();

    public RedstoneMineRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(T entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        ResourceLocation resourceLocation = this.getTextureLocation(entityIn);
        RenderType renderType = this.mineModel.func_228282_a_(resourceLocation);
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(renderType);
        this.mineModel.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.func_227865_b_();
        super.func_225623_a_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return REDSTONE_MINE_TEXTURE;
    }
}

