/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.util;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Potion;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class ParticleGenerator {
    private static final Minecraft MINECRAFT = Minecraft.func_71410_x();
    private static final Random RANDOM = new Random();

    @Nullable
    public static Particle addParticleInternal(IParticleData particleData, boolean guarantee, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        return ParticleGenerator.addParticleInternal(particleData, guarantee, false, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Nullable
    private static Particle addParticleInternal(IParticleData particleData, boolean guarantee, boolean minimize, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        ActiveRenderInfo activerenderinfo = ParticleGenerator.MINECRAFT.field_71460_t.func_215316_n();
        if (activerenderinfo.func_216786_h() && ParticleGenerator.MINECRAFT.field_71452_i != null) {
            ParticleStatus particlestatus = ParticleGenerator.calculateParticleLevel(minimize);
            if (guarantee) {
                return ParticleGenerator.MINECRAFT.field_71452_i.func_199280_a(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
            }
            if (activerenderinfo.func_216785_c().func_186679_c(x, y, z) > 1024.0) {
                return null;
            }
            return particlestatus == ParticleStatus.MINIMAL ? null : ParticleGenerator.MINECRAFT.field_71452_i.func_199280_a(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
        }
        return null;
    }

    private static ParticleStatus calculateParticleLevel(boolean minimize) {
        ParticleStatus particlestatus = ParticleGenerator.MINECRAFT.field_71474_y.field_74362_aa;
        if (minimize && particlestatus == ParticleStatus.MINIMAL && RANDOM.nextInt(10) == 0) {
            particlestatus = ParticleStatus.DECREASED;
        }
        if (particlestatus == ParticleStatus.DECREASED && RANDOM.nextInt(3) == 0) {
            particlestatus = ParticleStatus.MINIMAL;
        }
        return particlestatus;
    }

    public static void generatePotionImpact(World level, Potion potion, ItemStack itemStack, BlockPos blockPos, int color, SoundEvent soundEvent) {
        Vector3d bottomCenterOf = Vector3d.func_237492_c_((Vector3i)blockPos);
        for (int particleIndex = 0; particleIndex < 8; ++particleIndex) {
            level.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, itemStack), bottomCenterOf.field_72450_a, bottomCenterOf.field_72448_b, bottomCenterOf.field_72449_c, level.field_73012_v.nextGaussian() * 0.15, level.field_73012_v.nextDouble() * 0.2, level.field_73012_v.nextGaussian() * 0.15);
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color >> 0 & 0xFF) / 255.0f;
        BasicParticleType particleData = potion.func_185172_c() ? ParticleTypes.field_197590_A : ParticleTypes.field_197620_m;
        for (int internalParticleCount = 0; internalParticleCount < 100; ++internalParticleCount) {
            double power = level.field_73012_v.nextDouble() * 4.0;
            double d27 = level.field_73012_v.nextDouble() * Math.PI * 2.0;
            double d29 = Math.cos(d27) * power;
            double d5 = 0.01 + level.field_73012_v.nextDouble() * 0.5;
            double d7 = Math.sin(d27) * power;
            Particle particleInternal = ParticleGenerator.addParticleInternal((IParticleData)particleData, particleData.func_197554_b().func_197575_f(), bottomCenterOf.field_72450_a + d29 * 0.1, bottomCenterOf.field_72448_b + 0.3, bottomCenterOf.field_72449_c + d7 * 0.1, d29, d5, d7);
            if (particleInternal == null) continue;
            float colorStrength = 0.75f + level.field_73012_v.nextFloat() * 0.25f;
            particleInternal.func_70538_b(red * colorStrength, green * colorStrength, blue * colorStrength);
            particleInternal.func_70543_e((float)power);
        }
        level.func_184134_a((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, soundEvent, SoundCategory.NEUTRAL, 1.0f, level.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
    }
}

