/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.google.common.collect.Maps;
import com.infamous.dungeons_mobs.entities.illagers.ArmoredVindicatorEntity;
import com.infamous.dungeons_mobs.goals.switchcombat.ShieldAndMeleeAttackGoal;
import com.infamous.dungeons_mobs.interfaces.IShieldUser;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.raid.Raid;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class RoyalGuardEntity
extends ArmoredVindicatorEntity
implements IShieldUser {
    private int shieldCooldownTime;

    public RoyalGuardEntity(World world) {
        super((EntityType<? extends VindicatorEntity>)((EntityType)ModEntityTypes.ROYAL_GUARD.get()), world);
    }

    public RoyalGuardEntity(EntityType<? extends ArmoredVindicatorEntity> p_i50189_1_, World p_i50189_2_) {
        super(p_i50189_1_, p_i50189_2_);
        this.shieldCooldownTime = 0;
    }

    @Override
    public boolean func_213637_dY() {
        return false;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, (Goal)new GuardAndAttackGoal(this, 1.0, false));
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return ArmoredVindicatorEntity.setCustomAttributes().func_233815_a_(Attributes.field_233820_c_, 0.6);
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        if (ModList.get().isLoaded("dungeons_gear")) {
            Item MACE = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "mace"));
            Item ROYAL_GUARD_HELMET = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "royal_guard_helmet"));
            Item ROYAL_GUARD_CHESTPLATE = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "royal_guard_chestplate"));
            ItemStack mace = new ItemStack((IItemProvider)MACE);
            ItemStack royalGuardHelmet = new ItemStack((IItemProvider)ROYAL_GUARD_HELMET);
            ItemStack royalGuardChestplate = new ItemStack((IItemProvider)ROYAL_GUARD_CHESTPLATE);
            if (this.func_213663_ek() == null) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, mace);
            }
            this.func_184201_a(EquipmentSlotType.HEAD, royalGuardHelmet);
            this.func_184201_a(EquipmentSlotType.CHEST, royalGuardChestplate);
        } else if (this.func_213663_ek() == null) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151036_c));
            this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_151028_Y));
            this.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)Items.field_151030_Z));
        }
        this.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)ModItems.ROYAL_GUARD_SHIELD.get()));
    }

    @Override
    public void func_213660_a(int waveAmount, boolean b) {
        ItemStack mainhandWeapon = new ItemStack((IItemProvider)Items.field_151036_c);
        if (ModList.get().isLoaded("dungeons_gear")) {
            Item MACE = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "mace"));
            mainhandWeapon = new ItemStack((IItemProvider)MACE);
        }
        Raid raid = this.func_213663_ek();
        int enchantmentLevel = 1;
        if (raid != null && waveAmount > raid.func_221306_a(Difficulty.NORMAL)) {
            enchantmentLevel = 2;
        }
        boolean applyEnchant = false;
        if (raid != null) {
            boolean bl = applyEnchant = this.field_70146_Z.nextFloat() <= raid.func_221308_w();
        }
        if (applyEnchant) {
            HashMap enchantmentIntegerMap = Maps.newHashMap();
            enchantmentIntegerMap.put(Enchantments.field_185302_k, enchantmentLevel);
            EnchantmentHelper.func_82782_a((Map)enchantmentIntegerMap, (ItemStack)mainhandWeapon);
        }
        this.func_184201_a(EquipmentSlotType.MAINHAND, mainhandWeapon);
    }

    @Override
    public AbstractIllagerEntity.ArmPose func_193077_p() {
        AbstractIllagerEntity.ArmPose illagerArmPose = super.func_193077_p();
        if (illagerArmPose == AbstractIllagerEntity.ArmPose.CROSSED) {
            return AbstractIllagerEntity.ArmPose.NEUTRAL;
        }
        return illagerArmPose;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.shieldCooldownTime > 0) {
            --this.shieldCooldownTime;
        } else if (this.shieldCooldownTime < 0) {
            this.shieldCooldownTime = 0;
        }
    }

    @Override
    public int getShieldCooldownTime() {
        return this.shieldCooldownTime;
    }

    @Override
    public void setShieldCooldownTime(int shieldCooldownTime) {
        this.shieldCooldownTime = shieldCooldownTime;
    }

    @Override
    public void disableShield(boolean guaranteeDisable) {
        float f = 0.25f + (float)EnchantmentHelper.func_185293_e((LivingEntity)this) * 0.05f;
        if (guaranteeDisable) {
            f += 0.75f;
        }
        if (this.field_70146_Z.nextFloat() < f) {
            this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            this.shieldCooldownTime = 100;
            this.func_184602_cy();
            this.field_70170_p.func_72960_a((Entity)this, (byte)30);
        }
    }

    @Override
    public boolean isShieldDisabled() {
        return this.shieldCooldownTime > 0;
    }

    protected void func_184581_c(DamageSource damageSource) {
        if (this.func_184585_cz()) {
            this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
        } else {
            super.func_184581_c(damageSource);
        }
    }

    public void func_190629_c(LivingEntity livingEntity) {
        super.func_190629_c(livingEntity);
        if (livingEntity.func_184614_ca().canDisableShield(this.field_184627_bm, (LivingEntity)this, livingEntity)) {
            this.disableShield(true);
        }
    }

    protected void func_184590_k(float amount) {
        if (this.field_184627_bm.isShield((LivingEntity)this) && amount >= 3.0f) {
            int i = 1 + MathHelper.func_76141_d((float)amount);
            Hand hand = this.func_184600_cs();
            this.field_184627_bm.func_222118_a(i, (LivingEntity)this, royalGuardEntity -> royalGuardEntity.func_213334_d(hand));
            if (this.field_184627_bm.func_190926_b()) {
                if (hand == Hand.MAIN_HAND) {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                } else {
                    this.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
                }
                this.field_184627_bm = ItemStack.field_190927_a;
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    @Override
    public boolean isDiamond() {
        return false;
    }

    @Override
    public void setDiamond(boolean isDiamond) {
    }

    static class GuardAndAttackGoal
    extends ShieldAndMeleeAttackGoal {
        GuardAndAttackGoal(RoyalGuardEntity royalGuardEntity, double speedTowardsTarget, boolean useLongMemory) {
            super(royalGuardEntity, speedTowardsTarget, useLongMemory, 3.0, 40, 5);
        }

        protected double func_179512_a(LivingEntity livingEntity) {
            if (this.field_75441_b.func_184187_bx() instanceof RavagerEntity) {
                float width = this.field_75441_b.func_184187_bx().func_213311_cf() - 0.1f;
                return width * 2.0f * width * 2.0f + livingEntity.func_213311_cf();
            }
            return super.func_179512_a(livingEntity);
        }
    }
}

