/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.piglin;

import com.infamous.dungeons_mobs.DungeonsGearCompat;
import com.infamous.dungeons_mobs.interfaces.IArmoredMob;
import com.infamous.dungeons_mobs.mod.ModItems;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class ZombifiedArmoredPiglinEntity
extends ZombifiedPiglinEntity
implements IArmoredMob {
    private static final DataParameter<Boolean> STRONG_ARMOR = EntityDataManager.func_187226_a(ZombifiedArmoredPiglinEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public ZombifiedArmoredPiglinEntity(EntityType<? extends ZombifiedArmoredPiglinEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STRONG_ARMOR, (Object)false);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return ZombifiedPiglinEntity.func_234352_eU_().func_233815_a_(Attributes.field_233818_a_, 24.0).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233814_a_(Attributes.field_233820_c_);
    }

    public void func_82227_f(boolean baby) {
    }

    public boolean func_70631_g_() {
        return false;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.designateStrongArmor((LivingEntity)this);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        if ((double)this.field_70146_Z.nextFloat() < 0.5) {
            this.setRangedWeapon();
        } else {
            this.setMeleeWeapon();
        }
        if (this.hasStrongArmor()) {
            this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ModItems.CRACKED_GOLD_PIGLIN_HELMET.get()));
        } else if (this.func_233634_a_(item -> item instanceof CrossbowItem)) {
            this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ModItems.CRACKED_NETHERITE_PIGLIN_HELMET.get()));
        }
    }

    private void setRangedWeapon() {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_222114_py));
    }

    private void setMeleeWeapon() {
        if (DungeonsGearCompat.isLoaded()) {
            ItemStack goldAxe = new ItemStack((IItemProvider)DungeonsGearCompat.getGoldAxe().get());
            ItemStack firebrand = new ItemStack((IItemProvider)DungeonsGearCompat.getFirebrand().get());
            ItemStack mainhandWeapon = this.hasStrongArmor() ? firebrand : goldAxe;
            this.func_184201_a(EquipmentSlotType.MAINHAND, mainhandWeapon);
        } else {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151006_E));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.writeStrongArmorNBT(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.readStrongArmorNBT(compound);
    }

    @Override
    public boolean hasStrongArmor() {
        return (Boolean)this.field_70180_af.func_187225_a(STRONG_ARMOR);
    }

    @Override
    public void setStrongArmor(boolean strongArmor) {
        this.field_70180_af.func_187227_b(STRONG_ARMOR, (Object)strongArmor);
    }

    @Override
    public String getArmorName() {
        return this.hasStrongArmor() ? "gold" : "netherite";
    }
}

