/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.projectiles;

import com.infamous.dungeons_mobs.client.util.ParticleGenerator;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import com.infamous.dungeons_mobs.utils.PotionHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class BlueNethershroomEntity
extends ProjectileItemEntity
implements IRendersAsItem {
    public static final int LIGHT_BLUE_HEX_COLOR_CODE = 57599;

    public BlueNethershroomEntity(EntityType<? extends BlueNethershroomEntity> entityType, World world) {
        super(entityType, world);
    }

    public BlueNethershroomEntity(World world, LivingEntity shooter) {
        super((EntityType)ModEntityTypes.BLUE_NETHERSHROOM.get(), shooter, world);
    }

    public BlueNethershroomEntity(World world, double x, double y, double z) {
        super((EntityType)ModEntityTypes.BLUE_NETHERSHROOM.get(), x, y, z, world);
    }

    public static void setLightBluePotionColor(ItemStack itemStack) {
        PotionHelper.setColor(itemStack, 57599);
    }

    protected Item func_213885_i() {
        return (Item)ModItems.BLUE_NETHERSHROOM.get();
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    protected void func_70227_a(RayTraceResult rtr) {
        super.func_70227_a(rtr);
        ItemStack itemstack = this.func_184543_l();
        Potion potion = PotionUtils.func_185191_c((ItemStack)itemstack);
        List list = PotionUtils.func_185189_a((ItemStack)itemstack);
        if (!list.isEmpty()) {
            if (!this.field_70170_p.field_72995_K) {
                Entity target = null;
                if (rtr instanceof EntityRayTraceResult) {
                    target = ((EntityRayTraceResult)rtr).func_216348_a();
                }
                this.makeAreaOfEffectCloud(target, itemstack, potion);
                this.func_70106_y();
            } else {
                BlockPos blockPos = this.func_233580_cy_();
                int color = PotionUtils.func_185183_a((Potion)potion);
                CompoundNBT tag = itemstack.func_77978_p();
                if (tag != null && tag.func_150297_b("CustomPotionColor", 99)) {
                    color = tag.func_74762_e("CustomPotionColor");
                }
                ParticleGenerator.generatePotionImpact(this.field_70170_p, potion, this.func_184543_l(), blockPos, color, SoundEvents.field_232748_iQ_);
            }
        }
    }

    private void makeAreaOfEffectCloud(@Nullable Entity target, ItemStack itemStack, Potion potion) {
        AreaEffectCloudEntity aoeCloud = new AreaEffectCloudEntity(this.field_70170_p, target != null ? target.func_226277_ct_() : this.func_226277_ct_(), target != null ? target.func_226278_cu_() : this.func_226278_cu_(), target != null ? target.func_226281_cx_() : this.func_226281_cx_());
        Entity owner = this.func_234616_v_();
        if (owner instanceof LivingEntity) {
            aoeCloud.func_184481_a((LivingEntity)owner);
        }
        aoeCloud.func_184483_a(3.0f);
        aoeCloud.func_184495_b(-0.5f);
        aoeCloud.func_184485_d(10);
        aoeCloud.func_184487_c(-aoeCloud.func_184490_j() / (float)aoeCloud.func_184489_o());
        aoeCloud.func_184484_a(potion);
        for (EffectInstance effectinstance : PotionUtils.func_185190_b((ItemStack)itemStack)) {
            aoeCloud.func_184496_a(new EffectInstance(effectinstance));
        }
        CompoundNBT compoundnbt = itemStack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_150297_b("CustomPotionColor", 99)) {
            aoeCloud.func_184482_a(compoundnbt.func_74762_e("CustomPotionColor"));
        }
        this.field_70170_p.func_217376_c((Entity)aoeCloud);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

